/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.PetalApothecaryRecipe;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.RecipeSerializerBase;

public class PetalsRecipe
implements PetalApothecaryRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final Ingredient reagent;
    private final NonNullList<Ingredient> inputs;

    public PetalsRecipe(ResourceLocation id, ItemStack output, Ingredient reagent, Ingredient ... inputs) {
        Preconditions.checkArgument((inputs.length <= 16 ? 1 : 0) != 0, (Object)"Cannot have more than 16 ingredients");
        this.id = id;
        this.output = output;
        this.reagent = reagent;
        this.inputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])inputs);
    }

    @Override
    public Ingredient getReagent() {
        return this.reagent;
    }

    public boolean m_5818_(Container inv, @NotNull Level world) {
        ItemStack input;
        ArrayList<Ingredient> ingredientsMissing = new ArrayList<Ingredient>((Collection<Ingredient>)this.inputs);
        for (int i = 0; i < inv.m_6643_() && !(input = inv.m_8020_(i)).m_41619_(); ++i) {
            int stackIndex = -1;
            for (int j = 0; j < ingredientsMissing.size(); ++j) {
                Ingredient ingr = (Ingredient)ingredientsMissing.get(j);
                if (!ingr.test(input)) continue;
                stackIndex = j;
                break;
            }
            if (stackIndex == -1) {
                return false;
            }
            ingredientsMissing.remove(stackIndex);
        }
        return ingredientsMissing.isEmpty();
    }

    @NotNull
    public final ItemStack m_8043_() {
        return this.output;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container inv) {
        return this.m_8043_().m_41777_();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    @NotNull
    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)BotaniaBlocks.defaultAltar);
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return BotaniaRecipeTypes.PETAL_SERIALIZER;
    }

    public static class Serializer
    extends RecipeSerializerBase<PetalsRecipe> {
        @NotNull
        public PetalsRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            Ingredient reagent = Ingredient.m_43917_((JsonElement)json.get("reagent"));
            JsonArray ingrs = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            for (JsonElement e : ingrs) {
                inputs.add(Ingredient.m_43917_((JsonElement)e));
            }
            return new PetalsRecipe(id, output, reagent, inputs.toArray(new Ingredient[0]));
        }

        public PetalsRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            Ingredient[] inputs = new Ingredient[buf.m_130242_()];
            for (int i = 0; i < inputs.length; ++i) {
                inputs[i] = Ingredient.m_43940_((FriendlyByteBuf)buf);
            }
            Ingredient reagent = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack output = buf.m_130267_();
            return new PetalsRecipe(id, output, reagent, inputs);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull PetalsRecipe recipe) {
            buf.m_130130_(recipe.m_7527_().size());
            for (Ingredient input : recipe.m_7527_()) {
                input.m_43923_(buf);
            }
            recipe.reagent.m_43923_(buf);
            buf.m_130055_(recipe.m_8043_());
        }
    }
}

