/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.forge.xplat;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.block.ExoflameHeatable;
import vazkii.botania.api.block.HornHarvestable;
import vazkii.botania.api.block.HourglassTrigger;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.corporea.CorporeaIndexRequestEvent;
import vazkii.botania.api.corporea.CorporeaRequestEvent;
import vazkii.botania.api.corporea.CorporeaRequestMatcher;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.api.item.AvatarWieldable;
import vazkii.botania.api.item.BlockProvider;
import vazkii.botania.api.item.CoordBoundItem;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaCollisionGhost;
import vazkii.botania.api.mana.ManaDiscountEvent;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaItemsEvent;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.api.mana.ManaNetworkEvent;
import vazkii.botania.api.mana.ManaProficiencyEvent;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.api.recipe.ElvenPortalUpdateEvent;
import vazkii.botania.common.block.block_entity.red_string.RedStringContainerBlockEntity;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.internal_caps.EthicalComponent;
import vazkii.botania.common.internal_caps.ItemFlagsComponent;
import vazkii.botania.common.internal_caps.KeptItemsComponent;
import vazkii.botania.common.internal_caps.LooniumComponent;
import vazkii.botania.common.internal_caps.NarslimmusComponent;
import vazkii.botania.common.internal_caps.SpectralRailComponent;
import vazkii.botania.common.internal_caps.TigerseyeComponent;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.forge.CapabilityUtil;
import vazkii.botania.forge.ForgeBotaniaCreativeTab;
import vazkii.botania.forge.block.ForgeSpecialFlowerBlock;
import vazkii.botania.forge.integration.curios.CurioIntegration;
import vazkii.botania.forge.internal_caps.ForgeInternalEntityCapabilities;
import vazkii.botania.forge.mixin.AbstractFurnaceBlockEntityForgeAccessor;
import vazkii.botania.forge.mixin.RecipeProviderForgeAccessor;
import vazkii.botania.forge.mixin.RegistryForgeAccessor;
import vazkii.botania.forge.network.ForgePacketHandler;
import vazkii.botania.network.BotaniaPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class ForgeXplatImpl
implements XplatAbstractions {
    private static final PacketDistributor<Pair<Level, BlockPos>> TRACKING_CHUNK_AND_NEAR = new PacketDistributor((_d, pairSupplier) -> {
        Pair pair = (Pair)pairSupplier.get();
        Level level = (Level)pair.getFirst();
        BlockPos blockpos = (BlockPos)pair.getSecond();
        ChunkPos chunkpos = new ChunkPos(blockpos);
        return packet -> {
            List players = ((ServerChunkCache)level.m_7726_()).f_8325_.m_183262_(chunkpos, false);
            for (ServerPlayer player : players) {
                if (!(player.m_20275_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_()) < 4096.0)) continue;
                player.f_8906_.m_9829_(packet);
            }
        };
    }, NetworkDirection.PLAY_TO_CLIENT);
    public static final Map<Block, Block> CUSTOM_STRIPPABLES = new HashMap<Block, Block>();

    @Override
    public boolean isForge() {
        return true;
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean isDevEnvironment() {
        return !FMLLoader.isProduction();
    }

    @Override
    public boolean isPhysicalClient() {
        return FMLLoader.getDist() == Dist.CLIENT;
    }

    @Override
    public String getBotaniaVersion() {
        return ((ModContainer)ModList.get().getModContainerById("botania").get()).getModInfo().getVersion().toString();
    }

    @Override
    @Nullable
    public AvatarWieldable findAvatarWieldable(ItemStack stack) {
        return (AvatarWieldable)stack.getCapability(BotaniaForgeCapabilities.AVATAR_WIELDABLE).orElse(null);
    }

    @Override
    @Nullable
    public BlockProvider findBlockProvider(ItemStack stack) {
        return (BlockProvider)stack.getCapability(BotaniaForgeCapabilities.BLOCK_PROVIDER).orElse(null);
    }

    @Override
    @Nullable
    public CoordBoundItem findCoordBoundItem(ItemStack stack) {
        return (CoordBoundItem)stack.getCapability(BotaniaForgeCapabilities.COORD_BOUND_ITEM).orElse(null);
    }

    @Override
    @Nullable
    public ManaItem findManaItem(ItemStack stack) {
        return (ManaItem)stack.getCapability(BotaniaForgeCapabilities.MANA_ITEM).orElse(null);
    }

    @Override
    @Nullable
    public Relic findRelic(ItemStack stack) {
        return (Relic)stack.getCapability(BotaniaForgeCapabilities.RELIC).orElse(null);
    }

    @Override
    @Nullable
    public ExoflameHeatable findExoflameHeatable(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity be) {
        return CapabilityUtil.findCapability(BotaniaForgeCapabilities.EXOFLAME_HEATABLE, level, pos, state, be);
    }

    @Override
    @Nullable
    public HornHarvestable findHornHarvestable(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity be) {
        return CapabilityUtil.findCapability(BotaniaForgeCapabilities.HORN_HARVEST, level, pos, state, be);
    }

    @Override
    @Nullable
    public HourglassTrigger findHourglassTrigger(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity be) {
        return CapabilityUtil.findCapability(BotaniaForgeCapabilities.HOURGLASS_TRIGGER, level, pos, state, be);
    }

    @Override
    @Nullable
    public ManaCollisionGhost findManaGhost(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity be) {
        return CapabilityUtil.findCapability(BotaniaForgeCapabilities.MANA_GHOST, level, pos, state, be);
    }

    @Override
    @Nullable
    public ManaReceiver findManaReceiver(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity be, @Nullable Direction direction) {
        return CapabilityUtil.findCapability(BotaniaForgeCapabilities.MANA_RECEIVER, level, pos, state, be, direction);
    }

    @Override
    @Nullable
    public SparkAttachable findSparkAttachable(Level level, BlockPos pos, BlockState blockState, @Nullable BlockEntity be, Direction direction) {
        return CapabilityUtil.findCapability(BotaniaForgeCapabilities.SPARK_ATTACHABLE, level, pos, blockState, be, direction);
    }

    @Override
    @Nullable
    public ManaTrigger findManaTrigger(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity be) {
        return CapabilityUtil.findCapability(BotaniaForgeCapabilities.MANA_TRIGGER, level, pos, state, be);
    }

    @Override
    @Nullable
    public Wandable findWandable(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity be) {
        return CapabilityUtil.findCapability(BotaniaForgeCapabilities.WANDABLE, level, pos, state, be);
    }

    @Override
    public boolean isFluidContainer(ItemEntity item) {
        return item.m_32055_().getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
    }

    @Override
    public boolean extractFluidFromItemEntity(ItemEntity item, Fluid fluid) {
        return item.m_32055_().getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(h -> {
            boolean success;
            FluidStack extracted = h.drain(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            boolean bl = success = extracted.getFluid() == fluid && extracted.getAmount() == 1000;
            if (success) {
                item.m_32045_(h.getContainer());
            }
            return success;
        }).orElse(false);
    }

    @Override
    public boolean extractFluidFromPlayerItem(Player player, InteractionHand hand, Fluid fluid) {
        ItemStack stack = player.m_21120_(hand);
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(h -> {
            boolean success;
            FluidStack extracted = h.drain(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            boolean bl = success = extracted.getFluid() == fluid && extracted.getAmount() == 1000;
            if (success && !player.m_150110_().f_35937_) {
                player.m_21008_(hand, h.getContainer());
            }
            return success;
        }).orElse(false);
    }

    @Override
    public boolean insertFluidIntoPlayerItem(Player player, InteractionHand hand, Fluid fluid) {
        FluidStack fluidToFill;
        IFluidHandlerItem fluidHandler;
        int filled;
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_()) {
            return false;
        }
        ItemStack toFill = stack.m_41777_();
        toFill.m_41764_(1);
        LazyOptional maybeFluidHandler = toFill.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM);
        if (maybeFluidHandler.isPresent() && (filled = (fluidHandler = (IFluidHandlerItem)maybeFluidHandler.orElseThrow(IllegalStateException::new)).fill(fluidToFill = new FluidStack(fluid, 1000), IFluidHandler.FluidAction.SIMULATE)) == 1000) {
            fluidHandler.fill(fluidToFill, IFluidHandler.FluidAction.EXECUTE);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
                ItemStack result = fluidHandler.getContainer();
                if (stack.m_41619_()) {
                    player.m_21008_(hand, result);
                } else {
                    player.m_150109_().m_150079_(result);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasInventory(Level level, BlockPos pos, Direction sideOfPos) {
        WorldlyContainerHolder wch;
        Block block;
        BlockState state = level.m_8055_(pos);
        BlockEntity be = level.m_7702_(pos);
        return be != null && be.getCapability(ForgeCapabilities.ITEM_HANDLER, sideOfPos).isPresent() || (block = state.m_60734_()) instanceof WorldlyContainerHolder && (wch = (WorldlyContainerHolder)block).m_5840_(state, (LevelAccessor)level, pos).m_7071_(sideOfPos).length > 0;
    }

    @Override
    public ItemStack insertToInventory(Level level, BlockPos pos, Direction sideOfPos, ItemStack toInsert, boolean simulate) {
        BlockEntity be = level.m_7702_(pos);
        LazyOptional cap = LazyOptional.empty();
        if (be != null) {
            cap = be.getCapability(ForgeCapabilities.ITEM_HANDLER, sideOfPos);
        } else {
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            if (block instanceof WorldlyContainerHolder) {
                WorldlyContainerHolder wch = (WorldlyContainerHolder)block;
                cap = LazyOptional.of(() -> new SidedInvWrapper(wch.m_5840_(state, (LevelAccessor)level, pos), sideOfPos));
            }
        }
        return cap.map(handler -> ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)toInsert, (boolean)simulate)).orElse(toInsert);
    }

    @Override
    public EthicalComponent ethicalComponent(PrimedTnt tnt) {
        return (EthicalComponent)tnt.getCapability(ForgeInternalEntityCapabilities.TNT_ETHICAL).orElseThrow(IllegalStateException::new);
    }

    @Override
    public SpectralRailComponent ghostRailComponent(AbstractMinecart cart) {
        return (SpectralRailComponent)cart.getCapability(ForgeInternalEntityCapabilities.GHOST_RAIL).orElseThrow(IllegalStateException::new);
    }

    @Override
    public ItemFlagsComponent itemFlagsComponent(ItemEntity item) {
        return (ItemFlagsComponent)item.getCapability(ForgeInternalEntityCapabilities.INTERNAL_ITEM).orElseGet(ItemFlagsComponent::new);
    }

    @Override
    public KeptItemsComponent keptItemsComponent(Player player, boolean reviveCaps) {
        if (reviveCaps) {
            player.reviveCaps();
        }
        KeptItemsComponent ret = (KeptItemsComponent)player.getCapability(ForgeInternalEntityCapabilities.KEPT_ITEMS).orElseThrow(IllegalStateException::new);
        if (reviveCaps) {
            player.invalidateCaps();
        }
        return ret;
    }

    @Override
    @Nullable
    public LooniumComponent looniumComponent(LivingEntity entity) {
        return (LooniumComponent)entity.getCapability(ForgeInternalEntityCapabilities.LOONIUM_DROP).orElse(null);
    }

    @Override
    public NarslimmusComponent narslimmusComponent(Slime slime) {
        return (NarslimmusComponent)slime.getCapability(ForgeInternalEntityCapabilities.NARSLIMMUS).orElseThrow(IllegalStateException::new);
    }

    @Override
    public TigerseyeComponent tigersEyeComponent(Creeper creeper) {
        return (TigerseyeComponent)creeper.getCapability(ForgeInternalEntityCapabilities.TIGERSEYE).orElseThrow(IllegalStateException::new);
    }

    @Override
    public boolean fireCorporeaRequestEvent(CorporeaRequestMatcher matcher, int itemCount, CorporeaSpark spark, boolean dryRun) {
        return MinecraftForge.EVENT_BUS.post((Event)new CorporeaRequestEvent(matcher, itemCount, spark, dryRun));
    }

    @Override
    public boolean fireCorporeaIndexRequestEvent(ServerPlayer player, CorporeaRequestMatcher request, int count, CorporeaSpark spark) {
        return MinecraftForge.EVENT_BUS.post((Event)new CorporeaIndexRequestEvent(player, request, count, spark));
    }

    @Override
    public void fireManaItemEvent(Player player, List<ItemStack> toReturn) {
        MinecraftForge.EVENT_BUS.post((Event)new ManaItemsEvent(player, toReturn));
    }

    @Override
    public float fireManaDiscountEvent(Player player, float discount, ItemStack tool) {
        ManaDiscountEvent evt = new ManaDiscountEvent(player, discount, tool);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.getDiscount();
    }

    @Override
    public boolean fireManaProficiencyEvent(Player player, ItemStack tool, boolean proficient) {
        ManaProficiencyEvent evt = new ManaProficiencyEvent(player, tool, proficient);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        return evt.isProficient();
    }

    @Override
    public void fireElvenPortalUpdateEvent(BlockEntity portal, AABB bounds, boolean open, List<ItemStack> stacksInside) {
        MinecraftForge.EVENT_BUS.post((Event)new ElvenPortalUpdateEvent(portal, bounds, open, stacksInside));
    }

    @Override
    public void fireManaNetworkEvent(ManaReceiver thing, ManaBlockType type, ManaNetworkAction action) {
        MinecraftForge.EVENT_BUS.post((Event)new ManaNetworkEvent(thing, type, action));
    }

    @Override
    public Packet<?> toVanillaClientboundPacket(BotaniaPacket packet) {
        return ForgePacketHandler.CHANNEL.toVanillaPacket((Object)packet, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    public void sendToPlayer(Player player, BotaniaPacket packet) {
        if (!player.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ForgePacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)packet);
        }
    }

    @Override
    public void sendToNear(Level level, BlockPos pos, BotaniaPacket packet) {
        if (!level.f_46443_) {
            ForgePacketHandler.CHANNEL.send(TRACKING_CHUNK_AND_NEAR.with(() -> Pair.of((Object)level, (Object)pos)), (Object)packet);
        }
    }

    @Override
    public void sendToTracking(Entity e, BotaniaPacket packet) {
        if (!e.m_9236_().f_46443_) {
            ForgePacketHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> e), (Object)packet);
        }
    }

    @Override
    public boolean isSpecialFlowerBlock(Block b) {
        return b instanceof ForgeSpecialFlowerBlock;
    }

    @Override
    public FlowerBlock createSpecialFlowerBlock(MobEffect effect, int effectDuration, BlockBehaviour.Properties props, Supplier<BlockEntityType<? extends SpecialFlowerBlockEntity>> beType) {
        return new ForgeSpecialFlowerBlock(effect, effectDuration, props, beType);
    }

    @Override
    public <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BiFunction<BlockPos, BlockState, T> func, Block ... blocks) {
        return BlockEntityType.Builder.m_155273_(func::apply, (Block[])blocks).m_58966_(null);
    }

    @Override
    public void registerReloadListener(PackType type, ResourceLocation id, PreparableReloadListener listener) {
        switch (type) {
            case CLIENT_RESOURCES: {
                MinecraftForge.EVENT_BUS.addListener(e -> e.registerReloadListener(listener));
                break;
            }
            case SERVER_DATA: {
                MinecraftForge.EVENT_BUS.addListener(e -> e.addListener(listener));
            }
        }
    }

    @Override
    public Item.Properties defaultItemBuilder() {
        return new Item.Properties().m_41491_((CreativeModeTab)ForgeBotaniaCreativeTab.INSTANCE);
    }

    @Override
    public Item.Properties noRepairOnForge(Item.Properties builder) {
        return builder.setNoRepair();
    }

    @Override
    public <T extends AbstractContainerMenu> MenuType<T> createMenuType(TriFunction<Integer, Inventory, FriendlyByteBuf, T> constructor) {
        return IForgeMenuType.create((arg_0, arg_1, arg_2) -> constructor.apply(arg_0, arg_1, arg_2));
    }

    @Override
    public Registry<Brew> getOrCreateBrewRegistry() {
        return RegistryHolder.BREW;
    }

    @Override
    @Nullable
    public EquipmentHandler tryCreateEquipmentHandler() {
        if (XplatAbstractions.INSTANCE.isModLoaded("curios")) {
            CurioIntegration.init();
            return new CurioIntegration();
        }
        return null;
    }

    @Override
    public void openMenu(ServerPlayer player, MenuProvider menu, Consumer<FriendlyByteBuf> writeInitialData) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)menu, writeInitialData);
    }

    @Override
    public Attribute getReachDistanceAttribute() {
        return (Attribute)ForgeMod.REACH_DISTANCE.get();
    }

    @Override
    public Attribute getStepHeightAttribute() {
        return (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get();
    }

    @Override
    public TagKey<Block> getOreTag() {
        return Tags.Blocks.ORES;
    }

    @Override
    public boolean isInGlassTag(BlockState state) {
        return state.m_204336_(Tags.Blocks.GLASS);
    }

    @Override
    public boolean canFurnaceBurn(AbstractFurnaceBlockEntity furnace, @Nullable Recipe<?> recipe, NonNullList<ItemStack> items, int maxStackSize) {
        return ((AbstractFurnaceBlockEntityForgeAccessor)furnace).callCanBurn(recipe, items, maxStackSize);
    }

    @Override
    public void saveRecipeAdvancement(DataGenerator generator, CachedOutput cache, JsonObject json, Path path) {
        ((RecipeProviderForgeAccessor)new RecipeProvider(generator)).callSaveRecipeAdvancement(cache, json, path);
    }

    @Override
    public Fluid getBucketFluid(BucketItem item) {
        return item.getFluid();
    }

    @Override
    public int getSmeltingBurnTime(ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_);
    }

    @Override
    public boolean preventsRemoteMovement(ItemEntity entity) {
        return entity.getPersistentData().m_128471_("PreventRemoteMovement");
    }

    @Override
    public void addAxeStripping(Block input, Block output) {
        CUSTOM_STRIPPABLES.put(input, output);
    }

    @Override
    public int transferEnergyToNeighbors(Level level, BlockPos pos, int energy) {
        for (Direction e : Direction.values()) {
            BlockEntity be;
            BlockPos neighbor = pos.m_121945_(e);
            if (!level.m_46805_(neighbor) || (be = level.m_7702_(neighbor)) == null) continue;
            LazyOptional storage = LazyOptional.empty();
            if (be.getCapability(ForgeCapabilities.ENERGY, e.m_122424_()).isPresent()) {
                storage = be.getCapability(ForgeCapabilities.ENERGY, e.m_122424_());
            } else if (be.getCapability(ForgeCapabilities.ENERGY, null).isPresent()) {
                storage = be.getCapability(ForgeCapabilities.ENERGY, null);
            }
            if (!storage.isPresent() || (energy -= ((IEnergyStorage)storage.orElseThrow(NullPointerException::new)).receiveEnergy(energy, false)) > 0) continue;
            return 0;
        }
        return energy;
    }

    @Override
    public boolean isRedStringContainerTarget(BlockEntity be) {
        for (Direction dir : Direction.values()) {
            if (!be.getCapability(ForgeCapabilities.ITEM_HANDLER, dir).isPresent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RedStringContainerBlockEntity newRedStringContainer(BlockPos pos, BlockState state) {
        return new RedStringContainerBlockEntity(pos, state);
    }

    private static class RegistryHolder {
        public static final Registry<Brew> BREW = RegistryForgeAccessor.callRegisterDefaulted(ResourceKey.m_135788_((ResourceLocation)ResourceLocationHelper.prefix("brews")), "botania:fallback", registry -> BotaniaBrews.fallbackBrew);

        private RegistryHolder() {
        }
    }
}

