/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.darkmodeeverywhere;

import com.buuz135.darkmodeeverywhere.ClientProxy;
import com.buuz135.darkmodeeverywhere.DarkModeEverywhere;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ShaderConfig {
    private List<ShaderValue> shaders = new ArrayList<ShaderValue>();
    private int version = 2;
    private int selectedShaderIndex;
    private static final File configFilePath = new File("config" + File.separator + "darkmodeeverywhereshaders.json");

    public ShaderConfig() {
        ResourceLocation tex_shader_location = new ResourceLocation("darkmodeeverywhere", "dark_position_tex");
        ResourceLocation tex_color_shader_location = new ResourceLocation("darkmodeeverywhere", "dark_position_tex_color");
        this.shaders.add(null);
        this.shaders.add(new ShaderValue(tex_shader_location, tex_color_shader_location, Component.m_237115_((String)"gui.darkmodeeverywhere.perfect_dark"), 5.5f, 0xFFFFFF));
        this.shaders.add(new ShaderValue(tex_shader_location, tex_color_shader_location, Component.m_237115_((String)"gui.darkmodeeverywhere.less_perfect_dark"), 3.5f, 0xFFFFFF));
        this.shaders.add(new ShaderValue(tex_shader_location, tex_color_shader_location, Component.m_237115_((String)"gui.darkmodeeverywhere.toasted_light"), 2.0f, 0xFFFFFF));
        this.selectedShaderIndex = 0;
    }

    public List<ShaderValue> getShaders() {
        return this.shaders;
    }

    public void setSelectedShaderIndex(int index) {
        this.selectedShaderIndex = index;
        DarkModeEverywhere.LOGGER.debug("Selected shader index updated to {}", (Object)this.selectedShaderIndex);
        new Thread(ShaderConfig::createDefaultConfigFile).start();
    }

    public int getSelectedShaderIndex() {
        return this.selectedShaderIndex;
    }

    private static Gson createGson() {
        return new GsonBuilder().setPrettyPrinting().registerTypeAdapter(MutableComponent.class, (Object)new Component.Serializer()).create();
    }

    public static void load() {
        if (!configFilePath.exists()) {
            ShaderConfig.createDefaultConfigFile();
        }
        Gson gson = ShaderConfig.createGson();
        try (FileReader reader = new FileReader(configFilePath);){
            ClientProxy.CONFIG = (ShaderConfig)gson.fromJson((Reader)reader, ShaderConfig.class);
            if (ClientProxy.CONFIG.version != new ShaderConfig().version) {
                throw new Exception("Invalid config version.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientProxy.CONFIG = new ShaderConfig();
            ShaderConfig.createDefaultConfigFile();
        }
    }

    private static void createDefaultConfigFile() {
        Gson gson = ShaderConfig.createGson();
        try (FileWriter fileWriter = new FileWriter(configFilePath);){
            gson.toJson((Object)ClientProxy.CONFIG, (Appendable)fileWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class ShaderValue {
        public ResourceLocation texShaderLocation;
        public ResourceLocation texColorShaderLocation;
        public MutableComponent displayName;
        public float divideFactor;
        public int darkColorReplacement;

        public ShaderValue(ResourceLocation texShaderLocation, ResourceLocation texColorShaderLocation, MutableComponent displayName, float divideFactor, int darkColorReplacement) {
            this.texShaderLocation = texShaderLocation;
            this.texColorShaderLocation = texColorShaderLocation;
            this.displayName = displayName;
            this.divideFactor = divideFactor;
            this.darkColorReplacement = darkColorReplacement;
        }
    }
}

