/*
 * Decompiled with CFR 0.152.
 */
package net.brnbrd.delightful.compat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.brnbrd.delightful.Util;
import net.brnbrd.delightful.common.item.DelightfulItems;
import net.brnbrd.delightful.common.item.IConfigured;
import net.brnbrd.delightful.common.item.knife.DelightfulKnifeItem;
import net.brnbrd.delightful.compat.Mods;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.tag.ForgeTags;
import vectorwing.farmersdelight.common.utility.TextUtils;

@ParametersAreNonnullByDefault
@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = Util.rl("delightful", "jei_plugin");
    private static final Minecraft MC = Minecraft.m_91087_();

    public void registerRecipes(IRecipeRegistration registration) {
        List<ItemStack> remove = DelightfulItems.ITEMS.getEntries().stream().filter(i -> {
            IConfigured c;
            Object patt1836$temp = i.get();
            return patt1836$temp instanceof IConfigured ? !(c = (IConfigured)patt1836$temp).isEnabled() : !Util.enabled((RegistryObject<Item>)i);
        }).map(Util::gs).toList();
        registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, remove);
        this.registerAnvilRecipes(registration);
        DelightfulItems.ITEMS.getEntries().stream().map(RegistryObject::get).filter(k -> k instanceof DelightfulKnifeItem && ((DelightfulKnifeItem)k).isEnabled()).map(ItemStack::new).forEach(k -> registration.addIngredientInfo(k, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TextUtils.getTranslation((String)"jei.info.knife", (Object[])new Object[0])}));
        if (Util.enabled(DelightfulItems.GREEN_TEA_LEAF) && !Mods.loaded("farmersrespite")) {
            registration.addIngredientInfo((Object)((Item)DelightfulItems.GREEN_TEA_LEAF.get()).m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.green_tea_leaf.desc")});
        }
        if (Util.enabled(DelightfulItems.ACORN)) {
            registration.addIngredientInfo((Object)Util.gs(DelightfulItems.ACORN), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.acorn.desc")});
        }
        if (Util.enabled(DelightfulItems.SALMONBERRIES)) {
            registration.addIngredientInfo((Object)Util.gs(DelightfulItems.SALMONBERRIES), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.salmonberries.desc")});
        }
        if (Util.enabled(DelightfulItems.MINI_MELON)) {
            registration.addIngredientInfo((Object)Util.gs(DelightfulItems.MINI_MELON), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.mini_melon.desc")});
        }
        if (Util.enabled(DelightfulItems.CANTALOUPE)) {
            registration.addIngredientInfo((Object)Util.gs(DelightfulItems.CANTALOUPE), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.cantaloupe.desc").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"delightful.sliceable.desc"))});
        }
        if (Util.enabled(DelightfulItems.ANIMAL_FAT)) {
            registration.addIngredientInfo((Object)Util.gs(DelightfulItems.ANIMAL_FAT), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.animal_fat.desc")});
        }
        if (Util.enabled(DelightfulItems.ANIMAL_OIL_BOTTLE)) {
            registration.addIngredientInfo((Object)Util.gs(DelightfulItems.ANIMAL_OIL_BOTTLE), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.animal_oil_bottle.desc")});
        }
        registration.addIngredientInfo((Object)Items.f_42028_.m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.sliceable.desc")});
        registration.addIngredientInfo((Object)Items.f_42046_.m_7968_(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"delightful.sliceable.desc")});
    }

    private void registerAnvilRecipes(@Nonnull IRecipeRegistration registration) {
        IVanillaRecipeFactory fact = registration.getVanillaRecipeFactory();
        ArrayList repairs = new ArrayList();
        DelightfulItems.ITEMS.getEntries().stream().map(RegistryObject::get).filter(k -> k instanceof DelightfulKnifeItem && ((DelightfulKnifeItem)k).isEnabled() && ((DelightfulKnifeItem)k).getTag() != null).map(ItemStack::new).forEach(k -> this.addAnvils(repairs, fact, (ItemStack)k));
        ForgeRegistries.ITEMS.tags().getTag(ForgeTags.TOOLS_KNIVES).stream().filter(k -> !(k instanceof DelightfulKnifeItem)).map(ItemStack::new).forEach(k -> this.addAnvils(repairs, fact, (ItemStack)k));
        registration.addRecipes(RecipeTypes.ANVIL, repairs);
    }

    private void addAnvils(List<IJeiAnvilRecipe> repairs, IVanillaRecipeFactory factory, ItemStack input) {
        Item item = input.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem knifeItem = (TieredItem)item;
            ItemStack out = input.m_41777_();
            ItemStack combined = input.m_41777_();
            int max = input.m_41776_();
            input.m_41721_(max - 1);
            out.m_41721_(max - (int)Math.ceil((double)max / 4.0));
            combined.m_41721_(max - (int)Math.ceil((double)max / 2.0));
            repairs.add(factory.createAnvilRecipe(out, Collections.singletonList(out), Collections.singletonList(combined)));
            repairs.add(factory.createAnvilRecipe(input, Arrays.asList(knifeItem.m_43314_().m_6282_().m_43908_()), Collections.singletonList(out)));
        }
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }
}

