/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.dimstorage.client.screen.element.button.AutoEjectButton;
import edivad.dimstorage.client.screen.pattern.FrequencyScreen;
import edivad.dimstorage.container.ContainerDimTank;
import edivad.edivadlib.tools.utils.FluidUtils;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;

public class ScreenDimTank
extends FrequencyScreen<ContainerDimTank> {
    private static final ResourceLocation DIMTANK_GUI = new ResourceLocation("dimstorage", "textures/gui/dimtank.png");
    private static final MutableComponent LIQUID = Component.m_237115_((String)"gui.dimstorage.liquid");
    private static final MutableComponent AMOUNT = Component.m_237115_((String)"gui.dimstorage.amount");
    private static final MutableComponent TEMPERATURE = Component.m_237115_((String)"gui.dimstorage.temperature");
    private static final MutableComponent LUMINOSITY = Component.m_237115_((String)"gui.dimstorage.luminosity");
    private static final MutableComponent GASEOUS = Component.m_237115_((String)"gui.dimstorage.gas");
    private static final MutableComponent EMPTY = Component.m_237115_((String)"gui.dimstorage.empty");
    private static final MutableComponent YES = Component.m_237115_((String)"gui.dimstorage.yes");
    private static final MutableComponent NO = Component.m_237115_((String)"gui.dimstorage.no");

    public ScreenDimTank(ContainerDimTank container, Inventory inventory, Component text) {
        super(container, container.owner, inventory, text, DIMTANK_GUI, container.isOpen);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.addComponent((AbstractWidget)new AutoEjectButton(this.f_96543_ / 2 + 95, this.f_96544_ / 2 + 75, (BlockEntityDimTank)this.blockEntityFrequencyOwner));
        this.drawSettings(this.drawSettings);
    }

    @Override
    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        super.m_7027_(poseStack, mouseX, mouseY);
        FluidStack liquidStack = ((BlockEntityDimTank)this.blockEntityFrequencyOwner).liquidState.clientLiquid;
        if (!liquidStack.isEmpty()) {
            FluidType fluidType = liquidStack.getFluid().getFluidType();
            String liquidName = liquidStack.getDisplayName().getString();
            this.f_96547_.m_92889_(poseStack, (Component)LIQUID.m_6881_().m_130946_(" " + liquidName.substring(0, Math.min(14, liquidName.length()))), 50.0f, 25.0f, 0x404040);
            this.f_96547_.m_92889_(poseStack, (Component)AMOUNT.m_6881_().m_130946_(" " + liquidStack.getAmount() + " mB"), 50.0f, 35.0f, 0x404040);
            this.f_96547_.m_92889_(poseStack, (Component)TEMPERATURE.m_6881_().m_130946_(" " + (fluidType.getTemperature() - 273) + "C"), 50.0f, 45.0f, 0x404040);
            this.f_96547_.m_92889_(poseStack, (Component)LUMINOSITY.m_6881_().m_130946_(" " + fluidType.getLightLevel()), 50.0f, 55.0f, 0x404040);
            this.f_96547_.m_92889_(poseStack, (Component)GASEOUS.m_6881_().m_130946_(" " + (fluidType.isLighterThanAir() ? YES : NO)), 50.0f, 65.0f, 0x404040);
        } else {
            this.f_96547_.m_92889_(poseStack, (Component)LIQUID.m_6881_().m_130946_(" ").m_7220_((Component)EMPTY), 50.0f, 25.0f, 0x404040);
        }
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        FluidStack fluid = ((BlockEntityDimTank)this.blockEntityFrequencyOwner).liquidState.clientLiquid;
        int z = ScreenDimTank.getFluidScaled(60, fluid.getAmount());
        TextureAtlasSprite fluidTexture = FluidUtils.getFluidTexture((FluidStack)fluid);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        FluidUtils.color((int)FluidUtils.getLiquidColorWithBiome((FluidStack)fluid, (BlockEntity)this.blockEntityFrequencyOwner));
        ScreenDimTank.m_93200_((PoseStack)poseStack, (int)(this.f_97735_ + 11), (int)(this.f_97736_ + 21 + z), (int)176, (int)16, (int)(60 - z), (TextureAtlasSprite)fluidTexture);
    }

    private static int getFluidScaled(int pixels, int currentLiquidAmount) {
        int maxLiquidAmount = 16000;
        int x = currentLiquidAmount * pixels / maxLiquidAmount;
        return pixels - x;
    }
}

