/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.compat.top;

import edivad.dimstorage.api.Frequency;
import edivad.dimstorage.blockentities.BlockEntityDimTank;
import edivad.dimstorage.blockentities.BlockEntityFrequencyOwner;
import edivad.dimstorage.compat.top.MyFluidElement;
import java.util.function.Function;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TOPProvider
implements IProbeInfoProvider,
Function<ITheOneProbe, Void> {
    @Override
    public Void apply(ITheOneProbe probe) {
        probe.registerProvider((IProbeInfoProvider)this);
        probe.registerElementFactory(new IElementFactory(){

            public IElement createElement(FriendlyByteBuf friendlyByteBuf) {
                return new MyFluidElement(friendlyByteBuf);
            }

            public ResourceLocation getId() {
                return MyFluidElement.ID;
            }
        });
        return null;
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level level, BlockState state, IProbeHitData data) {
        BlockEntity te = level.m_7702_(data.getPos());
        if (te instanceof BlockEntityFrequencyOwner) {
            BlockEntityFrequencyOwner frequencyOwner = (BlockEntityFrequencyOwner)te;
            MutableComponent locked = Component.m_237115_((String)"gui.dimstorage.locked");
            MutableComponent yes = Component.m_237115_((String)"gui.dimstorage.yes");
            MutableComponent eject = Component.m_237115_((String)"gui.dimstorage.eject");
            MutableComponent owner = Component.m_237115_((String)"gui.dimstorage.owner");
            MutableComponent frequency = Component.m_237115_((String)"gui.dimstorage.frequency");
            Frequency blockFrequency = frequencyOwner.getFrequency();
            if (blockFrequency.hasOwner()) {
                ChatFormatting textColor = frequencyOwner.canAccess(player) ? ChatFormatting.GREEN : ChatFormatting.RED;
                probeInfo.horizontal().text((Component)owner.m_130946_(" " + blockFrequency.getOwner()).m_130940_(textColor));
            }
            probeInfo.horizontal().text((Component)frequency.m_130946_(" " + blockFrequency.getChannel()));
            if (frequencyOwner.locked) {
                probeInfo.horizontal().text((Component)locked.m_130946_(" ").m_7220_((Component)yes));
            }
            if (te instanceof BlockEntityDimTank) {
                BlockEntityDimTank tank = (BlockEntityDimTank)te;
                if (tank.autoEject) {
                    probeInfo.horizontal().text((Component)eject.m_130946_(" ").m_7220_((Component)yes));
                }
                if (!tank.liquidState.serverLiquid.isEmpty()) {
                    probeInfo.element((IElement)new MyFluidElement(tank, 16000));
                }
            }
        }
    }

    public ResourceLocation getID() {
        return new ResourceLocation("dimstorage", "default");
    }
}

