/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.model;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Rotation;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.model.DungeonModel;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.piece.DungeonMultipartModelPiece;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.util.JSONUtils;
import xiroc.dungeoncrawl.util.Orientation;
import xiroc.dungeoncrawl.util.ResourceReloadHandler;
import xiroc.dungeoncrawl.util.Updatable;
import xiroc.dungeoncrawl.util.WeightedRandom;

public class MultipartModelData {
    public final List<Condition<?>> conditions;
    public WeightedRandom<Instance> models;
    @Nullable
    public WeightedRandom<Instance> alternatives;
    public final String name;

    private MultipartModelData(String name) {
        this.name = name;
        this.conditions = new ArrayList();
        this.models = null;
        this.alternatives = null;
    }

    public MultipartModelData combine(@Nullable List<Tuple<Instance, Integer>> models, @Nullable List<Tuple<Instance, Integer>> alternatives) {
        ArrayList combined;
        ImmutableList<Tuple<Instance, Integer>> base;
        MultipartModelData result = new MultipartModelData(this.name);
        result.conditions.addAll(this.conditions);
        if (models != null) {
            base = this.models.getEntries();
            combined = new ArrayList(base.size() + models.size());
            combined.addAll(base);
            combined.addAll(models);
            result.models = new WeightedRandom(combined);
        } else {
            result.models = this.models;
        }
        if (alternatives != null) {
            if (this.alternatives != null) {
                base = this.alternatives.getEntries();
                combined = new ArrayList(base.size() + alternatives.size());
                combined.addAll(base);
                combined.addAll(alternatives);
                result.alternatives = new WeightedRandom(combined);
            } else {
                result.alternatives = new WeightedRandom(alternatives);
            }
        } else {
            result.alternatives = this.alternatives;
        }
        return result;
    }

    public static MultipartModelData fromJson(String name, JsonObject object, ResourceLocation file) {
        WeightedRandom<Instance> models;
        MultipartModelData multipartModelData = new MultipartModelData(name);
        if (object.has("conditions")) {
            JsonObject jsonConditions = object.getAsJsonObject("conditions");
            jsonConditions.entrySet().forEach(entry -> {
                Condition<?> condition = Condition.fromJson((JsonElement)entry.getValue(), (String)entry.getKey());
                if (condition != null) {
                    multipartModelData.conditions.add(condition);
                }
            });
            if (multipartModelData.conditions.isEmpty()) {
                DungeonCrawl.LOGGER.warn("Multipart metadata in {} has an empty or incorrect condition set.", (Object)file);
            }
        }
        if (object.has("models")) {
            models = MultipartModelData.getInstancesFromJson(object.getAsJsonArray("models"), file);
            if (models == null) {
                DungeonCrawl.LOGGER.warn("Multipart metadata has an empty model list");
                return null;
            }
        } else {
            DungeonCrawl.LOGGER.warn("Multipart metadata does not have a model list");
            return null;
        }
        multipartModelData.models = models;
        if (object.has("alternatives")) {
            multipartModelData.alternatives = MultipartModelData.getInstancesFromJson(object.getAsJsonArray("alternatives"), file);
            if (multipartModelData.conditions == null) {
                DungeonCrawl.LOGGER.warn("Multipart metadata has an alternative model set but no conditions");
            }
        }
        return multipartModelData;
    }

    @Nullable
    private static WeightedRandom<Instance> getInstancesFromJson(JsonArray array, ResourceLocation file) {
        List entries = MultipartModelData.getRawInstancesFromJson(array, file);
        if (entries.isEmpty()) {
            return null;
        }
        return new WeightedRandom<Instance>(entries);
    }

    public static List<Tuple<Instance, Integer>> getRawInstancesFromJson(JsonArray array, ResourceLocation file) {
        ArrayList<Tuple<Instance, Integer>> list = new ArrayList<Tuple<Instance, Integer>>();
        array.forEach(element -> {
            JsonObject object1 = element.getAsJsonObject();
            Instance data = Instance.fromJson(object1, file);
            list.add(new Tuple((Object)data, (Object)JSONUtils.getWeight(object1)));
            if (data != Instance.EMPTY) {
                ResourceReloadHandler.PENDING_UPDATES.add(data);
            }
        });
        return list;
    }

    public boolean checkConditions(DungeonPiece piece) {
        if (!this.conditions.isEmpty()) {
            for (Condition<?> condition : this.conditions) {
                if (condition.isMet(piece)) continue;
                return false;
            }
        }
        return true;
    }

    private record Condition<T>(Property<T> property, T value) {
        @Nullable
        public static Condition<?> fromJson(JsonElement element, String name) {
            return switch (name) {
                case "north" -> new Condition<Boolean>(Property.NORTH, element.getAsBoolean());
                case "east" -> new Condition<Boolean>(Property.EAST, element.getAsBoolean());
                case "south" -> new Condition<Boolean>(Property.SOUTH, element.getAsBoolean());
                case "west" -> new Condition<Boolean>(Property.WEST, element.getAsBoolean());
                case "rotated_north" -> new Condition<Boolean>(Property.ROTATED_NORTH, element.getAsBoolean());
                case "rotated_east" -> new Condition<Boolean>(Property.ROTATED_EAST, element.getAsBoolean());
                case "rotated_south" -> new Condition<Boolean>(Property.ROTATED_SOUTH, element.getAsBoolean());
                case "rotated_west" -> new Condition<Boolean>(Property.ROTATED_WEST, element.getAsBoolean());
                case "multipart_north" -> new Condition<Boolean>(Property.MULTIPART_NORTH, element.getAsBoolean());
                case "multipart_east" -> new Condition<Boolean>(Property.MULTIPART_EAST, element.getAsBoolean());
                case "multipart_south" -> new Condition<Boolean>(Property.MULTIPART_SOUTH, element.getAsBoolean());
                case "multipart_west" -> new Condition<Boolean>(Property.MULTIPART_WEST, element.getAsBoolean());
                case "straight" -> new Condition<Boolean>(Property.STRAIGHT, element.getAsBoolean());
                case "connections" -> new Condition<Integer>(Property.CONNECTIONS, element.getAsInt());
                case "stage" -> new Condition<Integer>(Property.STAGE, element.getAsInt());
                default -> null;
            };
        }

        public boolean isMet(DungeonPiece piece) {
            T t = this.property.get(piece);
            return t != null && t.equals(this.value);
        }
    }

    public static class Instance
    implements Updatable {
        public static final Instance EMPTY = new Instance(null, null, DungeonModels.NO_OFFSET, Rotation.NONE);
        public final Vec3i offset;
        public final Rotation rotation;
        private final ResourceLocation file;
        @Nullable
        public DungeonModel model;
        private final ResourceLocation key;

        public Instance(ResourceLocation file, ResourceLocation key, Vec3i offset, Rotation rotation) {
            this.file = file;
            this.key = key;
            this.offset = offset;
            this.rotation = rotation;
        }

        public DungeonMultipartModelPiece createMultipartPiece(DungeonPiece parentPiece, DungeonModel parent, Rotation rotation, int x, int y, int z, RandomSource rand) {
            if (this.model != null) {
                DungeonMultipartModelPiece piece = new DungeonMultipartModelPiece();
                Rotation fullRotation = this.rotation.m_55952_(rotation);
                Vec3i rotatedOffset = Orientation.rotatedMultipartOffset(parent, this.model, this.offset, rotation, fullRotation);
                piece.setWorldPosition(x + rotatedOffset.m_123341_(), y + rotatedOffset.m_123342_(), z + rotatedOffset.m_123343_());
                piece.model = this.model;
                piece.f_73379_ = fullRotation;
                piece.stage = parentPiece.stage;
                piece.theme = parentPiece.theme;
                piece.secondaryTheme = parentPiece.secondaryTheme;
                piece.createBoundingBox();
                piece.setup(rand);
                return piece;
            }
            throw new RuntimeException("Can't create a multipart piece without a model. Metadata file: " + this.file.toString());
        }

        @Override
        public void update() {
            if (this == EMPTY) {
                return;
            }
            this.model = DungeonModels.KEY_TO_MODEL.get(this.key);
            if (this.model == null) {
                throw new RuntimeException("Cannot resolve model key " + this.key + " in " + this.file.toString());
            }
        }

        public static Instance fromJson(JsonObject object, ResourceLocation file) {
            if (object.has("model")) {
                Vec3i offset = object.has("offset") ? JSONUtils.getOffset(object.getAsJsonObject("offset")) : DungeonModels.NO_OFFSET;
                Rotation rotation = object.has("rotation") ? Rotation.valueOf((String)object.get("rotation").getAsString().toUpperCase(Locale.ROOT)) : Rotation.NONE;
                return new Instance(file, new ResourceLocation(object.get("model").getAsString()), offset, rotation);
            }
            return EMPTY;
        }
    }

    @FunctionalInterface
    private static interface Property<T> {
        public static final Property<Boolean> NORTH = piece -> piece.sides[0];
        public static final Property<Boolean> EAST = piece -> piece.sides[1];
        public static final Property<Boolean> SOUTH = piece -> piece.sides[2];
        public static final Property<Boolean> WEST = piece -> piece.sides[3];
        public static final Property<Boolean> ROTATED_NORTH = piece -> piece.sides[Orientation.rotationAsInt(piece.f_73379_)];
        public static final Property<Boolean> ROTATED_EAST = piece -> piece.sides[(1 + Orientation.rotationAsInt(piece.f_73379_)) % 4];
        public static final Property<Boolean> ROTATED_SOUTH = piece -> piece.sides[(2 + Orientation.rotationAsInt(piece.f_73379_)) % 4];
        public static final Property<Boolean> ROTATED_WEST = piece -> piece.sides[(3 + Orientation.rotationAsInt(piece.f_73379_)) % 4];
        public static final Property<Boolean> MULTIPART_NORTH = piece -> false;
        public static final Property<Boolean> MULTIPART_EAST = piece -> false;
        public static final Property<Boolean> MULTIPART_SOUTH = piece -> false;
        public static final Property<Boolean> MULTIPART_WEST = piece -> false;
        public static final Property<Boolean> STRAIGHT = piece -> piece.sides[0] && piece.sides[2] || piece.sides[1] && piece.sides[3];
        public static final Property<Integer> CONNECTIONS = piece -> piece.connectedSides;
        public static final Property<Integer> STAGE = piece -> piece.stage;

        @Nullable
        public T get(DungeonPiece var1);
    }
}

