/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import org.cyclops.cyclopscore.client.particle.ParticleBlurData;
import org.cyclops.evilcraft.RegistryEntries;

public class ParticleBlurTargettedEntityData
extends ParticleBlurData {
    public static final ParticleOptions.Deserializer<ParticleBlurTargettedEntityData> DESERIALIZER = new ParticleOptions.Deserializer<ParticleBlurTargettedEntityData>(){

        public ParticleBlurTargettedEntityData fromCommand(ParticleType<ParticleBlurTargettedEntityData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float red = (float)reader.readDouble();
            reader.expect(' ');
            float green = (float)reader.readDouble();
            reader.expect(' ');
            float blue = (float)reader.readDouble();
            reader.expect(' ');
            float scale = (float)reader.readDouble();
            reader.expect(' ');
            float ageMultiplier = (float)reader.readDouble();
            reader.expect(' ');
            int entityId = reader.readInt();
            return new ParticleBlurTargettedEntityData(red, green, blue, scale, ageMultiplier, entityId);
        }

        public ParticleBlurTargettedEntityData fromNetwork(ParticleType<ParticleBlurTargettedEntityData> particleTypeIn, FriendlyByteBuf buffer) {
            return new ParticleBlurTargettedEntityData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readInt());
        }
    };
    public static final Codec<ParticleBlurTargettedEntityData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.FLOAT.fieldOf("r").forGetter(ParticleBlurData::getRed), (App)Codec.FLOAT.fieldOf("g").forGetter(ParticleBlurData::getGreen), (App)Codec.FLOAT.fieldOf("b").forGetter(ParticleBlurData::getBlue), (App)Codec.FLOAT.fieldOf("scale").forGetter(ParticleBlurData::getScale), (App)Codec.FLOAT.fieldOf("age").forGetter(ParticleBlurData::getAgeMultiplier), (App)Codec.INT.fieldOf("entity").forGetter(ParticleBlurTargettedEntityData::getEntityId)).apply((Applicative)builder, ParticleBlurTargettedEntityData::new));
    private final int entityId;

    public ParticleBlurTargettedEntityData(float red, float green, float blue, float scale, float ageMultiplier, int entityId) {
        super(red, green, blue, scale, ageMultiplier);
        this.entityId = entityId;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public ParticleType<?> m_6012_() {
        return RegistryEntries.PARTICLE_BLUR_TARGETTED_ENTITY;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        super.m_7711_(buffer);
        buffer.writeInt(this.entityId);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %s", super.m_5942_(), this.entityId);
    }
}

