/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import com.mojang.datafixers.util.Either;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.core.recipe.type.IInventoryFluidTier;

public class RecipeBloodInfuser
implements Recipe<IInventoryFluidTier> {
    private final ResourceLocation id;
    private final Ingredient inputIngredient;
    private final FluidStack inputFluid;
    private final int inputTier;
    private final Either<ItemStack, ItemStackFromIngredient> outputItem;
    private final int duration;
    private final float xp;

    public RecipeBloodInfuser(ResourceLocation id, Ingredient inputIngredient, FluidStack inputFluid, int inputTier, Either<ItemStack, ItemStackFromIngredient> outputItem, int duration, float xp) {
        this.id = id;
        this.inputIngredient = inputIngredient;
        this.inputFluid = inputFluid;
        this.inputTier = inputTier;
        this.outputItem = outputItem;
        this.xp = xp;
        this.duration = duration;
    }

    public Ingredient getInputIngredient() {
        return this.inputIngredient;
    }

    public FluidStack getInputFluid() {
        return this.inputFluid;
    }

    public int getInputTier() {
        return this.inputTier;
    }

    public Either<ItemStack, ItemStackFromIngredient> getOutputItem() {
        return this.outputItem;
    }

    public ItemStack getOutputItemFirst() {
        return (ItemStack)this.getOutputItem().map(l -> l, ItemStackFromIngredient::getFirstItemStack);
    }

    public int getDuration() {
        return this.duration;
    }

    public float getXp() {
        return this.xp;
    }

    public boolean matches(IInventoryFluidTier inv, Level worldIn) {
        return this.getInputTier() <= inv.getTier() && this.inputIngredient.test(inv.m_8020_(0)) && this.inputFluid.getFluid() == inv.getFluidHandler().getFluidInTank(0).getFluid() && this.inputFluid.getAmount() <= inv.getFluidHandler().getFluidInTank(0).getAmount();
    }

    public ItemStack assemble(IInventoryFluidTier inv) {
        return this.getOutputItemFirst().m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height <= 1;
    }

    public ItemStack m_8043_() {
        return this.getOutputItemFirst().m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return RegistryEntries.RECIPESERIALIZER_BLOOD_INFUSER;
    }

    public RecipeType<?> m_6671_() {
        return RegistryEntries.RECIPETYPE_BLOOD_INFUSER;
    }
}

