/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import sonar.fluxnetworks.client.ClientCache;
import sonar.fluxnetworks.client.gui.basic.GuiFluxCore;
import sonar.fluxnetworks.client.render.FluxStorageEntityRenderer;
import sonar.fluxnetworks.client.render.FluxStorageRenderType;
import sonar.fluxnetworks.common.block.FluxStorageBlock;
import sonar.fluxnetworks.common.util.FluxUtils;

@OnlyIn(value=Dist.CLIENT)
public class FluxStorageItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public FluxStorageItemRenderer() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    public void m_108829_(@Nonnull ItemStack stack, @Nonnull ItemTransforms.TransformType transformType, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        long energy;
        int color;
        CompoundTag rootTag = stack.m_41783_();
        if (rootTag != null) {
            if (rootTag.m_128471_("FluxColor")) {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof GuiFluxCore) {
                    GuiFluxCore gui = (GuiFluxCore)screen;
                    color = gui.getNetwork().getNetworkColor();
                } else {
                    color = 0xB2B2B2;
                }
                CompoundTag tag = stack.m_41737_("FluxData");
                energy = tag != null ? tag.m_128454_("energy") : 0L;
            } else {
                CompoundTag tag = stack.m_41737_("FluxData");
                if (tag != null) {
                    color = tag.m_128441_("clientColor") ? tag.m_128451_("clientColor") : ClientCache.getNetwork(tag.m_128451_("networkID")).getNetworkColor();
                    energy = tag.m_128454_("energy");
                } else {
                    color = 0xB2B2B2;
                    energy = 0L;
                }
            }
        } else {
            color = 0xB2B2B2;
            energy = 0L;
        }
        FluxStorageBlock block = (FluxStorageBlock)Block.m_49814_((Item)stack.m_41720_());
        BlockState renderState = block.m_49966_();
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        BakedModel model = dispatcher.m_110910_(renderState);
        float r = FluxUtils.getRed(color);
        float g = FluxUtils.getGreen(color);
        float b = FluxUtils.getBlue(color);
        dispatcher.m_110937_().renderModel(poseStack.m_85850_(), bufferSource.m_6299_(Sheets.m_110790_()), renderState, model, r, g, b, packedLight, packedOverlay, ModelData.EMPTY, null);
        FluxStorageEntityRenderer.render(poseStack, bufferSource.m_6299_(FluxStorageRenderType.getType()), color, packedOverlay, energy, block.getEnergyCapacity());
    }
}

