/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.integration.energy;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sonar.fluxnetworks.api.FluxCapabilities;
import sonar.fluxnetworks.api.energy.IBlockEnergyConnector;
import sonar.fluxnetworks.api.energy.IFNEnergyStorage;
import sonar.fluxnetworks.api.energy.IItemEnergyConnector;
import sonar.fluxnetworks.common.util.FluxUtils;

public class FNEnergyConnector
implements IBlockEnergyConnector,
IItemEnergyConnector {
    public static final FNEnergyConnector INSTANCE = new FNEnergyConnector();

    private FNEnergyConnector() {
    }

    @Override
    public boolean hasCapability(@Nonnull BlockEntity target, @Nonnull Direction side) {
        return !target.m_58901_() && target.getCapability(FluxCapabilities.FN_ENERGY_STORAGE, side).isPresent();
    }

    @Override
    public boolean canSendTo(@Nonnull BlockEntity target, @Nonnull Direction side) {
        if (!target.m_58901_()) {
            IFNEnergyStorage storage = FluxUtils.get((ICapabilityProvider)target, FluxCapabilities.FN_ENERGY_STORAGE, side);
            return storage != null && storage.canReceive();
        }
        return false;
    }

    @Override
    public boolean canReceiveFrom(@Nonnull BlockEntity target, @Nonnull Direction side) {
        if (!target.m_58901_()) {
            IFNEnergyStorage storage = FluxUtils.get((ICapabilityProvider)target, FluxCapabilities.FN_ENERGY_STORAGE, side);
            return storage != null && storage.canExtract();
        }
        return false;
    }

    @Override
    public long sendTo(long amount, @Nonnull BlockEntity target, @Nonnull Direction side, boolean simulate) {
        IFNEnergyStorage storage = FluxUtils.get((ICapabilityProvider)target, FluxCapabilities.FN_ENERGY_STORAGE, side);
        return storage == null ? 0L : storage.receiveEnergyL(amount, simulate);
    }

    @Override
    public long receiveFrom(long amount, @Nonnull BlockEntity target, @Nonnull Direction side, boolean simulate) {
        IFNEnergyStorage storage = FluxUtils.get((ICapabilityProvider)target, FluxCapabilities.FN_ENERGY_STORAGE, side);
        return storage == null ? 0L : storage.extractEnergyL(amount, simulate);
    }

    @Override
    public boolean hasCapability(@Nonnull ItemStack stack) {
        return !stack.m_41619_() && stack.getCapability(FluxCapabilities.FN_ENERGY_STORAGE).isPresent();
    }

    @Override
    public boolean canSendTo(@Nonnull ItemStack stack) {
        if (!stack.m_41619_()) {
            IFNEnergyStorage storage = FluxUtils.get((ICapabilityProvider)stack, FluxCapabilities.FN_ENERGY_STORAGE);
            return storage != null && storage.canReceive();
        }
        return false;
    }

    @Override
    public boolean canReceiveFrom(@Nonnull ItemStack stack) {
        if (!stack.m_41619_()) {
            IFNEnergyStorage storage = FluxUtils.get((ICapabilityProvider)stack, FluxCapabilities.FN_ENERGY_STORAGE);
            return storage != null && storage.canExtract();
        }
        return false;
    }

    @Override
    public long sendTo(long amount, @Nonnull ItemStack stack, boolean simulate) {
        IFNEnergyStorage storage = FluxUtils.get((ICapabilityProvider)stack, FluxCapabilities.FN_ENERGY_STORAGE);
        return storage == null ? 0L : storage.receiveEnergyL(amount, simulate);
    }

    @Override
    public long receiveFrom(long amount, @Nonnull ItemStack stack, boolean simulate) {
        IFNEnergyStorage storage = FluxUtils.get((ICapabilityProvider)stack, FluxCapabilities.FN_ENERGY_STORAGE);
        return storage == null ? 0L : storage.extractEnergyL(amount, simulate);
    }
}

