/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.data.loot;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import sonar.fluxnetworks.common.block.FluxDeviceBlock;
import sonar.fluxnetworks.common.block.FluxStorageBlock;
import sonar.fluxnetworks.register.RegistryBlocks;

public class FluxBlockLoot
extends BlockLoot {
    private final Set<Block> knownBlocks = new ObjectArraySet();

    @Nonnull
    public final Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }

    protected final void m_124165_(@Nonnull Block blockIn, @Nonnull LootTable.Builder table) {
        super.m_124165_(blockIn, table);
        this.knownBlocks.add(blockIn);
    }

    protected void addTables() {
        this.m_124288_((Block)RegistryBlocks.FLUX_BLOCK.get());
        this.m_124175_((Block)RegistryBlocks.FLUX_PLUG.get(), FluxBlockLoot::createDevice);
        this.m_124175_((Block)RegistryBlocks.FLUX_POINT.get(), FluxBlockLoot::createDevice);
        this.m_124175_((Block)RegistryBlocks.FLUX_CONTROLLER.get(), FluxBlockLoot::createDevice);
        this.m_124175_((Block)RegistryBlocks.BASIC_FLUX_STORAGE.get(), FluxBlockLoot::createDevice);
        this.m_124175_((Block)RegistryBlocks.HERCULEAN_FLUX_STORAGE.get(), FluxBlockLoot::createDevice);
        this.m_124175_((Block)RegistryBlocks.GARGANTUAN_FLUX_STORAGE.get(), FluxBlockLoot::createDevice);
    }

    @Nonnull
    protected static LootTable.Builder createDevice(Block block) {
        if (!(block instanceof FluxDeviceBlock)) {
            throw new IllegalArgumentException();
        }
        CopyNbtFunction.Builder copyNbt = CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_);
        copyNbt.m_80279_("networkID", "FluxData.networkID");
        copyNbt.m_80279_("customName", "FluxData.customName");
        copyNbt.m_80279_("priority", "FluxData.priority");
        copyNbt.m_80279_("limit", "FluxData.limit");
        if (block instanceof FluxStorageBlock) {
            copyNbt.m_80279_("energy", "FluxData.energy");
        } else {
            copyNbt.m_80279_("buffer", "FluxData.buffer");
        }
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)copyNbt));
        return LootTable.m_79147_().m_79161_((LootPool.Builder)FluxBlockLoot.m_236224_((ItemLike)block, (ConditionUserBuilder)pool));
    }
}

