/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import xfacthd.framedblocks.api.FramedBlocksAPI;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.data.CamoContainer;
import xfacthd.framedblocks.api.data.EmptyCamoContainer;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.FramedBlockData;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.client.ClientUtils;

public class FramedBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Component MSG_BLACKLISTED = Utils.translate("msg", "blacklisted");
    public static final Component MSG_BLOCK_ENTITY = Utils.translate("msg", "block_entity");
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final int DATA_VERSION = 2;
    private final FramedBlockData modelData = new FramedBlockData();
    private CamoContainer camoContainer = EmptyCamoContainer.EMPTY;
    private boolean glowing = false;
    private boolean intangible = false;
    private boolean reinforced = false;
    private boolean recheckStates = false;

    public FramedBlockEntity(BlockPos pos, BlockState state) {
        this(FramedBlocksAPI.getInstance().defaultBlockEntity(), pos, state);
    }

    protected FramedBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public final InteractionResult handleInteraction(Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        boolean secondary = this.hitSecondary(hit);
        CamoContainer camo = this.getCamo(secondary);
        if (camo.getType().isBlock() && stack.m_150930_((Item)Utils.FRAMED_HAMMER.get())) {
            return this.clearBlockCamo(player, camo, stack, secondary);
        }
        if (camo.getType().isFluid() && stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            return this.clearFluidCamo(player, camo, stack, secondary);
        }
        if (camo.isEmpty() && stack.m_41720_() instanceof BlockItem) {
            return this.setBlockCamo(player, stack, secondary);
        }
        if (camo.isEmpty() && stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            return this.setFluidCamo(player, stack, secondary);
        }
        if (stack.m_204117_(Tags.Items.DUSTS_GLOWSTONE) && !this.glowing) {
            if (!this.f_58857_.m_5776_()) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                int light = this.getLightValue();
                this.glowing = true;
                if (!this.updateDynamicStates(false, true)) {
                    this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
                }
                boolean lightUpdate = this.getLightValue() != light;
                this.m_6596_();
                if (lightUpdate) {
                    this.doLightUpdate();
                }
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        if (!camo.isEmpty() && !player.m_6144_() && stack.m_150930_((Item)Utils.FRAMED_SCREWDRIVER.get())) {
            return this.rotateCamo(camo);
        }
        if (!this.intangible && this.canMakeIntangible(stack)) {
            if (!this.f_58857_.m_5776_()) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                this.setIntangible(true);
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        if (this.intangible && player.m_6144_() && stack.m_150930_((Item)Utils.FRAMED_SCREWDRIVER.get())) {
            if (!this.f_58857_.m_5776_()) {
                this.setIntangible(false);
                ItemStack result = new ItemStack((ItemLike)FramedBlocksAPI.getInstance().getIntangibilityMarkerItem());
                if (!player.m_150109_().m_36054_(result)) {
                    player.m_36176_(result, false);
                }
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        if (!this.reinforced && stack.m_150930_((Item)Utils.FRAMED_REINFORCEMENT.get())) {
            if (!this.f_58857_.m_5776_()) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                this.setReinforced(true);
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        if (this.reinforced && FramedBlockEntity.canRemoveReinforcement(stack)) {
            if (!this.f_58857_.m_5776_()) {
                this.setReinforced(false);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                ItemStack result = new ItemStack((ItemLike)Utils.FRAMED_REINFORCEMENT.get());
                if (!player.m_150109_().m_36054_(result)) {
                    player.m_36176_(result, false);
                }
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        return InteractionResult.PASS;
    }

    private boolean canMakeIntangible(ItemStack stack) {
        if (!FramedBlocksAPI.getInstance().enableIntangibility()) {
            return false;
        }
        return stack.m_150930_(FramedBlocksAPI.getInstance().getIntangibilityMarkerItem()) && this.getBlockType().allowMakingIntangible();
    }

    private static boolean canRemoveReinforcement(ItemStack stack) {
        if (stack.m_41720_().canPerformAction(stack, ToolActions.PICKAXE_DIG)) {
            return stack.m_41735_(Blocks.f_50080_.m_49966_());
        }
        return false;
    }

    private InteractionResult clearBlockCamo(Player player, CamoContainer camo, ItemStack stack, boolean secondary) {
        if (!this.f_58857_.m_5776_()) {
            ItemStack camoStack = camo.toItemStack(stack);
            if (!player.m_7500_() && FramedBlocksAPI.getInstance().shouldConsumeCamo()) {
                if (!player.m_150109_().m_36054_(camoStack)) {
                    player.m_36176_(camoStack, false);
                }
            } else if (player.m_7500_() && !player.m_150109_().m_36063_(camoStack)) {
                player.m_150109_().m_36054_(camoStack);
            }
            this.setCamo(EmptyCamoContainer.EMPTY, secondary);
        }
        return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
    }

    private InteractionResult clearFluidCamo(Player player, CamoContainer camo, ItemStack stack, boolean secondary) {
        ItemStack input = stack.m_41777_();
        input.m_41764_(1);
        ItemStack result = camo.toItemStack(input);
        if (!result.m_41619_()) {
            if (!this.f_58857_.m_5776_()) {
                if (!player.m_7500_() && FramedBlocksAPI.getInstance().shouldConsumeCamo()) {
                    if (result == input) {
                        player.m_21008_(InteractionHand.MAIN_HAND, result);
                    } else {
                        stack.m_41774_(1);
                        if (!player.m_150109_().m_36054_(result)) {
                            player.m_36176_(result, false);
                        }
                    }
                }
                this.setCamo(EmptyCamoContainer.EMPTY, secondary);
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult setBlockCamo(Player player, ItemStack stack, boolean secondary) {
        BlockState state = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
        if (state.m_60734_() instanceof IFramedBlock) {
            return InteractionResult.FAIL;
        }
        if (this.isValidBlock(state, player)) {
            if (!this.f_58857_.m_5776_()) {
                CamoContainer.Factory factory = FramedBlocksAPI.getInstance().getCamoContainerFactory(stack);
                this.setCamo(factory.fromItem(stack), secondary);
                if (!player.m_7500_() && FramedBlocksAPI.getInstance().shouldConsumeCamo()) {
                    stack.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        return InteractionResult.CONSUME;
    }

    private InteractionResult setFluidCamo(Player player, ItemStack stack, boolean secondary) {
        CamoContainer.Factory factory = FramedBlocksAPI.getInstance().getCamoContainerFactory(stack);
        CamoContainer camo = factory.fromItem(stack);
        if (!camo.isEmpty()) {
            if (!this.f_58857_.m_5776_()) {
                ItemStack result;
                if (!player.m_7500_() && FramedBlocksAPI.getInstance().shouldConsumeCamo() && (result = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(handler -> {
                    handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                    return handler.getContainer();
                }).orElse(ItemStack.f_41583_)) != stack) {
                    stack.m_41774_(1);
                    if (!result.m_41619_() && !player.m_150109_().m_36054_(result)) {
                        player.m_36176_(result, false);
                    }
                }
                this.setCamo(camo, secondary);
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult rotateCamo(CamoContainer camo) {
        if (camo.rotateCamo()) {
            if (!this.f_58857_.m_5776_()) {
                this.m_6596_();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
            return InteractionResult.m_19078_((boolean)this.f_58857_.m_5776_());
        }
        return InteractionResult.FAIL;
    }

    protected final boolean isValidBlock(BlockState state, Player player) {
        Block block = state.m_60734_();
        if (block instanceof IFramedBlock) {
            return false;
        }
        if (state.m_204336_(Utils.BLACKLIST)) {
            if (player != null) {
                player.m_5661_(MSG_BLACKLISTED, true);
            }
            return false;
        }
        if (state.m_155947_() && !FramedBlocksAPI.getInstance().allowBlockEntities() && !state.m_204336_(Utils.BE_WHITELIST)) {
            if (player != null) {
                player.m_5661_(MSG_BLOCK_ENTITY, true);
            }
            return false;
        }
        return state.m_60804_((BlockGetter)this.f_58857_, this.f_58858_) || state.m_204336_(Utils.FRAMEABLE) || state.m_60734_() instanceof LiquidBlock;
    }

    protected boolean hitSecondary(BlockHitResult hit) {
        return false;
    }

    public void setCamo(CamoContainer camo, boolean secondary) {
        int light = this.getLightValue();
        this.camoContainer = camo;
        this.m_6596_();
        if (this.getLightValue() != light) {
            this.doLightUpdate();
        }
        if (!this.updateDynamicStates(true, true)) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean isSolidSide(Direction side) {
        if (this.camoContainer.isEmpty()) {
            return false;
        }
        return this.getBlock().getCtmPredicate().test(this.m_58900_(), side) && this.camoContainer.getState().m_60804_((BlockGetter)this.f_58857_, this.f_58858_);
    }

    public CamoContainer getCamo(BlockState state) {
        return this.camoContainer;
    }

    public CamoContainer getCamo(Direction side) {
        return this.camoContainer;
    }

    public CamoContainer getCamo(BlockHitResult hit) {
        return this.getCamo(this.hitSecondary(hit));
    }

    protected CamoContainer getCamo(boolean secondary) {
        return this.camoContainer;
    }

    public final CamoContainer getCamo() {
        return this.camoContainer;
    }

    protected boolean isCamoSolid() {
        return !this.camoContainer.isEmpty() && this.camoContainer.getState().m_60804_((BlockGetter)this.f_58857_, this.f_58858_);
    }

    public final void checkCamoSolid() {
        boolean checkSolid = this.getBlock().getBlockType().canOccludeWithSolidCamo() && !this.camoContainer.isEmpty();
        this.updateDynamicStates(checkSolid, this.glowing);
    }

    protected final boolean updateDynamicStates(boolean updateSolid, boolean updateLight) {
        if (!this.getBlock().getBlockType().canOccludeWithSolidCamo()) {
            return false;
        }
        BlockState state = this.m_58900_();
        boolean changed = false;
        if (updateSolid) {
            boolean solid;
            boolean wasSolid = (Boolean)this.m_58900_().m_61143_((Property)FramedProperties.SOLID);
            boolean bl = solid = !this.intangible && this.isCamoSolid();
            if (solid != wasSolid) {
                state = (BlockState)state.m_61124_((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(solid));
                changed = true;
            }
        }
        if (updateLight) {
            boolean isGlowing;
            boolean bl = isGlowing = this.getLightValue() > 0;
            if (isGlowing != (Boolean)state.m_61143_((Property)FramedProperties.GLOWING)) {
                state = (BlockState)state.m_61124_((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(isGlowing));
                changed = true;
            }
        }
        if (changed) {
            this.f_58857_.m_7731_(this.f_58858_, state, 3);
        }
        return changed;
    }

    public final void updateCulling(boolean neighbors, boolean rerender) {
        boolean changed = false;
        for (Direction dir : DIRECTIONS) {
            BlockEntity blockEntity;
            changed |= this.updateCulling(dir, false);
            if (!neighbors || !((blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(dir))) instanceof FramedBlockEntity)) continue;
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            be.updateCulling(dir.m_122424_(), true);
        }
        if (rerender && changed) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean updateCulling(Direction side, boolean rerender) {
        return this.updateCulling(this.modelData, this.m_58900_(), side, rerender);
    }

    protected final boolean updateCulling(FramedBlockData modelData, BlockState testState, Direction side, boolean rerender) {
        boolean hidden;
        boolean wasHidden = modelData.isSideHidden(side);
        if (wasHidden != (hidden = ((IFramedBlock)testState.m_60734_()).isSideHidden((BlockGetter)this.f_58857_, this.f_58858_, testState, side))) {
            modelData.setSideHidden(side, hidden);
            if (rerender) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
            return true;
        }
        return false;
    }

    public float getCamoExplosionResistance(Explosion explosion) {
        float camoRes = this.camoContainer.getState().getExplosionResistance((BlockGetter)this.f_58857_, this.f_58858_, explosion);
        if (this.reinforced) {
            camoRes = Math.max(camoRes, Blocks.f_50080_.m_7325_());
        }
        return camoRes;
    }

    public boolean isCamoFlammable(Direction face) {
        if (this.reinforced) {
            return false;
        }
        return this.camoContainer.isEmpty() || this.camoContainer.getState().isFlammable((BlockGetter)this.f_58857_, this.f_58858_, face);
    }

    public int getCamoFlammability(Direction face) {
        if (this.reinforced) {
            return 0;
        }
        return this.camoContainer.isEmpty() ? -1 : this.camoContainer.getState().getFlammability((BlockGetter)this.f_58857_, this.f_58858_, face);
    }

    public int getCamoFireSpreadSpeed(Direction face) {
        if (this.reinforced) {
            return 0;
        }
        return this.camoContainer.isEmpty() ? -1 : this.camoContainer.getState().getFireSpreadSpeed((BlockGetter)this.f_58857_, this.f_58858_, face);
    }

    public final void setGlowing(boolean glowing) {
        if (this.glowing != glowing) {
            int oldLight = this.getLightValue();
            this.glowing = glowing;
            if (oldLight != this.getLightValue()) {
                this.doLightUpdate();
            }
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public final boolean isGlowing() {
        return this.glowing;
    }

    public int getLightValue() {
        if (this.glowing) {
            return 15;
        }
        return this.camoContainer.getState().m_60791_();
    }

    public void setIntangible(boolean intangible) {
        if (this.intangible != intangible) {
            this.intangible = intangible;
            this.m_6596_();
            if (!this.updateDynamicStates(true, false)) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public boolean isIntangible(CollisionContext ctx) {
        EntityCollisionContext ectx;
        Entity entity;
        if (!FramedBlocksAPI.getInstance().enableIntangibility() || !this.intangible) {
            return false;
        }
        if (ctx instanceof EntityCollisionContext && (entity = (ectx = (EntityCollisionContext)ctx).m_193113_()) instanceof Player) {
            Player player = (Player)entity;
            ItemStack mainItem = player.m_21205_();
            return !mainItem.m_204117_(Utils.DISABLE_INTANGIBLE);
        }
        return true;
    }

    public void setReinforced(boolean reinforced) {
        if (this.reinforced != reinforced) {
            this.reinforced = reinforced;
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.m_6596_();
        }
    }

    public boolean isReinforced() {
        return this.reinforced;
    }

    protected final void doLightUpdate() {
        this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
    }

    public final IFramedBlock getBlock() {
        return (IFramedBlock)this.m_58900_().m_60734_();
    }

    public final IBlockType getBlockType() {
        return this.getBlock().getBlockType();
    }

    public void addAdditionalDrops(List<ItemStack> drops, boolean dropCamo) {
        if (dropCamo) {
            this.addCamoDrops(drops);
            if (!this.camoContainer.isEmpty()) {
                drops.add(this.camoContainer.toItemStack(ItemStack.f_41583_));
            }
        }
        if (this.reinforced) {
            drops.add(new ItemStack((ItemLike)Utils.FRAMED_REINFORCEMENT.get()));
        }
    }

    @Deprecated(forRemoval=true, since="1.19.2")
    public void addCamoDrops(List<ItemStack> drops) {
    }

    public MaterialColor getMapColor() {
        return this.camoContainer.getMapColor((BlockGetter)this.f_58857_, this.f_58858_);
    }

    public float[] getCamoBeaconColorMultiplier(LevelReader level, BlockPos pos, BlockPos beaconPos) {
        if (!this.camoContainer.isEmpty()) {
            return this.camoContainer.getBeaconColorMultiplier(level, pos, beaconPos);
        }
        return null;
    }

    public boolean shouldCamoDisplayFluidOverlay(BlockAndTintGetter level, BlockPos pos, FluidState fluid) {
        return this.camoContainer.isEmpty() || this.camoContainer.getState().shouldDisplayFluidOverlay(level, pos, fluid);
    }

    public boolean doesCamoPreventDestructionByEntity(Entity entity) {
        if (this.reinforced && !Blocks.f_50080_.m_49966_().canEntityDestroy((BlockGetter)this.f_58857_, this.f_58858_, entity)) {
            return false;
        }
        return FramedBlockEntity.doesCamoPreventDestructionByEntity(this, this.camoContainer, entity);
    }

    protected static boolean doesCamoPreventDestructionByEntity(FramedBlockEntity be, CamoContainer camo, Entity entity) {
        if (camo.isEmpty()) {
            return false;
        }
        BlockState state = camo.getState();
        return !state.canEntityDestroy((BlockGetter)be.f_58857_, be.f_58858_, entity);
    }

    public void onLoad() {
        if (!this.f_58857_.m_5776_() && this.recheckStates) {
            this.checkCamoSolid();
        }
        super.onLoad();
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public final void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbt = pkt.m_131708_();
        if (nbt != null && this.readFromDataPacket(nbt)) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.requestModelDataUpdate();
        }
    }

    protected void writeToDataPacket(CompoundTag nbt) {
        nbt.m_128365_("camo", (Tag)CamoContainer.save(this.camoContainer));
        nbt.m_128379_("glowing", this.glowing);
        nbt.m_128379_("intangible", this.intangible);
        nbt.m_128379_("reinforced", this.reinforced);
    }

    protected boolean readFromDataPacket(CompoundTag nbt) {
        boolean newReinforced;
        boolean newIntangible;
        boolean newGlow;
        boolean needUpdate = false;
        boolean needCullingUpdate = false;
        CamoContainer newCamo = CamoContainer.load(nbt.m_128469_("camo"));
        if (!newCamo.equals(this.camoContainer)) {
            int oldLight = this.getLightValue();
            this.camoContainer = newCamo;
            if (oldLight != this.getLightValue()) {
                this.doLightUpdate();
            }
            this.modelData.setCamoState(this.camoContainer.getState());
            needUpdate = true;
            needCullingUpdate = true;
        }
        if ((newGlow = nbt.m_128471_("glowing")) != this.glowing) {
            this.glowing = newGlow;
            needUpdate = true;
            this.doLightUpdate();
        }
        if ((newIntangible = nbt.m_128471_("intangible")) != this.intangible) {
            this.intangible = newIntangible;
            needUpdate = true;
            needCullingUpdate = true;
        }
        if ((newReinforced = nbt.m_128471_("reinforced")) != this.reinforced) {
            this.reinforced = newReinforced;
            this.modelData.setReinforced(this.reinforced);
            needUpdate = true;
        }
        if (needCullingUpdate) {
            this.updateCulling(true, false);
        }
        return needUpdate;
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128365_("camo", (Tag)CamoContainer.save(this.camoContainer));
        nbt.m_128379_("glowing", this.glowing);
        nbt.m_128379_("intangible", this.intangible);
        nbt.m_128379_("reinforced", this.reinforced);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag nbt) {
        CamoContainer newCamo = CamoContainer.load(nbt.m_128469_("camo"));
        if (!newCamo.equals(this.camoContainer)) {
            this.camoContainer = newCamo;
            this.modelData.setCamoState(this.camoContainer.getState());
            ClientUtils.enqueueClientTask(() -> this.updateCulling(true, true));
        }
        this.glowing = nbt.m_128471_("glowing");
        this.intangible = nbt.m_128471_("intangible");
        boolean newReinforced = nbt.m_128471_("reinforced");
        if (newReinforced != this.reinforced) {
            this.reinforced = newReinforced;
            this.modelData.setReinforced(this.reinforced);
        }
        this.requestModelDataUpdate();
    }

    public ModelData getModelData() {
        return ModelData.builder().with(FramedBlockData.PROPERTY, (Object)this.modelData).build();
    }

    protected final FramedBlockData getModelDataInternal() {
        return this.modelData;
    }

    protected void initModelData() {
        this.modelData.setCamoState(this.camoContainer.getState());
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        if (level.m_5776_()) {
            this.initModelData();
        }
    }

    public CompoundTag writeToBlueprint() {
        return this.m_187482_();
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("camo", (Tag)CamoContainer.save(this.camoContainer));
        nbt.m_128379_("glowing", this.glowing);
        nbt.m_128379_("intangible", this.intangible);
        nbt.m_128379_("reinforced", this.reinforced);
        nbt.m_128344_("updated", (byte)2);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        FramedBlocksAPI.getInstance().updateCamoNbt(nbt, "camo_state", "camo_stack", "camo");
        CamoContainer camo = CamoContainer.load(nbt.m_128469_("camo"));
        if (camo.isEmpty() || this.isValidBlock(camo.getState(), null)) {
            this.recheckStates = nbt.m_128445_("updated") < 2;
            this.camoContainer = camo;
        } else {
            this.recheckStates = true;
            LOGGER.warn("Framed Block of type \"{}\" at position {} contains an invalid camo of type \"{}\", removing camo! This might be caused by a config or tag change!", new Object[]{ForgeRegistries.BLOCKS.getKey((Object)this.m_58900_().m_60734_()), this.f_58858_, ForgeRegistries.BLOCKS.getKey((Object)camo.getState().m_60734_())});
        }
        this.glowing = nbt.m_128471_("glowing");
        this.intangible = nbt.m_128471_("intangible");
        this.reinforced = nbt.m_128471_("reinforced");
    }
}

