/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopepanel;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.SideSkipPredicate;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.HalfTriangleDir;
import xfacthd.framedblocks.common.data.skippreds.pillar.CornerPillarSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.PanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabEdgeSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatExtendedSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.FlatInnerSlopePanelCornerSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.HalfStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalSlopedStairsSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.stairs.VerticalStairsSkipPredicate;

public final class ExtendedSlopePanelSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        Direction rotDir = rot.withFacing(dir);
        if (side == dir || side == rotDir.m_122424_()) {
            return SideSkipPredicate.CTM.test(level, pos, state, adjState, side);
        }
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType type = (BlockType)object;
            return switch (type) {
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> ExtendedSlopePanelSkipPredicate.testAgainstExtendedSlopePanel(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> ExtendedSlopePanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_SLOPE_PANEL -> ExtendedSlopePanelSkipPredicate.testAgainstDoubleSlopePanel(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL -> ExtendedSlopePanelSkipPredicate.testAgainstInverseDoubleSlopePanel(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_EXTENDED_DOUBLE_SLOPE_PANEL -> ExtendedSlopePanelSkipPredicate.testAgainstExtendedDoubleSlopePanel(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_STACKED_SLOPE_PANEL -> ExtendedSlopePanelSkipPredicate.testAgainstStackedSlopePanel(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> ExtendedSlopePanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> ExtendedSlopePanelSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_INNER_SLOPE_PANEL_CORNER -> ExtendedSlopePanelSkipPredicate.testAgainstFlatExtendedInnerSlopePanelCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_DOUBLE_SLOPE_PANEL_CORNER -> ExtendedSlopePanelSkipPredicate.testAgainstFlatDoubleSlopePanelCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_INV_DOUBLE_SLOPE_PANEL_CORNER -> ExtendedSlopePanelSkipPredicate.testAgainstFlatInverseDoubleSlopePanelCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_DOUBLE_SLOPE_PANEL_CORNER -> ExtendedSlopePanelSkipPredicate.testAgainstFlatExtendedDoubleSlopePanelCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER -> ExtendedSlopePanelSkipPredicate.testAgainstFlatExtendedInnerDoubleSlopePanelCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_SLOPE_PANEL_CORNER -> ExtendedSlopePanelSkipPredicate.testAgainstFlatStackedSlopePanelCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_STACKED_INNER_SLOPE_PANEL_CORNER -> ExtendedSlopePanelSkipPredicate.testAgainstFlatStackedInnerSlopePanelCorner(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> ExtendedSlopePanelSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLAB -> ExtendedSlopePanelSkipPredicate.testAgainstDividedSlab(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_HORIZONTAL -> ExtendedSlopePanelSkipPredicate.testAgainstDividedPanelHor(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_PANEL -> ExtendedSlopePanelSkipPredicate.testAgainstPanel(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_PANEL -> ExtendedSlopePanelSkipPredicate.testAgainstDoublePanel(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> ExtendedSlopePanelSkipPredicate.testAgainstCornerPillar(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_PANEL_VERTICAL -> ExtendedSlopePanelSkipPredicate.testAgainstDividedPanelVert(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_STAIRS -> ExtendedSlopePanelSkipPredicate.testAgainstStairs(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_STAIRS -> ExtendedSlopePanelSkipPredicate.testAgainstDoubleStairs(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> ExtendedSlopePanelSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS -> ExtendedSlopePanelSkipPredicate.testAgainstVerticalDoubleStairs(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS, BlockType.FRAMED_HALF_SLOPE -> ExtendedSlopePanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_STAIRS -> ExtendedSlopePanelSkipPredicate.testAgainstDividedStairs(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DIVIDED_SLOPE -> ExtendedSlopePanelSkipPredicate.testAgainstDividedSlope(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_DOUBLE_HALF_SLOPE -> ExtendedSlopePanelSkipPredicate.testAgainstDoubleHalfSlope(level, pos, state, dir, rot, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> ExtendedSlopePanelSkipPredicate.testAgainstVerticalSlopedStairs(level, pos, state, dir, rot, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (ExtendedSlopePanelSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (ExtendedSlopePanelSkipPredicate.getTriDir(dir, rot, side).isEqualTo(ExtendedSlopePanelSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (ExtendedSlopePanelSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(SlopePanelSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || ExtendedSlopePanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstInverseDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || ExtendedSlopePanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstExtendedDoubleSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstExtendedSlopePanel(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || ExtendedSlopePanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstStackedSlopePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstPanel(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || ExtendedSlopePanelSkipPredicate.testAgainstSlopePanel(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.m_61143_((Property)PropertyHolder.FRONT);
        if (ExtendedSlopePanelSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(FlatInnerSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, adjFront, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (ExtendedSlopePanelSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        if (ExtendedSlopePanelSkipPredicate.getTriDir(dir, rot, side).isEqualTo(FlatExtendedSlopePanelCornerSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatExtendedInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (ExtendedSlopePanelSkipPredicate.getTriDir(dir, rot, side).isEqualTo(FlatExtendedInnerSlopePanelCornerSkipPredicate.getTriDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstFlatDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatInverseDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatExtendedDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || ExtendedSlopePanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstFlatExtendedInnerDoubleSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstFlatExtendedInnerSlopePanelCorner(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatStackedSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstPanel(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side);
    }

    private static boolean testAgainstFlatStackedInnerSlopePanelCorner(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstPanel(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || ExtendedSlopePanelSkipPredicate.testAgainstFlatInnerSlopePanelCorner(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstSlabEdge(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        if (ExtendedSlopePanelSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(SlabEdgeSkipPredicate.getHalfDir(adjDir, adjTop, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedSlab(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || ExtendedSlopePanelSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDividedPanelHor(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || ExtendedSlopePanelSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstPanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (ExtendedSlopePanelSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(PanelSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoublePanel(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstPanel(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || ExtendedSlopePanelSkipPredicate.testAgainstPanel(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstCornerPillar(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        if (ExtendedSlopePanelSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(CornerPillarSkipPredicate.getHalfDir(adjDir, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedPanelVert(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstCornerPillar(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || ExtendedSlopePanelSkipPredicate.testAgainstCornerPillar(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)StairBlock.f_56841_);
        StairsShape adjShape = (StairsShape)adjState.m_61143_((Property)StairBlock.f_56843_);
        Half adjHalf = (Half)adjState.m_61143_((Property)StairBlock.f_56842_);
        if (ExtendedSlopePanelSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(StairsSkipPredicate.getHalfDir(adjDir, adjShape, adjHalf, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstStairs(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || ExtendedSlopePanelSkipPredicate.testAgainstSlabEdge(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.m_61143_(PropertyHolder.STAIRS_TYPE));
        if (ExtendedSlopePanelSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(VerticalStairsSkipPredicate.getHalfDir(adjDir, adjType, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstVerticalDoubleStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstVerticalStairs(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || ExtendedSlopePanelSkipPredicate.testAgainstCornerPillar(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstHalfStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.m_61143_((Property)PropertyHolder.RIGHT);
        if (ExtendedSlopePanelSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(HalfStairsSkipPredicate.getHalfDir(adjDir, adjTop, adjRight, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    private static boolean testAgainstDividedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || ExtendedSlopePanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDividedSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        if (adjState.m_61143_(PropertyHolder.SLOPE_TYPE) == SlopeType.HORIZONTAL) {
            return false;
        }
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || ExtendedSlopePanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstDoubleHalfSlope(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Tuple<BlockState, BlockState> states = AbstractFramedDoubleBlock.getStatePair(adjState);
        return ExtendedSlopePanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, rot, (BlockState)states.m_14418_(), side) || ExtendedSlopePanelSkipPredicate.testAgainstHalfStairs(level, pos, state, dir, rot, (BlockState)states.m_14419_(), side);
    }

    private static boolean testAgainstVerticalSlopedStairs(BlockGetter level, BlockPos pos, BlockState state, Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.m_61143_(PropertyHolder.ROTATION));
        if (ExtendedSlopePanelSkipPredicate.getHalfDir(dir, rot, side).isEqualTo(VerticalSlopedStairsSkipPredicate.getHalfDir(adjDir, adjRot, side.m_122424_()))) {
            return SideSkipPredicate.compareState(level, pos, side, state, adjState);
        }
        return false;
    }

    public static HalfTriangleDir getTriDir(Direction dir, HorizontalRotation rot, Direction side) {
        Direction perpRotDir = rot.rotate(Rotation.CLOCKWISE_90).withFacing(dir);
        if (side.m_122434_() == perpRotDir.m_122434_()) {
            Direction shortEdge = rot.getOpposite().withFacing(dir);
            return HalfTriangleDir.fromDirections(dir, shortEdge, false);
        }
        return HalfTriangleDir.NULL;
    }

    public static HalfDir getHalfDir(Direction dir, HorizontalRotation rot, Direction side) {
        if (side == rot.withFacing(dir)) {
            return HalfDir.fromDirections(side, dir);
        }
        return HalfDir.NULL;
    }
}

