/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.loot;

import blusunrize.immersiveengineering.common.util.loot.BEDropLootEntry;
import blusunrize.immersiveengineering.common.util.loot.BluprintzLootFunction;
import blusunrize.immersiveengineering.common.util.loot.ConveyorCoverLootFunction;
import blusunrize.immersiveengineering.common.util.loot.DropInventoryLootEntry;
import blusunrize.immersiveengineering.common.util.loot.MBOriginalBlockLootEntry;
import blusunrize.immersiveengineering.common.util.loot.PropertyCountLootFunction;
import blusunrize.immersiveengineering.common.util.loot.RevolverperkLootFunction;
import blusunrize.immersiveengineering.common.util.loot.SimpleSerializer;
import blusunrize.immersiveengineering.common.util.loot.WindmillLootFunction;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IELootFunctions {
    private static final DeferredRegister<LootItemFunctionType> FUNCTION_REGISTER = DeferredRegister.create((ResourceKey)Registry.f_122816_, (String)"immersiveengineering");
    public static final RegistryObject<LootItemFunctionType> BLUPRINTZ = IELootFunctions.registerFunction("secret_bluprintz", () -> new SimpleSerializer<BluprintzLootFunction>(BluprintzLootFunction::new));
    public static final RegistryObject<LootItemFunctionType> REVOLVERPERK = IELootFunctions.registerFunction("revolverperk", () -> new SimpleSerializer<RevolverperkLootFunction>(RevolverperkLootFunction::new));
    public static final RegistryObject<LootItemFunctionType> WINDMILL = IELootFunctions.registerFunction("windmill", () -> new SimpleSerializer<WindmillLootFunction>(WindmillLootFunction::new));
    public static final RegistryObject<LootItemFunctionType> CONVEYOR_COVER = IELootFunctions.registerFunction("conveyor_cover", () -> new SimpleSerializer<ConveyorCoverLootFunction>(ConveyorCoverLootFunction::new));
    public static final RegistryObject<LootItemFunctionType> PROPERTY_COUNT = IELootFunctions.registerFunction("property_count", PropertyCountLootFunction.Serializer::new);
    private static final DeferredRegister<LootPoolEntryType> ENTRY_REGISTER = DeferredRegister.create((ResourceKey)Registry.f_122875_.m_123023_(), (String)"immersiveengineering");
    public static final RegistryObject<LootPoolEntryType> DROP_INVENTORY = IELootFunctions.registerEntry("drop_inv", DropInventoryLootEntry.Serializer::new);
    public static final RegistryObject<LootPoolEntryType> TILE_DROP = IELootFunctions.registerEntry("tile_drop", BEDropLootEntry.Serializer::new);
    public static final RegistryObject<LootPoolEntryType> MULTIBLOCK_ORIGINAL_BLOCK = IELootFunctions.registerEntry("multiblock_original_block", MBOriginalBlockLootEntry.Serializer::new);

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        FUNCTION_REGISTER.register(bus);
        ENTRY_REGISTER.register(bus);
    }

    private static RegistryObject<LootPoolEntryType> registerEntry(String id, Supplier<Serializer<? extends LootPoolEntryContainer>> serializer) {
        return ENTRY_REGISTER.register(id, () -> new LootPoolEntryType((Serializer)serializer.get()));
    }

    private static RegistryObject<LootItemFunctionType> registerFunction(String id, Supplier<Serializer<? extends LootItemFunction>> serializer) {
        return FUNCTION_REGISTER.register(id, () -> new LootItemFunctionType((Serializer)serializer.get()));
    }
}

