/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities.ai;

import blusunrize.immersiveengineering.common.entities.ChemthrowerShotEntity;
import blusunrize.immersiveengineering.common.entities.ai.ShieldCombatGoal;
import blusunrize.immersiveengineering.common.entities.illager.Bulwark;
import blusunrize.immersiveengineering.common.items.ChemthrowerItem;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.util.IESounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;

public class ChemthrowerAttackGoal<T extends Bulwark>
extends ShieldCombatGoal<T> {
    private int counter = -1;
    private final FluidStack fluidStack = new FluidStack((Fluid)IEFluids.ETHANOL.getStill(), 1000);

    public ChemthrowerAttackGoal(T mob, float attackRadius) {
        super(mob, attackRadius, new ShieldCombatGoal.IntRange(120, 180), new ShieldCombatGoal.IntRange(0, 1));
    }

    @Override
    protected boolean isHoldingWeapon() {
        return ((Bulwark)this.mob).m_21093_(is -> is.m_41720_() instanceof ChemthrowerItem);
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (this.combatState == ShieldCombatGoal.ShieldCombatState.ATTACK && !((Bulwark)this.mob).isAiming()) {
            ((Bulwark)this.mob).setAiming(true);
        }
        if (this.combatState != ShieldCombatGoal.ShieldCombatState.ATTACK && ((Bulwark)this.mob).isAiming()) {
            ((Bulwark)this.mob).setAiming(false);
        }
    }

    @Override
    boolean performAttack() {
        ++this.counter;
        Vec3 v = ((Bulwark)this.mob).m_20154_();
        int split = 8;
        boolean isGas = this.fluidStack.getFluid().m_205067_(Tags.Fluids.GASEOUS);
        float scatter = isGas ? 0.25f : 0.15f;
        float range = isGas ? 0.5f : 1.0f;
        RandomSource random = ((Bulwark)this.mob).m_217043_();
        for (int i = 0; i < split; ++i) {
            Vec3 vecDir = v.m_82520_(random.m_188583_() * (double)scatter, random.m_188583_() * (double)scatter, random.m_188583_() * (double)scatter);
            ChemthrowerShotEntity chem = new ChemthrowerShotEntity(((Bulwark)this.mob).f_19853_, (LivingEntity)this.mob, vecDir.f_82479_ * 0.25, vecDir.f_82480_ * 0.25, vecDir.f_82481_ * 0.25, this.fluidStack);
            chem.m_20256_(((Bulwark)this.mob).m_20184_().m_82549_(vecDir.m_82490_((double)range)));
            chem.m_20254_(10);
            if (((Bulwark)this.mob).f_19853_.f_46443_) continue;
            ((Bulwark)this.mob).f_19853_.m_7967_((Entity)chem);
        }
        if (this.counter % 4 == 0) {
            ((Bulwark)this.mob).f_19853_.m_6263_(null, ((Bulwark)this.mob).m_20185_(), ((Bulwark)this.mob).m_20186_(), ((Bulwark)this.mob).m_20189_(), (SoundEvent)IESounds.sprayFire.get(), SoundSource.PLAYERS, 0.5f, 1.5f);
        }
        if (this.counter >= 40) {
            this.counter = 0;
            return true;
        }
        return false;
    }
}

