/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.computers.cctweaked;

import blusunrize.immersiveengineering.common.util.compat.computers.cctweaked.PeripheralCreator;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerControlState;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerControllable;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GenericPeripheral<T>
implements IDynamicPeripheral {
    private final PeripheralCreator<T> creator;
    private final T object;

    public GenericPeripheral(PeripheralCreator<T> creator, T object) {
        this.creator = creator;
        this.object = object;
    }

    @Nonnull
    public String[] getMethodNames() {
        return this.creator.getMethodNames();
    }

    @Nonnull
    public MethodResult callMethod(@Nonnull IComputerAccess computerAccess, @Nonnull ILuaContext ctx, int index, @Nonnull IArguments luaArgs) throws LuaException {
        return this.creator.call(computerAccess, ctx, index, luaArgs, this.object);
    }

    @Nonnull
    public String getType() {
        return this.creator.getName();
    }

    public boolean equals(@Nullable IPeripheral other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        GenericPeripheral otherGeneric = (GenericPeripheral)other;
        return this.creator == otherGeneric.creator && this.object == otherGeneric.object;
    }

    public void attach(@Nonnull IComputerAccess computer) {
        T t = this.object;
        if (t instanceof ComputerControllable) {
            ComputerControllable controllable = (ComputerControllable)t;
            controllable.getAllComputerControlStates().forEach(ComputerControlState::addReference);
        }
    }

    public void detach(@Nonnull IComputerAccess computer) {
        T t = this.object;
        if (t instanceof ComputerControllable) {
            ComputerControllable controllable = (ComputerControllable)t;
            controllable.getAllComputerControlStates().forEach(ComputerControlState::removeReference);
        }
    }
}

