/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.managers;

import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CrTIngredientUtil;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.AbstractActionGenericRemoveRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.ActionAddRecipeCustomOutput;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.fluid.MCFluidStackMutable;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersiveengineering/Fermenter")
@ZenCodeType.Name(value="mods.immersiveengineering.Fermenter")
public class FermenterRecipeManager
implements IRecipeManager<FermenterRecipe> {
    public RecipeType<FermenterRecipe> getRecipeType() {
        return IERecipeTypes.FERMENTER.get();
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredientWithAmount input, int energy, IItemStack itemOutput, IFluidStack fluidOutput) {
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipePath);
        IngredientWithSize ingredient = CrTIngredientUtil.getIngredientWithSize(input);
        FluidStack fluidStack = fluidOutput.getInternal();
        ItemStack outputItem = itemOutput.getInternal();
        FermenterRecipe recipe = IEServerConfig.MACHINES.fermenterConfig.apply(new FermenterRecipe(resourceLocation, fluidStack, IESerializableRecipe.of(outputItem), ingredient, energy));
        String outputDescription = String.format("%s and %s", itemOutput.getCommandString(), fluidOutput.getCommandString());
        CraftTweakerAPI.apply(new ActionAddRecipeCustomOutput<FermenterRecipe>(this, recipe, outputDescription));
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredientWithAmount input, int energy, IFluidStack fluidOutput) {
        this.addRecipe(recipePath, input, energy, (IItemStack)MCItemStack.EMPTY.get(), fluidOutput);
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredientWithAmount input, int energy, IItemStack itemOutput) {
        this.addRecipe(recipePath, input, energy, itemOutput, (IFluidStack)new MCFluidStackMutable(FluidStack.EMPTY));
    }

    @ZenCodeType.Method
    public void removeRecipe(final Fluid outputFluid) {
        CraftTweakerAPI.apply((IAction)new AbstractActionGenericRemoveRecipe<FermenterRecipe>((IRecipeManager)this, outputFluid){

            @Override
            public boolean shouldRemove(FermenterRecipe recipe) {
                return outputFluid.m_6212_(recipe.fluidOutput.getFluid());
            }
        });
    }

    @ZenCodeType.Method
    public void removeRecipe(final IFluidStack output) {
        CraftTweakerAPI.apply((IAction)new AbstractActionGenericRemoveRecipe<FermenterRecipe>((IRecipeManager)this, (CommandStringDisplayable)output){

            @Override
            public boolean shouldRemove(FermenterRecipe recipe) {
                return output.getInternal().isFluidStackIdentical(recipe.fluidOutput);
            }
        });
    }
}

