/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.metal;

import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockBase;
import flaxbeard.immersivepetroleum.common.blocks.IPBlockItemBase;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.SeismicSurveyTileEntity;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SeismicSurveyBlock
extends IPBlockBase
implements EntityBlock {
    private static final Material material = new Material(MaterialColor.f_76404_, false, false, true, true, false, false, PushReaction.BLOCK);
    public static final BooleanProperty SLAVE = BooleanProperty.m_61465_((String)"slave");
    static final VoxelShape SHAPE_MASTER = Shapes.m_83048_((double)0.001, (double)0.001, (double)0.001, (double)0.999, (double)0.999, (double)0.999);

    public SeismicSurveyBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)material).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_).m_60999_().m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)SLAVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Supplier<BlockItem> blockItemSupplier() {
        return () -> new SeismicSurveyBlockItem(this);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SLAVE});
    }

    public int m_7753_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return 0;
    }

    public boolean m_7420_(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos) {
        return 1.0f;
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pPos, @Nonnull BlockState pState) {
        SeismicSurveyTileEntity te = (SeismicSurveyTileEntity)((BlockEntityType)IPTileTypes.SEISMIC_SURVEY.get()).m_155264_(pPos, pState);
        te.isSlave = (Boolean)pState.m_61143_((Property)SLAVE);
        return te;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        if (((Boolean)state.m_61143_((Property)SLAVE)).booleanValue()) {
            return null;
        }
        return SeismicSurveyBlock.createCommonTicker(level.f_46443_, type, IPTileTypes.SEISMIC_SURVEY);
    }

    public void m_5707_(@Nonnull Level world, @Nonnull BlockPos pos, BlockState state, @Nonnull Player player) {
        if (((Boolean)state.m_61143_((Property)SLAVE)).booleanValue()) {
            for (int i = 1; i < 3; ++i) {
                BlockPos p = pos.m_7918_(0, -i, 0);
                BlockState stateDown = world.m_8055_(p);
                if (stateDown.m_60795_() || !stateDown.m_60734_().equals((Object)this) || ((Boolean)stateDown.m_61143_((Property)SLAVE)).booleanValue()) continue;
                world.m_46961_(p, !player.m_7500_());
                world.m_46961_(p.m_7918_(0, 1, 0), false);
                world.m_46961_(p.m_7918_(0, 2, 0), false);
                break;
            }
        } else {
            world.m_46961_(pos.m_7918_(0, 1, 0), false);
            world.m_46961_(pos.m_7918_(0, 2, 0), false);
        }
        super.m_5707_(world, pos, state, player);
    }

    @Nonnull
    public List<ItemStack> m_7381_(BlockState state, @Nonnull LootContext.Builder builder) {
        if (((Boolean)state.m_61143_((Property)SLAVE)).booleanValue()) {
            return Collections.emptyList();
        }
        return super.m_7381_(state, builder);
    }

    public void m_6810_(BlockState pState, @Nonnull Level pLevel, @Nonnull BlockPos pPos, @Nonnull BlockState pNewState, boolean pIsMoving) {
        if (!(!pState.m_155947_() || pState.m_60713_(pNewState.m_60734_()) && pNewState.m_155947_())) {
            BlockEntity blockEntity;
            if (!pLevel.f_46443_ && (blockEntity = pLevel.m_7702_(pPos)) instanceof SeismicSurveyTileEntity) {
                SeismicSurveyTileEntity survey = (SeismicSurveyTileEntity)blockEntity;
                if (!survey.isSlave && !survey.stack.m_41619_()) {
                    Block.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)survey.stack);
                }
            }
            pLevel.m_46747_(pPos);
        }
    }

    @Override
    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof SeismicSurveyTileEntity) {
            SeismicSurveyTileEntity survey = (SeismicSurveyTileEntity)te;
            if ((survey = survey.master()) != null && survey.interact(state, world, survey.m_58899_(), player, hand)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public void m_6402_(Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        if (!worldIn.f_46443_) {
            worldIn.m_46597_(pos.m_7918_(0, 1, 0), (BlockState)state.m_61124_((Property)SLAVE, (Comparable)Boolean.valueOf(true)));
            worldIn.m_46597_(pos.m_7918_(0, 2, 0), (BlockState)state.m_61124_((Property)SLAVE, (Comparable)Boolean.valueOf(true)));
        }
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE_MASTER;
    }

    public static class SeismicSurveyBlockItem
    extends IPBlockItemBase {
        public SeismicSurveyBlockItem(Block blockIn) {
            super(blockIn, new Item.Properties().m_41491_(ImmersivePetroleum.creativeTab));
        }

        protected boolean m_40610_(@Nonnull BlockPlaceContext con, @Nonnull BlockState state) {
            if (super.m_40610_(con, state)) {
                BlockPos posA = con.m_8083_().m_5484_(Direction.UP, 1);
                BlockState stateA = con.m_43725_().m_8055_(posA);
                if (stateA.m_60795_()) {
                    BlockPos posB = con.m_8083_().m_5484_(Direction.UP, 2);
                    BlockState stateB = con.m_43725_().m_8055_(posB);
                    return stateB.m_60795_();
                }
            }
            return false;
        }
    }
}

