/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class FluidHelper {
    public static FluidStack copyFluid(FluidStack fluid, int amount) {
        return FluidHelper.copyFluid(fluid, amount, false);
    }

    public static FluidStack copyFluid(FluidStack fluid, int amount, boolean pressurize) {
        FluidStack fs = new FluidStack(fluid.getFluid(), amount);
        if (pressurize && amount > 50) {
            fs.getOrCreateTag().m_128379_("pressurized", true);
        }
        return fs;
    }

    public static FluidStack makePressurizedFluid(Fluid fluid, int amount) {
        FluidStack fs = new FluidStack(fluid, amount);
        if (amount > 50) {
            fs.getOrCreateTag().m_128379_("pressurized", true);
        }
        return fs;
    }

    public static boolean isFluidContainerFull(ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack).map(handler -> {
            for (int t = 0; t < handler.getTanks(); ++t) {
                if (handler.getFluidInTank(t).getAmount() >= handler.getTankCapacity(t)) continue;
                return false;
            }
            return true;
        }).orElse(true);
    }

    public static ItemStack fillFluidContainer(IFluidHandler handler, ItemStack containerIn, ItemStack containerOut, @Nullable Player player) {
        if (containerIn == null || containerIn.m_41619_()) {
            return ItemStack.f_41583_;
        }
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (Player)player, (boolean)false);
        if (result.isSuccess()) {
            ItemStack full = result.getResult();
            if (containerOut.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)containerOut, (ItemStack)full)) {
                if (!containerOut.m_41619_() && containerOut.m_41613_() + full.m_41613_() > containerOut.m_41741_()) {
                    return ItemStack.f_41583_;
                }
                result = FluidUtil.tryFillContainer((ItemStack)containerIn, (IFluidHandler)handler, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
                if (result.isSuccess()) {
                    return result.getResult();
                }
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack fillFluidContainer(IFluidTank tank, FluidStack fluid, ItemStack containerIn, ItemStack containerOut) {
        if (containerIn == null || containerIn.m_41619_()) {
            return ItemStack.f_41583_;
        }
        FluidActionResult result = FluidHelper.tryFillContainer(tank, fluid, containerIn, false);
        if (result.isSuccess()) {
            ItemStack full = result.getResult();
            if (containerOut.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)containerOut, (ItemStack)full)) {
                if (!containerOut.m_41619_() && containerOut.m_41613_() + full.m_41613_() > containerOut.m_41741_()) {
                    return ItemStack.f_41583_;
                }
                result = FluidHelper.tryFillContainer(tank, fluid, containerIn, true);
                if (result.isSuccess()) {
                    return result.getResult();
                }
            }
        }
        return ItemStack.f_41583_;
    }

    static FluidActionResult tryFillContainer(IFluidTank tank, FluidStack fluidSource, @Nonnull ItemStack container, boolean doFill) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return FluidUtil.getFluidHandler((ItemStack)containerCopy).map(containerFluidHandler -> {
            int fillableAmount = containerFluidHandler.fill(fluidSource, IFluidHandler.FluidAction.SIMULATE);
            if (fillableAmount > 0) {
                if (doFill) {
                    FluidStack fs = new FluidStack(fluidSource, Math.min(fluidSource.getAmount(), fillableAmount));
                    containerFluidHandler.fill(fs, IFluidHandler.FluidAction.EXECUTE);
                    tank.drain(fs, IFluidHandler.FluidAction.EXECUTE);
                }
                ItemStack resultContainer = containerFluidHandler.getContainer();
                return new FluidActionResult(resultContainer);
            }
            return FluidActionResult.FAILURE;
        }).orElse(FluidActionResult.FAILURE);
    }

    private FluidHelper() {
    }
}

