/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.api.crafting;

import java.util.List;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;
import org.cyclops.integratedcrafting.api.crafting.UnknownCraftingRecipeException;

public class FailedCraftingRecipeException
extends Exception {
    private final IRecipeDefinition recipe;
    private final long quantityMissing;
    private final List<UnknownCraftingRecipeException> missingChildRecipes;
    private final IMixedIngredients ingredientsStorage;
    private final List<CraftingJob> partialCraftingJobs;

    public FailedCraftingRecipeException(IRecipeDefinition recipe, long quantityMissing, List<UnknownCraftingRecipeException> missingChildRecipes, IMixedIngredients ingredientsStorage, List<CraftingJob> partialCraftingJobs) {
        this.recipe = recipe;
        this.quantityMissing = quantityMissing;
        this.missingChildRecipes = missingChildRecipes;
        this.ingredientsStorage = ingredientsStorage;
        this.partialCraftingJobs = partialCraftingJobs;
    }

    public IRecipeDefinition getRecipe() {
        return this.recipe;
    }

    public long getQuantityMissing() {
        return this.quantityMissing;
    }

    public List<UnknownCraftingRecipeException> getMissingChildRecipes() {
        return this.missingChildRecipes;
    }

    public IMixedIngredients getIngredientsStorage() {
        return this.ingredientsStorage;
    }

    public List<CraftingJob> getPartialCraftingJobs() {
        return this.partialCraftingJobs;
    }

    @Override
    public String getMessage() {
        return String.format("Could craft the recipe %s (with %s missing, and %s stored, and %s partial), with missing sub-recipes: %s", this.getRecipe(), this.getQuantityMissing(), this.getIngredientsStorage(), this.getPartialCraftingJobs(), this.getMissingChildRecipes());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FailedCraftingRecipeException)) {
            return false;
        }
        FailedCraftingRecipeException that = (FailedCraftingRecipeException)obj;
        return this.getRecipe().equals(that.getRecipe()) && this.getQuantityMissing() == that.getQuantityMissing() && this.getMissingChildRecipes().equals(that.getMissingChildRecipes()) && this.getIngredientsStorage().equals(that.getIngredientsStorage()) && this.getPartialCraftingJobs().equals(that.getPartialCraftingJobs());
    }
}

