/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;

public class MissingIngredients<T, M> {
    private final List<Element<T, M>> elements;

    public MissingIngredients(List<Element<T, M>> elements) {
        this.elements = elements;
    }

    public List<Element<T, M>> getElements() {
        return this.elements;
    }

    public boolean equals(Object obj) {
        return obj instanceof MissingIngredients && this.getElements().equals(((MissingIngredients)obj).getElements());
    }

    public String toString() {
        return this.getElements().toString();
    }

    public static CompoundTag serialize(Map<IngredientComponent<?, ?>, MissingIngredients<?, ?>> ingredients) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<IngredientComponent<?, ?>, MissingIngredients<?, ?>> entry : ingredients.entrySet()) {
            ListTag missingIngredientsTag = new ListTag();
            for (Element<?, ?> element : entry.getValue().getElements()) {
                ListTag elementsTag = new ListTag();
                for (PrototypedWithRequested<?, ?> alternative : element.getAlternatives()) {
                    CompoundTag alternativeTag = new CompoundTag();
                    alternativeTag.m_128365_("requestedPrototype", (Tag)IPrototypedIngredient.serialize(alternative.getRequestedPrototype()));
                    alternativeTag.m_128356_("quantityMissing", alternative.getQuantityMissing());
                    alternativeTag.m_128379_("inputReusable", element.isInputReusable());
                    elementsTag.add((Object)alternativeTag);
                }
                missingIngredientsTag.add((Object)elementsTag);
            }
            tag.m_128365_(entry.getKey().getName().toString(), (Tag)missingIngredientsTag);
        }
        return tag;
    }

    public static Map<IngredientComponent<?, ?>, MissingIngredients<?, ?>> deserialize(CompoundTag tag) throws IllegalArgumentException {
        IdentityHashMap map = Maps.newIdentityHashMap();
        for (String componentName : tag.m_128431_()) {
            IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(componentName));
            if (component == null) {
                throw new IllegalArgumentException("Could not find the ingredient component type " + componentName);
            }
            ArrayList elements = Lists.newArrayList();
            ListTag missingIngredientsTag = tag.m_128437_(componentName, 9);
            for (int i = 0; i < missingIngredientsTag.size(); ++i) {
                ListTag elementsTag = (ListTag)missingIngredientsTag.get(i);
                ArrayList alternatives = Lists.newArrayList();
                boolean inputReusable = false;
                for (int j = 0; j < elementsTag.size(); ++j) {
                    CompoundTag alternativeTag = elementsTag.m_128728_(j);
                    PrototypedIngredient requestedPrototype = IPrototypedIngredient.deserialize((CompoundTag)alternativeTag.m_128469_("requestedPrototype"));
                    long quantityMissing = alternativeTag.m_128454_("quantityMissing");
                    inputReusable = alternativeTag.m_128471_("inputReusable");
                    alternatives.add(new PrototypedWithRequested(requestedPrototype, quantityMissing));
                }
                elements.add(new Element(alternatives, inputReusable));
            }
            MissingIngredients missingIngredients = new MissingIngredients(elements);
            map.put(component, missingIngredients);
        }
        return map;
    }

    public static class Element<T, M> {
        private final List<PrototypedWithRequested<T, M>> alternatives;
        private final boolean inputReusable;

        public Element(List<PrototypedWithRequested<T, M>> alternatives, boolean inputReusable) {
            this.alternatives = alternatives;
            this.inputReusable = inputReusable;
        }

        public List<PrototypedWithRequested<T, M>> getAlternatives() {
            return this.alternatives;
        }

        public boolean isInputReusable() {
            return this.inputReusable;
        }

        public boolean equals(Object obj) {
            return obj instanceof Element && this.getAlternatives().equals(((Element)obj).getAlternatives()) && this.isInputReusable() == ((Element)obj).isInputReusable();
        }

        public String toString() {
            return this.getAlternatives().toString() + "::" + this.isInputReusable();
        }
    }

    public static class PrototypedWithRequested<T, M> {
        private final IPrototypedIngredient<T, M> requestedPrototype;
        private final long quantityMissing;

        public PrototypedWithRequested(IPrototypedIngredient<T, M> requestedPrototype, long quantityMissing) {
            this.requestedPrototype = requestedPrototype;
            this.quantityMissing = quantityMissing;
        }

        public IPrototypedIngredient<T, M> getRequestedPrototype() {
            return this.requestedPrototype;
        }

        public long getQuantityMissing() {
            return this.quantityMissing;
        }

        public boolean equals(Object obj) {
            return obj instanceof PrototypedWithRequested && this.getRequestedPrototype().equals(((PrototypedWithRequested)obj).getRequestedPrototype()) && this.getQuantityMissing() == ((PrototypedWithRequested)obj).getQuantityMissing();
        }

        public String toString() {
            return String.format("[Prototype: %s; missing: %s]", this.getRequestedPrototype(), this.getQuantityMissing());
        }
    }
}

