/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.gui.RenderItemExtendedSlotCount;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetArrowedListField;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.proxy.ClientProxy;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalButton;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageSlot;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabClient;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.core.terminalstorage.button.TerminalButtonItemStackCraftingGridClear;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemStackCraftingGridBalance;
import org.lwjgl.opengl.GL11;

public class ContainerScreenTerminalStorage<L, C extends ContainerTerminalStorageBase<L>>
extends ContainerScreenExtended<C> {
    private static int TAB_OFFSET_X = 24;
    private static int TAB_WIDTH = 24;
    private static int TAB_UNSELECTED_HEIGHT = 21;
    private static int TAB_SELECTED_HEIGHT = 24;
    private static int TAB_ICON_OFFSET = 4;
    private static int TAB_UNSELECTED_TEXTURE_X = 118;
    private static int TAB_SELECTED_TEXTURE_X = 142;
    private static int TAB_UNSELECTED_TEXTURE_Y = 0;
    private static int TAB_SELECTED_TEXTURE_Y = 0;
    private static int SCROLL_Y = 40;
    private static int SEARCH_X = 103;
    private static int SEARCH_Y = 27;
    private static int SEARCH_HEIGHT = 20;
    private static int CHANNEL_X = 58;
    private static int CHANNEL_Y = 25;
    private static int CHANNEL_WIDTH = 42;
    private static int CHANNEL_HEIGHT = 15;
    private static int BUTTONS_OFFSET_X = 0;
    private static int BUTTONS_OFFSET_Y = 22;
    private static int BUTTONS_OFFSET = 4;
    private WidgetArrowedListField<String> fieldChannel;
    private WidgetScrollBar scrollBar;
    private WidgetTextFieldExtended fieldSearch;
    private ButtonImage buttonSetDefaults;
    private int firstRow;
    private boolean initialized;
    protected final Set<Slot> terminalDragSplittingSlots = Sets.newHashSet();
    protected boolean terminalDragSplitting;
    private int terminalDragMode;
    private int terminalDragSplittingButton;
    private int terminalDragSplittingRemnant;
    private boolean clicked;

    public ContainerScreenTerminalStorage(C container, Inventory inventory, Component title) {
        super(container, inventory, title);
        ((ContainerTerminalStorageBase)((Object)container)).screen = this;
    }

    public void m_7856_() {
        this.m_169413_();
        super.m_7856_();
        this.initialized = false;
        this.fieldChannel = new WidgetArrowedListField(Minecraft.m_91087_().f_91062_, this.f_97735_ + CHANNEL_X, this.f_97736_ + CHANNEL_Y, CHANNEL_WIDTH, CHANNEL_HEIGHT, true, (Component)Component.m_237115_((String)"gui.integratedterminals.channel"), true, ((ContainerTerminalStorageBase)((Object)this.getMenu())).getChannelStrings());
        this.fieldChannel.m_94199_(15);
        this.fieldChannel.m_94194_(true);
        this.fieldChannel.m_94202_(0xFFFFFF);
        this.fieldChannel.m_94190_(true);
        this.fieldChannel.m_94186_(true);
        int activeChannel = ((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel();
        if (activeChannel != -1) {
            this.fieldChannel.m_94144_(Integer.toString(activeChannel));
        }
        this.firstRow = 0;
        this.scrollBar = new WidgetScrollBar(this.f_97735_ + this.getGridXSize() + 33, this.f_97736_ + SCROLL_Y + 1, this.getScrollHeight() - 2, (Component)Component.m_237119_(), firstRow -> {
            this.firstRow = firstRow;
        }, 0){

            public int getTotalRows() {
                Object container = ContainerScreenTerminalStorage.this.getMenu();
                Optional<ITerminalStorageTabClient<?>> tabOptional = ContainerScreenTerminalStorage.this.getSelectedClientTab();
                if (!tabOptional.isPresent()) {
                    return 0;
                }
                int totalSlots = tabOptional.get().getSlotCount(((ContainerTerminalStorageBase)((Object)container)).getSelectedChannel());
                return (int)Math.ceil((double)totalSlots / (double)ContainerScreenTerminalStorage.this.getSlotRowLength());
            }

            public int getVisibleRows() {
                return ContainerScreenTerminalStorage.this.getSlotVisibleRows();
            }
        };
        this.m_7787_((GuiEventListener)this.scrollBar);
        this.fieldSearch = new WidgetTextFieldExtended(Minecraft.m_91087_().f_91062_, this.f_97735_ + SEARCH_X, this.f_97736_ + SEARCH_Y, this.getSearchWidth() - 10, SEARCH_HEIGHT, (Component)Component.m_237115_((String)"gui.cyclopscore.search"));
        this.fieldSearch.m_94199_(50);
        this.fieldSearch.m_94194_(true);
        this.fieldSearch.m_94202_(0xFFFFFF);
        this.fieldSearch.m_94190_(true);
        this.fieldSearch.m_94186_(true);
        this.fieldSearch.m_94182_(false);
        this.buttonSetDefaults = (ButtonImage)this.m_142416_((GuiEventListener)new ButtonImage(this.f_97735_ + 32 + this.getGridXSize() / 2 + this.getPlayerInventoryOffsetX() + 9 * GuiHelpers.SLOT_SIZE / 2 + 27, this.f_97736_ + this.getGridYSize() + this.getPlayerInventoryOffsetY() + 120, 15, 15, (Component)Component.m_237115_((String)"gui.integratedterminals.terminal_storage.setdefaults"), this.createServerPressable("button_set_defaults", b -> {}), true, (IImage)Images.ANVIL, -2, -3));
        this.repositionInventorySlots();
    }

    public void repositionInventorySlots() {
        Slot slot;
        int x;
        int y;
        int gridXSize = this.getGridXSize();
        int gridYSize = this.getGridYSize();
        int playerInventoryOffsetX = this.getPlayerInventoryOffsetX();
        int playerInventoryOffsetY = this.getPlayerInventoryOffsetY();
        ITerminalStorageTabCommon.SlotPositionFactors factors = new ITerminalStorageTabCommon.SlotPositionFactors(this.offsetX, this.offsetY, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY);
        for (y = 0; y < 1; ++y) {
            for (x = 0; x < 9; ++x) {
                slot = ((ContainerTerminalStorageBase)this.container).m_38853_(x + y * 9 + 0);
                ContainerExtended.setSlotPosX((Slot)slot, (int)(this.offsetX + 32 - 1 + gridXSize / 2 - 9 * GuiHelpers.SLOT_SIZE / 2 + playerInventoryOffsetX + 19 + x * GuiHelpers.SLOT_SIZE));
                ContainerExtended.setSlotPosY((Slot)slot, (int)(this.offsetY + 58 + 63 + gridYSize + playerInventoryOffsetY + y * GuiHelpers.SLOT_SIZE));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                slot = ((ContainerTerminalStorageBase)this.container).m_38853_(x + y * 9 + 9);
                ContainerExtended.setSlotPosX((Slot)slot, (int)(this.offsetX + 32 - 1 + gridXSize / 2 - 9 * GuiHelpers.SLOT_SIZE / 2 + playerInventoryOffsetX + 19 + x * GuiHelpers.SLOT_SIZE));
                ContainerExtended.setSlotPosY((Slot)slot, (int)(this.offsetY + 63 + gridYSize + playerInventoryOffsetY + y * GuiHelpers.SLOT_SIZE));
            }
        }
        for (y = 0; y < 4; ++y) {
            Slot slot2 = ((ContainerTerminalStorageBase)this.container).m_38853_(36 + y);
            ContainerExtended.setSlotPosX((Slot)slot2, (int)(this.offsetX + 32 - 1 + gridXSize / 2 - 9 * GuiHelpers.SLOT_SIZE / 2 + playerInventoryOffsetX - 19 + y % 2 * GuiHelpers.SLOT_SIZE));
            ContainerExtended.setSlotPosY((Slot)slot2, (int)(this.offsetY + 63 + gridYSize + playerInventoryOffsetY + 9 + (int)Math.floor(y / 2) * GuiHelpers.SLOT_SIZE));
        }
        Slot slot3 = ((ContainerTerminalStorageBase)this.container).m_38853_(40);
        ContainerExtended.setSlotPosX((Slot)slot3, (int)(this.offsetX + 32 - 1 + gridXSize / 2 - 9 * GuiHelpers.SLOT_SIZE / 2 + playerInventoryOffsetX - 10));
        ContainerExtended.setSlotPosY((Slot)slot3, (int)(this.offsetY + 63 + gridYSize + playerInventoryOffsetY + 9 + 49));
        Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
        tabOptional.ifPresent(tab -> {
            String tabName = ((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedTab();
            Optional<ITerminalStorageTabCommon> tabCommonOptional = this.getCommonTab(tabName);
            tabCommonOptional.ifPresent(tabCommon -> {
                for (Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback> slot : ((ContainerTerminalStorageBase)((Object)((Object)((Object)this.getMenu())))).getTabSlots(tabName)) {
                    Pair<Integer, Integer> slotPos = ((ITerminalStorageTabCommon.ISlotPositionCallback)slot.getRight()).getSlotPosition(factors);
                    ContainerExtended.setSlotPosX((Slot)((Slot)slot.getLeft()), (int)((Integer)slotPos.getLeft()));
                    ContainerExtended.setSlotPosY((Slot)((Slot)slot.getLeft()), (int)((Integer)slotPos.getRight()));
                }
            });
        });
    }

    public void m_181908_() {
        super.m_181908_();
        if (!this.initialized && this.getSelectedClientTab().isPresent()) {
            this.initialized = true;
            this.fieldSearch.m_94144_(this.getSelectedClientTab().get().getInstanceFilter(((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel()));
        }
        this.fieldSearch.m_94120_();
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integratedterminals", "textures/gui/part_terminal_storage.png");
    }

    public int getGridXSize() {
        return this.getSlotRowLength() * GuiHelpers.SLOT_SIZE;
    }

    public int getGridYSize() {
        return this.getSlotVisibleRows() * GuiHelpers.SLOT_SIZE;
    }

    public int getScrollHeight() {
        return this.getGridYSize();
    }

    public int getSearchWidth() {
        return this.getBaseXSize() - 7 * GuiHelpers.SLOT_SIZE - 2;
    }

    public int getBaseXSize() {
        return 56 + this.getGridXSize();
    }

    public int getBaseYSize() {
        return 135 + this.getGridYSize() + this.getPlayerInventoryOffsetY() + 10;
    }

    protected int getPlayerInventoryOffsetX() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getPlayerInventoryOffsetX).orElse(0);
    }

    protected int getPlayerInventoryOffsetY() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getPlayerInventoryOffsetY).orElse(0);
    }

    protected void m_7286_(PoseStack matrixStack, float f, int mouseX, int mouseY) {
        RenderHelpers.bindTexture((ResourceLocation)this.texture);
        this.renderBgTab(matrixStack, f, mouseX, mouseY);
        this.renderBgPlayerInventory(matrixStack, f, mouseX, mouseY);
        this.fieldChannel.m_6305_(matrixStack, mouseX, mouseY, f);
        this.fieldSearch.m_6305_(matrixStack, mouseX, mouseY, f);
        this.drawTabsBackground(matrixStack);
        this.drawTabContents(matrixStack, ((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedTab(), ((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel(), DrawLayer.BACKGROUND, f, this.getGuiLeftTotal() + this.getSlotsOffsetX(), this.getGuiTopTotal() + this.getSlotsOffsetY(), mouseX, mouseY);
        this.scrollBar.drawGuiContainerBackgroundLayer(matrixStack, f, mouseX, mouseY);
        Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
        tabOptional.ifPresent(tab -> {
            int offset = 0;
            int gridXSize = this.getGridXSize();
            int gridYSize = this.getGridYSize();
            int playerInventoryOffsetX = this.getPlayerInventoryOffsetX();
            int playerInventoryOffsetY = this.getPlayerInventoryOffsetY();
            ITerminalStorageTabCommon.SlotPositionFactors factors = new ITerminalStorageTabCommon.SlotPositionFactors(this.offsetX, this.offsetY, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY);
            for (ITerminalButton<?, ?, ?> button : tab.getButtons()) {
                Object guiButton = button.createButton(button.getX(this.f_97735_, BUTTONS_OFFSET_X, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY), button.getY(this.f_97736_, BUTTONS_OFFSET_Y + offset, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY));
                guiButton.m_6305_(matrixStack, mouseX, mouseY, f);
                if (!button.isInLeftColumn()) continue;
                offset += BUTTONS_OFFSET + guiButton.m_93694_();
            }
            String tabName = ((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedTab();
            Optional<ITerminalStorageTabCommon> tabCommonOptional = this.getCommonTab(tabName);
            tabCommonOptional.ifPresent(tabCommon -> {
                for (Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback> slot : ((ContainerTerminalStorageBase)((Object)((Object)((Object)this.getMenu())))).getTabSlots(tabName)) {
                    Pair<Integer, Integer> slotPos = ((ITerminalStorageTabCommon.ISlotPositionCallback)slot.getRight()).getSlotPosition(factors);
                    tab.onCommonSlotRender((AbstractContainerScreen)this, matrixStack, DrawLayer.BACKGROUND, 0.0f, this.f_97735_ + (Integer)slotPos.getLeft(), this.f_97736_ + (Integer)slotPos.getRight(), mouseX, mouseY, ((Slot)slot.getLeft()).f_40219_, (ITerminalStorageTabCommon)tabCommon);
                }
            });
        });
    }

    protected void renderBgTab(PoseStack matrixStack, float f, int mouseX, int mouseY) {
        int tabWidth = this.getGridXSize() + 29;
        int tabHeight = this.getGridYSize() + 40;
        int offset = 21;
        int blitOffset = 0;
        int cornerSize = 7;
        int columns = this.getSlotRowLength();
        int rows = this.getSlotVisibleRows();
        this.m_93228_(matrixStack, this.f_97735_ + offset, this.f_97736_ + offset, cornerSize, 0, cornerSize, cornerSize);
        this.m_93228_(matrixStack, this.f_97735_ + offset + tabWidth - cornerSize, this.f_97736_ + offset, 0, 0, cornerSize, cornerSize);
        this.m_93228_(matrixStack, this.f_97735_ + offset + tabWidth - cornerSize, this.f_97736_ + offset + tabHeight - cornerSize, cornerSize * 2, 0, cornerSize, cornerSize);
        this.m_93228_(matrixStack, this.f_97735_ + offset, this.f_97736_ + offset + tabHeight - cornerSize, cornerSize * 3, 0, cornerSize, cornerSize);
        ContainerScreenTerminalStorage.blitRescalable(matrixStack, this.f_97735_ + offset + cornerSize, this.f_97736_ + offset, blitOffset, cornerSize + 4, 0.0f, 1, cornerSize, 256, 256, tabWidth - cornerSize * 2, cornerSize);
        ContainerScreenTerminalStorage.blitRescalable(matrixStack, this.f_97735_ + offset + tabWidth - cornerSize, this.f_97736_ + offset + cornerSize, blitOffset, 0.0f, 4.0f, cornerSize, 1, 256, 256, cornerSize, tabHeight - cornerSize * 2);
        ContainerScreenTerminalStorage.blitRescalable(matrixStack, this.f_97735_ + offset + cornerSize, this.f_97736_ + offset + tabHeight - cornerSize, blitOffset, 25.0f, 0.0f, 1, cornerSize, 256, 256, tabWidth - cornerSize * 2, cornerSize);
        ContainerScreenTerminalStorage.blitRescalable(matrixStack, this.f_97735_ + offset, this.f_97736_ + offset + cornerSize, blitOffset, cornerSize, 4.0f, cornerSize, 1, 256, 256, cornerSize, tabHeight - cornerSize * 2);
        ContainerScreenTerminalStorage.blitRescalable(matrixStack, this.f_97735_ + offset + cornerSize, this.f_97736_ + offset + cornerSize, blitOffset, 0.0f, 3.0f, 1, 1, 256, 256, tabWidth - cornerSize * 2, tabHeight - cornerSize * 2);
        for (int j = 0; j < rows; ++j) {
            int renderRows = Math.min(3, rows - j);
            for (int i = 0; i < columns; ++i) {
                int renderColumns = Math.min(9, columns - i);
                this.m_93228_(matrixStack, this.f_97735_ + offset + 10 + i * GuiHelpers.SLOT_SIZE, this.f_97736_ + offset + 18 + j * GuiHelpers.SLOT_SIZE, 80, 34, GuiHelpers.SLOT_SIZE * renderColumns, GuiHelpers.SLOT_SIZE * renderRows);
                i += renderColumns - 1;
            }
            j += renderRows - 1;
        }
        this.m_93228_(matrixStack, this.f_97735_ + this.getGridXSize() + 32, this.f_97736_ + SCROLL_Y - 1, 20, 12, 14, 1);
        ContainerScreenTerminalStorage.blitRescalable(matrixStack, this.f_97735_ + this.getGridXSize() + 32, this.f_97736_ + SCROLL_Y, blitOffset, 20.0f, 13.0f, 14, 1, 256, 256, 14, this.getScrollHeight() - 2);
        this.m_93228_(matrixStack, this.f_97735_ + this.getGridXSize() + 32, this.f_97736_ + SCROLL_Y + this.getScrollHeight() - 2, 20, 101, 14, 1);
        this.m_93228_(matrixStack, this.f_97735_ + SEARCH_X - 1, this.f_97736_ + SEARCH_Y - 2, 28, 0, 1, SEARCH_HEIGHT - 8);
        ContainerScreenTerminalStorage.blitRescalable(matrixStack, this.f_97735_ + SEARCH_X, this.f_97736_ + SEARCH_Y - 2, blitOffset, 29.0f, 0.0f, 1, SEARCH_HEIGHT - 8, 256, 256, this.getSearchWidth(), SEARCH_HEIGHT - 8);
        this.m_93228_(matrixStack, this.f_97735_ + SEARCH_X + this.getSearchWidth() - 1, this.f_97736_ + SEARCH_Y - 2, 117, 0, 1, SEARCH_HEIGHT - 8);
        this.getSelectedClientTab().ifPresent(tab -> tab.onTabBackgroundRender(this, matrixStack, f, mouseX, mouseY));
    }

    public static void blitRescalable(PoseStack p_93144_, int p_93145_, int p_93146_, int p_93147_, float p_93148_, float p_93149_, int p_93150_, int p_93151_, int p_93152_, int p_93153_, int realWidth, int realHeight) {
        ContainerScreenTerminalStorage.m_93187_((PoseStack)p_93144_, (int)p_93145_, (int)(p_93145_ + realWidth), (int)p_93146_, (int)(p_93146_ + realHeight), (int)p_93147_, (int)p_93150_, (int)p_93151_, (float)p_93148_, (float)p_93149_, (int)p_93152_, (int)p_93153_);
    }

    protected void renderBgPlayerInventory(PoseStack matrixStack, float f, int mouseX, int mouseY) {
        this.m_93228_(matrixStack, this.f_97735_ + this.getGridXSize() / 2 - 9 * GuiHelpers.SLOT_SIZE / 2 + this.getPlayerInventoryOffsetX() + 3, this.f_97736_ + 52 + this.getGridYSize() + this.getPlayerInventoryOffsetY(), 34, 24, 216, 93);
        this.m_93228_(matrixStack, this.f_97735_ + this.getGridXSize() / 2 + 9 * GuiHelpers.SLOT_SIZE / 2 + this.getPlayerInventoryOffsetX() + 57, this.f_97736_ + 61 + this.getGridYSize() + this.getPlayerInventoryOffsetY(), 0, 12, 20, 57);
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        this.drawTabsForeground(matrixStack, mouseX, mouseY);
        this.drawTabContents(matrixStack, ((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedTab(), ((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel(), DrawLayer.FOREGROUND, 0.0f, this.getSlotsOffsetX(), this.getSlotsOffsetY(), mouseX, mouseY);
        RenderItemExtendedSlotCount.getInstance().f_115093_ = 150.0f;
        this.drawActiveStorageSlotItem(matrixStack, mouseX, mouseY);
        RenderItemExtendedSlotCount.getInstance().f_115093_ = 0.0f;
        Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
        tabOptional.ifPresent(tab -> {
            int offset = 0;
            int gridXSize = this.getGridXSize();
            int gridYSize = this.getGridYSize();
            int playerInventoryOffsetX = this.getPlayerInventoryOffsetX();
            int playerInventoryOffsetY = this.getPlayerInventoryOffsetY();
            ITerminalStorageTabCommon.SlotPositionFactors factors = new ITerminalStorageTabCommon.SlotPositionFactors(this.offsetX, this.offsetY, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY);
            for (ITerminalButton<?, ?, ?> button : tab.getButtons()) {
                Object guiButton = button.createButton(button.getX(this.f_97735_, BUTTONS_OFFSET_X, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY), button.getY(this.f_97736_, BUTTONS_OFFSET_Y + offset, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY));
                if (this.m_6774_(button.getX(0, BUTTONS_OFFSET_X, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY), button.getY(0, BUTTONS_OFFSET_Y + offset, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY), guiButton.m_5711_(), guiButton.m_93694_(), mouseX, mouseY)) {
                    ArrayList lines = Lists.newArrayList();
                    lines.add(Component.m_237115_((String)button.getTranslationKey()));
                    button.getTooltip((Player)this.getMinecraft().f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL, lines);
                    this.drawTooltip(lines, matrixStack, mouseX - this.f_97735_, mouseY - this.f_97736_);
                }
                if (!button.isInLeftColumn()) continue;
                offset += BUTTONS_OFFSET + guiButton.m_93694_();
            }
            String tabName = ((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedTab();
            Optional<ITerminalStorageTabCommon> tabCommonOptional = this.getCommonTab(tabName);
            tabCommonOptional.ifPresent(tabCommon -> {
                for (Pair<Slot, ITerminalStorageTabCommon.ISlotPositionCallback> slot : ((ContainerTerminalStorageBase)((Object)((Object)((Object)this.getMenu())))).getTabSlots(tabName)) {
                    Pair<Integer, Integer> slotPos = ((ITerminalStorageTabCommon.ISlotPositionCallback)slot.getRight()).getSlotPosition(factors);
                    tab.onCommonSlotRender((AbstractContainerScreen)this, matrixStack, DrawLayer.FOREGROUND, 0.0f, this.f_97735_ + (Integer)slotPos.getLeft(), this.f_97736_ + (Integer)slotPos.getRight(), mouseX, mouseY, ((Slot)slot.getLeft()).f_40219_, (ITerminalStorageTabCommon)tabCommon);
                }
            });
        });
        if (this.buttonSetDefaults.m_198029_()) {
            ArrayList lines = Lists.newArrayList();
            lines.add(Component.m_237115_((String)"gui.integratedterminals.terminal_storage.setdefaults"));
            lines.add(Component.m_237115_((String)"gui.integratedterminals.terminal_storage.setdefaults.info").m_130940_(ChatFormatting.GRAY));
            this.drawTooltip(lines, matrixStack, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    protected void drawCurrentScreen(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.scrollBar.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        ResourceLocation oldTexture = this.texture;
        this.getSelectedClientTab().ifPresent(tab -> {
            ResourceLocation texture = tab.getBackgroundTexture();
            if (texture != null) {
                this.texture = texture;
            }
        });
        super.drawCurrentScreen(matrixStack, mouseX, mouseY, partialTicks);
        GlStateManager.m_84507_();
        for (int i1 = 0; i1 < ((ContainerTerminalStorageBase)((Object)this.getMenu())).f_38839_.size(); ++i1) {
            Slot slot = (Slot)((ContainerTerminalStorageBase)((Object)this.getMenu())).f_38839_.get(i1);
            if (!slot.m_6659_()) continue;
            this.drawSlotOverlay(matrixStack, slot);
        }
        this.texture = oldTexture;
    }

    private void drawSlotOverlay(PoseStack matrixStack, Slot slot) {
        this.getSelectedClientTab().ifPresent(tab -> {
            if (this.terminalDragSplitting && this.terminalDragSplittingSlots.contains(slot)) {
                if (tab.isSlotValidForDraggingInto(((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel(), slot)) {
                    if (this.terminalDragSplittingSlots.size() == 1) {
                        return;
                    }
                    int dragQuantity = tab.computeDraggingQuantity(this.terminalDragSplittingSlots, this.terminalDragMode, slot.m_7993_(), tab.getActiveSlotQuantity());
                    if (dragQuantity > 0) {
                        String dragString = "+" + GuiHelpers.quantityToScaledString((long)dragQuantity);
                        RenderHelpers.drawScaledStringWithShadow((PoseStack)matrixStack, (Font)this.f_96547_, (String)dragString, (int)(this.f_97735_ + slot.f_40220_), (int)(this.f_97736_ + slot.f_40221_), (float)0.5f, (int)0xFFFF55);
                    }
                } else {
                    this.terminalDragSplittingSlots.remove(slot);
                    this.updateTerminalDragSplitting((ITerminalStorageTabClient<?>)tab);
                }
            }
        });
    }

    public C getMenu() {
        return (C)((Object)((ContainerTerminalStorageBase)super.m_6262_()));
    }

    protected Optional<ITerminalStorageTabClient<?>> getTabByIndex(int tabIndex) {
        Collection<ITerminalStorageTabClient<?>> tabsClientList = ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClient().values();
        if (tabIndex >= 0 && tabIndex < tabsClientList.size()) {
            return Optional.of((ITerminalStorageTabClient)Iterables.get(tabsClientList, (int)tabIndex));
        }
        return Optional.empty();
    }

    protected void setTabByIndex(int tabIndex) {
        this.getTabByIndex(tabIndex).ifPresent(tab -> {
            ((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).setSelectedTab(tab.getName().toString());
            tab.resetActiveSlot();
            this.fieldSearch.m_94144_(tab.getInstanceFilter(((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel()));
        });
        this.scrollBar.scrollTo(0.0f);
        this.m_7856_();
    }

    protected void playButtonClickSound() {
        this.getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
        this.clicked = true;
        if (mouseButton == 0 && mouseY < (double)(this.getGuiTop() + TAB_UNSELECTED_HEIGHT) && mouseX > (double)(this.getGuiLeft() + TAB_OFFSET_X) && mouseX <= (double)(this.getGuiLeft() + TAB_OFFSET_X + (TAB_WIDTH * ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClientCount() - 1))) {
            this.setTabByIndex((int)((mouseX - (double)TAB_OFFSET_X - (double)this.getGuiLeft()) / (double)TAB_WIDTH));
            this.playButtonClickSound();
            return true;
        }
        if (this.fieldChannel.m_6375_(mouseX, mouseY, mouseButton)) {
            int channel;
            try {
                channel = Integer.parseInt((String)this.fieldChannel.getActiveElement());
            }
            catch (NumberFormatException e) {
                channel = -1;
            }
            int finalChannel = channel;
            ((ContainerTerminalStorageBase)((Object)this.getMenu())).setSelectedChannel(channel);
            this.scrollBar.scrollTo(0.0f);
            tabOptional.ifPresent(tab -> this.fieldSearch.m_94144_(tab.getInstanceFilter(finalChannel)));
            this.playButtonClickSound();
            return true;
        }
        if (tabOptional.isPresent()) {
            ITerminalStorageTabClient<?> tab2 = tabOptional.get();
            Slot playerSlot = this.getSlotUnderMouse();
            if (!(tab2.getActiveSlotId() < 0 || mouseButton != 0 && mouseButton != 1 && this.getMinecraft().f_91066_.f_92097_.getKey().m_84873_() != mouseButton - 100 || playerSlot == null || this.terminalDragSplitting)) {
                this.terminalDragSplitting = true;
                this.terminalDragSplittingButton = mouseButton;
                this.terminalDragSplittingSlots.clear();
                if (mouseButton == 0) {
                    this.terminalDragMode = 0;
                } else if (mouseButton == 1) {
                    this.terminalDragMode = 1;
                } else if (this.getMinecraft().f_91066_.f_92097_.getKey().m_84873_() == mouseButton - 100) {
                    this.terminalDragMode = 2;
                }
                return true;
            }
            if (MinecraftHelpers.isShifted() && playerSlot != null && tab2.isQuickMovePrevented(playerSlot)) {
                return true;
            }
        } else if (this.getSlotUnderMouse() != null) {
            return false;
        }
        this.fieldSearch.m_6375_(mouseX, mouseY, mouseButton);
        tabOptional.ifPresent(tab -> {
            int offset = 0;
            ITerminalStorageTabCommon tabCommon = ((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getTabCommon(tab.getName().toString());
            int gridXSize = this.getGridXSize();
            int gridYSize = this.getGridYSize();
            int playerInventoryOffsetX = this.getPlayerInventoryOffsetX();
            int playerInventoryOffsetY = this.getPlayerInventoryOffsetY();
            for (ITerminalButton<?, ?, ?> button : tab.getButtons()) {
                Object guiButton = button.createButton(button.getX(this.f_97735_, BUTTONS_OFFSET_X, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY), button.getY(this.f_97736_, BUTTONS_OFFSET_Y + offset, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY));
                if (this.m_6774_(button.getX(0, BUTTONS_OFFSET_X, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY), button.getY(0, BUTTONS_OFFSET_Y + offset, gridXSize, gridYSize, playerInventoryOffsetX, playerInventoryOffsetY), guiButton.m_5711_(), guiButton.m_93694_(), mouseX, mouseY)) {
                    button.onClick(tab, tabCommon, guiButton, ((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel(), mouseButton);
                    this.clicked = false;
                    this.playButtonClickSound();
                    return;
                }
                if (!button.isInLeftColumn()) continue;
                offset += BUTTONS_OFFSET + guiButton.m_93694_();
            }
        });
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    @Nullable
    public Slot getSlotUnderMouse() {
        Slot slot = super.getSlotUnderMouse();
        if (slot != null && slot.f_40220_ < 0) {
            return null;
        }
        return slot;
    }

    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double mouseXPrev, double mouseYPrev) {
        if (this.getSelectedClientTab().map(tab -> {
            Slot slot;
            if (this.terminalDragSplitting & tab.getActiveSlotId() >= 0 && (slot = this.getSlotUnderMouse()) != null && (tab.getActiveSlotQuantity() > this.terminalDragSplittingSlots.size() || this.terminalDragMode == 2) && tab.isSlotValidForDraggingInto(((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel(), slot)) {
                this.terminalDragSplittingSlots.add(slot);
                this.updateTerminalDragSplitting((ITerminalStorageTabClient<?>)tab);
                return true;
            }
            return false;
        }).orElse(false).booleanValue()) {
            return true;
        }
        return this.m_7222_() != null && this.m_7282_() && mouseButton == 0 && this.m_7222_().m_7979_(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev) ? true : super.m_7979_(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
    }

    private void updateTerminalDragSplitting(ITerminalStorageTabClient<?> tab) {
        if (this.terminalDragSplitting) {
            int quantityTotal = tab.getActiveSlotQuantity();
            this.terminalDragSplittingRemnant = tab.getActiveSlotQuantity();
            for (Slot slot : this.terminalDragSplittingSlots) {
                if (!tab.isSlotValidForDraggingInto(((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel(), slot)) continue;
                int dragQuantity = tab.computeDraggingQuantity(this.terminalDragSplittingSlots, this.terminalDragMode, slot.m_7993_(), quantityTotal);
                this.terminalDragSplittingRemnant -= tab.dragIntoSlot((AbstractContainerMenu)this.container, ((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel(), slot, dragQuantity, true);
            }
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        if (this.terminalDragSplitting && (this.terminalDragSplittingSlots.size() <= 1 || this.terminalDragSplittingButton != mouseButton)) {
            this.terminalDragSplitting = false;
            this.terminalDragSplittingSlots.clear();
            if (this.terminalDragSplittingButton != mouseButton) {
                return true;
            }
        }
        boolean dragged = false;
        if (this.terminalDragSplitting) {
            dragged = true;
            this.getSelectedClientTab().ifPresent(tab -> {
                if (tab.getActiveSlotQuantity() > 0) {
                    int quantityTotal;
                    int quantity = quantityTotal = tab.getActiveSlotQuantity();
                    for (Slot slot : this.terminalDragSplittingSlots) {
                        if (!tab.isSlotValidForDraggingInto(((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel(), slot)) continue;
                        int dragQuantity = tab.computeDraggingQuantity(this.terminalDragSplittingSlots, this.terminalDragMode, slot.m_7993_(), quantityTotal);
                        quantity -= tab.dragIntoSlot((AbstractContainerMenu)this.container, ((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel(), slot, dragQuantity, false);
                    }
                    tab.setActiveSlotQuantity(quantity);
                }
            });
        }
        this.terminalDragSplitting = false;
        this.terminalDragSplittingSlots.clear();
        this.terminalDragSplittingButton = -1;
        this.terminalDragMode = -1;
        this.terminalDragSplittingRemnant = 0;
        if (!dragged && this.clicked) {
            this.clicked = false;
            Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
            if (tabOptional.isPresent()) {
                int slot = this.getStorageSlotIndexAtPosition(mouseX, mouseY);
                Slot playerSlot = this.getSlotUnderMouse();
                boolean hasClickedOutside = this.m_7467_(mouseX, mouseY, this.f_97735_, this.f_97736_, mouseButton);
                boolean hasClickedInStorage = this.hasClickedInStorage(mouseX, mouseY);
                if (tabOptional.get().handleClick((AbstractContainerMenu)this.getMenu(), ((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel(), slot, mouseButton, hasClickedOutside, hasClickedInStorage, playerSlot != null ? playerSlot.f_40219_ : -1, false)) {
                    return true;
                }
            }
        }
        return super.m_6348_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        Optional<ITerminalStorageTabClient<?>> tabOptional = this.getSelectedClientTab();
        if (tabOptional.isPresent()) {
            int slot = this.getStorageSlotIndexAtPosition(mouseX, mouseY);
            Slot playerSlot = this.getSlotUnderMouse();
            boolean hasClickedOutside = this.m_7467_(mouseX, mouseY, this.f_97735_, this.f_97736_, 0);
            boolean hasClickedInStorage = this.hasClickedInStorage(mouseX, mouseY);
            if (tabOptional.get().handleScroll((AbstractContainerMenu)this.getMenu(), ((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel(), slot, delta, hasClickedOutside, hasClickedInStorage, playerSlot != null ? playerSlot.f_40219_ : -1)) {
                return true;
            }
        }
        return this.m_94729_(mouseX, mouseY).filter(listener -> listener.m_6050_(mouseX, mouseY, delta)).isPresent();
    }

    protected boolean handleKeyCodeFirst(int keyCode, int scanCode) {
        InputConstants.Key inputCode = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (ClientProxy.FOCUS_LP_SEARCH.isActiveAndMatches(inputCode)) {
            this.fieldSearch.m_5755_(true);
            return true;
        }
        if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_TAB_NEXT.isActiveAndMatches(inputCode)) {
            if (((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClientCount() > 0) {
                this.setTabByIndex((this.getSelectedClientTabIndex() + 1) % ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClientCount());
                this.playButtonClickSound();
                return true;
            }
        } else if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_TAB_PREVIOUS.isActiveAndMatches(inputCode) && ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClientCount() > 0) {
            this.setTabByIndex((((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClientCount() + this.getSelectedClientTabIndex() - 1) % ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClientCount());
            this.playButtonClickSound();
            return true;
        }
        return false;
    }

    protected boolean handleKeyCodeLast(int keyCode, int scanCode) {
        InputConstants.Key inputCode = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_CRAFTINGGRID_CLEARPLAYER.isActiveAndMatches(inputCode)) {
            this.clearCraftingGrid(false);
            this.playButtonClickSound();
            return true;
        }
        if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_CRAFTINGGRID_CLEARSTORAGE.isActiveAndMatches(inputCode)) {
            this.clearCraftingGrid(true);
            this.playButtonClickSound();
            return true;
        }
        if (org.cyclops.integratedterminals.proxy.ClientProxy.TERMINAL_CRAFTINGGRID_BALANCE.isActiveAndMatches(inputCode)) {
            this.balanceCraftingGrid();
            this.playButtonClickSound();
            return true;
        }
        return false;
    }

    public boolean m_5534_(char keyCode, int scanCode) {
        if (this.handleKeyCodeFirst(keyCode, scanCode)) {
            return true;
        }
        if (this.fieldSearch.m_93696_()) {
            if (this.fieldSearch.m_5534_(keyCode, scanCode)) {
                this.getSelectedClientTab().ifPresent(tab -> tab.setInstanceFilter(((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel(), this.fieldSearch.m_94155_()));
            }
            return true;
        }
        return this.handleKeyCodeLast(keyCode, scanCode) || super.m_5534_(keyCode, scanCode);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode != 256) {
            if (this.handleKeyCodeFirst(keyCode, scanCode)) {
                return true;
            }
            if (this.fieldSearch.m_93696_()) {
                if (this.fieldSearch.m_7933_(keyCode, scanCode, modifiers)) {
                    this.getSelectedClientTab().ifPresent(tab -> tab.setInstanceFilter(((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel(), this.fieldSearch.m_94155_()));
                }
                return true;
            }
            if (this.handleKeyCodeLast(keyCode, scanCode)) {
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void clearCraftingGrid(boolean toStorage) {
        ITerminalStorageTabCommon commonTab = ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabCommon(((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedTab());
        if (commonTab instanceof TerminalStorageTabIngredientComponentItemStackCraftingCommon) {
            TerminalButtonItemStackCraftingGridClear.clearGrid((TerminalStorageTabIngredientComponentItemStackCraftingCommon)commonTab, ((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedChannel(), toStorage);
        }
    }

    protected void balanceCraftingGrid() {
        ITerminalStorageTabCommon commonTab = ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabCommon(((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedTab());
        if (commonTab instanceof TerminalStorageTabIngredientComponentItemStackCraftingCommon) {
            IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new TerminalStorageIngredientItemStackCraftingGridBalance(commonTab.getName().toString()));
        }
    }

    private boolean hasClickedInStorage(double mouseX, double mouseY) {
        return mouseX >= (double)(this.getGuiLeftTotal() + this.getSlotsOffsetX()) && mouseX < (double)(this.getGuiLeftTotal() + this.getSlotsOffsetX() + this.getSlotRowLength() * GuiHelpers.SLOT_SIZE - 1) && mouseY >= (double)(this.getGuiTopTotal() + this.getSlotsOffsetY()) && mouseY < (double)(this.getGuiTopTotal() + this.getSlotsOffsetY() + this.getSlotVisibleRows() * GuiHelpers.SLOT_SIZE);
    }

    public int getStorageSlotIndexAtPosition(double mouseX, double mouseY) {
        if (this.hasClickedInStorage(mouseX, mouseY) && (mouseX - (double)this.getGuiLeftTotal() - (double)this.getSlotsOffsetX()) % (double)GuiHelpers.SLOT_SIZE < (double)GuiHelpers.SLOT_SIZE_INNER && (mouseY - (double)this.getGuiTopTotal() - (double)this.getSlotsOffsetY()) % (double)GuiHelpers.SLOT_SIZE < (double)GuiHelpers.SLOT_SIZE_INNER) {
            int rowLength = this.getSlotRowLength();
            int offset = this.getSelectedFirstRow() * rowLength;
            return offset + ((int)mouseX - this.getGuiLeftTotal() - this.getSlotsOffsetX()) / GuiHelpers.SLOT_SIZE + ((int)mouseY - this.getGuiTopTotal() - this.getSlotsOffsetY()) / GuiHelpers.SLOT_SIZE * this.getSlotRowLength();
        }
        return -1;
    }

    public Rect2i getStorageSlotRect(int slotIndex) {
        int rowLength = this.getSlotRowLength();
        int offset = this.getSelectedFirstRow() * rowLength;
        int visibleIndex = slotIndex - offset;
        int xIndex = visibleIndex % rowLength;
        int yIndex = visibleIndex / rowLength;
        int x = this.getGuiLeftTotal() + this.getSlotsOffsetX() + xIndex * GuiHelpers.SLOT_SIZE + 1;
        int y = this.getGuiTopTotal() + this.getSlotsOffsetY() + yIndex * GuiHelpers.SLOT_SIZE + 1;
        Rect2i slotRect = new Rect2i(x, y, GuiHelpers.SLOT_SIZE_INNER, GuiHelpers.SLOT_SIZE_INNER);
        return slotRect;
    }

    protected void drawTabsBackground(PoseStack matrixStack) {
        int offsetX = TAB_OFFSET_X;
        ContainerScreenTerminalStorage.m_93236_((PoseStack)matrixStack, (Font)this.f_96547_, (String)L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.channel", (Object[])new Object[0]), (int)(this.getGuiLeft() + 30), (int)(this.getGuiTop() + 26), (int)0xFFFFFF);
        for (ITerminalStorageTabClient<?> tab : ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClient().values()) {
            boolean selected = tab.getName().toString().equals(((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedTab());
            int x = this.getGuiLeft() + offsetX;
            int y = this.getGuiTop();
            int width = TAB_WIDTH;
            int height = selected ? TAB_SELECTED_HEIGHT : TAB_UNSELECTED_HEIGHT;
            int textureX = selected ? TAB_SELECTED_TEXTURE_X : TAB_UNSELECTED_TEXTURE_X;
            int textureY = selected ? TAB_SELECTED_TEXTURE_Y : TAB_UNSELECTED_TEXTURE_Y;
            RenderHelpers.bindTexture((ResourceLocation)this.texture);
            this.m_93228_(matrixStack, x, y, textureX, textureY, width, height);
            ItemStack icon = tab.getIcon();
            ItemRenderer renderItem = Minecraft.m_91087_().m_91291_();
            matrixStack.m_85836_();
            GlStateManager.m_84525_();
            GlStateManager.m_84328_((int)770, (int)771);
            Lighting.m_84931_();
            GL11.glEnable((int)2929);
            renderItem.m_115203_(icon, x + TAB_ICON_OFFSET, y + TAB_ICON_OFFSET);
            Lighting.m_84930_();
            matrixStack.m_85849_();
            GL11.glDisable((int)2929);
            offsetX += width;
        }
    }

    protected int getSlotsOffsetX() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getSlotOffsetX).orElse(32);
    }

    protected int getSlotsOffsetY() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getSlotOffsetY).orElse(40);
    }

    protected int getSlotVisibleRows() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getSlotVisibleRows).orElse(5);
    }

    protected int getSlotRowLength() {
        return this.getSelectedClientTab().map(ITerminalStorageTabClient::getSlotRowLength).orElse(9);
    }

    protected int getSelectedFirstRow() {
        return this.firstRow;
    }

    protected void drawTabContents(PoseStack matrixStack, String tabId, int channel, DrawLayer layer, float partialTick, int x, int y, int mouseX, int mouseY) {
        Optional<ITerminalStorageTabClient<?>> optionalTab = this.getClientTab(tabId);
        if (optionalTab.isPresent()) {
            ITerminalStorageTabClient<?> tab = optionalTab.get();
            if (layer == DrawLayer.BACKGROUND) {
                ContainerScreenTerminalStorage.m_93208_((PoseStack)matrixStack, (Font)this.f_96547_, (String)tab.getStatus(channel), (int)(this.f_97735_ + 32 + GuiHelpers.SLOT_SIZE * tab.getRowColumnProvider().getRowsAndColumns().columns() / 2), (int)(y + 2 + this.getSlotVisibleRows() * GuiHelpers.SLOT_SIZE), (int)0xFFFFFF);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            int rowLength = this.getSlotRowLength();
            int limit = this.getSlotVisibleRows() * rowLength;
            int offset = this.getSelectedFirstRow() * rowLength;
            List<?> slots = tab.getSlots(channel, offset, limit);
            int slotX = x;
            int slotY = y;
            int slotI = 0;
            for (ITerminalStorageSlot slot : slots) {
                if (layer == DrawLayer.BACKGROUND) {
                    RenderHelpers.bindTexture((ResourceLocation)this.texture);
                    if (RenderHelpers.isPointInRegion((int)slotX, (int)slotY, (int)GuiHelpers.SLOT_SIZE_INNER, (int)GuiHelpers.SLOT_SIZE_INNER, (double)mouseX, (double)mouseY)) {
                        ContainerScreenTerminalStorage.m_93172_((PoseStack)matrixStack, (int)slotX, (int)slotY, (int)(slotX + GuiHelpers.SLOT_SIZE_INNER), (int)(slotY + GuiHelpers.SLOT_SIZE_INNER), (int)-2130706433);
                    }
                }
                slot.drawGuiContainerLayer((AbstractContainerScreen)this, matrixStack, layer, partialTick, slotX, slotY, mouseX, mouseY, tab, channel, null);
                if (++slotI >= rowLength) {
                    slotX = x;
                    slotY += GuiHelpers.SLOT_SIZE;
                    slotI = 0;
                    continue;
                }
                slotX += GuiHelpers.SLOT_SIZE;
            }
        } else {
            RenderSystem.m_157429_((float)0.3f, (float)0.3f, (float)0.3f, (float)0.3f);
            ContainerScreenTerminalStorage.m_93172_((PoseStack)matrixStack, (int)(x - 1), (int)(y - 1), (int)(x - 1 + GuiHelpers.SLOT_SIZE * this.getSlotRowLength()), (int)(y - 1 + GuiHelpers.SLOT_SIZE * this.getSlotVisibleRows()), (int)Helpers.RGBAToInt((int)50, (int)50, (int)50, (int)100));
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void drawActiveStorageSlotItem(PoseStack matrixStack, int mouseX, int mouseY) {
        Optional<ITerminalStorageTabClient<?>> optionalTab = this.getSelectedClientTab();
        optionalTab.ifPresent(tab -> {
            int slotId = tab.getActiveSlotId();
            if (slotId >= 0) {
                int quantity = tab.getActiveSlotQuantity();
                List slots = tab.getSlots(((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel(), slotId, 1);
                if (!slots.isEmpty()) {
                    ITerminalStorageSlot slot = (ITerminalStorageSlot)slots.get(0);
                    RenderHelpers.bindTexture((ResourceLocation)this.texture);
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (this.terminalDragSplitting && this.terminalDragSplittingSlots.size() > 1) {
                        quantity = this.terminalDragSplittingRemnant;
                    }
                    Object quantityString = GuiHelpers.quantityToScaledString((long)quantity);
                    if (quantity == 0) {
                        quantityString = ChatFormatting.YELLOW + (String)quantityString;
                    }
                    slot.drawGuiContainerLayer((AbstractContainerScreen)this, matrixStack, DrawLayer.BACKGROUND, 0.0f, mouseX - this.f_97735_ - GuiHelpers.SLOT_SIZE_INNER / 4, mouseY - this.f_97736_ - GuiHelpers.SLOT_SIZE_INNER / 4, mouseX, mouseY, (ITerminalStorageTabClient)tab, ((ContainerTerminalStorageBase)((Object)((Object)this.getMenu()))).getSelectedChannel(), (String)quantityString);
                }
            }
        });
    }

    protected Optional<ITerminalStorageTabClient<?>> getClientTab(String tab) {
        return Optional.ofNullable(((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClient().get(tab));
    }

    protected Optional<ITerminalStorageTabCommon> getCommonTab(String tab) {
        return Optional.ofNullable(((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsCommon().get(tab));
    }

    public Optional<ITerminalStorageTabClient<?>> getSelectedClientTab() {
        return this.getClientTab(((ContainerTerminalStorageBase)((Object)this.getMenu())).getSelectedTab());
    }

    protected int getSelectedClientTabIndex() {
        Optional<ITerminalStorageTabClient<?>> selectedTab = this.getSelectedClientTab();
        if (selectedTab.isPresent()) {
            int tabIndex = 0;
            for (ITerminalStorageTabClient<?> tabClient : ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClient().values()) {
                if (tabClient == selectedTab.get()) {
                    return tabIndex;
                }
                ++tabIndex;
            }
        }
        return -1;
    }

    protected void drawTabsForeground(PoseStack poseStack, int mouseX, int mouseY) {
        if (mouseY < this.getGuiTop() + TAB_UNSELECTED_HEIGHT && mouseX > this.getGuiLeft() + TAB_OFFSET_X && mouseX <= this.getGuiLeft() + TAB_OFFSET_X + (TAB_WIDTH * ((ContainerTerminalStorageBase)((Object)this.getMenu())).getTabsClientCount() - 1)) {
            int tabIndex = (mouseX - TAB_OFFSET_X - this.getGuiLeft()) / TAB_WIDTH;
            this.getTabByIndex(tabIndex).ifPresent(tab -> this.drawTooltip(tab.getTooltip(), poseStack, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop()));
        }
    }

    public WidgetTextFieldExtended getFieldSearch() {
        return this.fieldSearch;
    }

    public static enum DrawLayer {
        BACKGROUND,
        FOREGROUND;

    }
}

