/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.limiter.capability;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

public final class MobNumberLimit
implements INBTSerializable<CompoundTag> {
    private EnumMap<MobCategory, Integer> map = new EnumMap(MobCategory.class);

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.map.forEach((mobCategory, integer) -> tag.m_128405_(mobCategory.m_21607_(), integer.intValue()));
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        Map savedData = nbt.m_128431_().stream().map(MobNumberLimit::get).filter(Objects::nonNull).collect(Collectors.toMap(Function.identity(), t -> nbt.m_128451_(t.m_21607_())));
        this.map = savedData.isEmpty() ? new EnumMap(MobCategory.class) : new EnumMap(savedData);
    }

    public OptionalInt getLimit(MobCategory mobCategory) {
        if (this.map.containsKey(mobCategory)) {
            return OptionalInt.of(this.map.get(mobCategory));
        }
        return OptionalInt.empty();
    }

    public void set(MobCategory mobCategory, int limit) {
        this.map.put(mobCategory, limit);
    }

    public Optional<Component> getMessage() {
        if (this.map.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Component.m_237113_((String)this.map.entrySet().stream().map(e -> "%s%s%s: %d".formatted(ChatFormatting.AQUA, e.getKey(), ChatFormatting.RESET, e.getValue())).collect(Collectors.joining("\n"))));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MobNumberLimit that = (MobNumberLimit)o;
        return this.map.equals((Object)that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    @Nullable
    private static MobCategory get(String s) {
        return MobCategory.byName((String)s);
    }
}

