/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.limiter.conditions;

import com.kotori316.limiter.LimitMobSpawn;
import com.kotori316.limiter.TestSpawn;
import com.kotori316.limiter.conditions.StringLimitSerializer;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;

public record DimensionLimit(ResourceKey<Level> type) implements TestSpawn
{
    public static final TestSpawn.Serializer<DimensionLimit> SERIALIZER = new DimensionSerializer();

    public DimensionLimit(ResourceKey<Level> type) {
        this.type = type;
        LimitMobSpawn.LOGGER.debug(TestSpawn.MARKER, this.getClass().getSimpleName() + " Instance created with {}", type);
    }

    public static DimensionLimit fromName(String name) {
        return new DimensionLimit((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(name)));
    }

    @Override
    public boolean test(BlockGetter worldIn, BlockPos pos, EntityType<?> entityTypeIn, MobSpawnType reason) {
        ResourceKey type;
        if (worldIn instanceof Level) {
            Level level = (Level)worldIn;
            type = level.m_46472_();
        } else {
            type = Level.f_46428_;
        }
        return this.type == type;
    }

    @Override
    public TestSpawn.Serializer<? extends TestSpawn> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public String contentShort() {
        return "dim " + this.type.m_135782_();
    }

    private static final class DimensionSerializer
    extends StringLimitSerializer<DimensionLimit, ResourceKey<Level>> {
        private DimensionSerializer() {
        }

        @Override
        public String getType() {
            return "dimension";
        }

        @Override
        public Set<String> possibleValues(String property, boolean suggesting, @Nullable SharedSuggestionProvider provider) {
            return this.suggestions(property, provider).stream().map(ResourceLocation::toString).collect(Collectors.toSet());
        }

        @Override
        public Set<ResourceLocation> suggestions(String property, @Nullable SharedSuggestionProvider provider) {
            if (provider == null || !property.equals(this.saveKey())) {
                return Collections.emptySet();
            }
            return provider.m_6553_().stream().map(ResourceKey::m_135782_).collect(Collectors.toSet());
        }

        @Override
        public ResourceKey<Level> fromString(String s) {
            return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(s));
        }

        @Override
        public String valueToString(ResourceKey<Level> worldResourceKey) {
            return worldResourceKey.m_135782_().toString();
        }

        @Override
        public String saveKey() {
            return "dim";
        }

        @Override
        public DimensionLimit instance(ResourceKey<Level> worldResourceKey) {
            return new DimensionLimit(worldResourceKey);
        }

        @Override
        public ResourceKey<Level> getter(DimensionLimit dimensionLimit) {
            return dimensionLimit.type();
        }
    }
}

