/*
 * Decompiled with CFR 0.152.
 */
package com.kotori316.limiter.mixin;

import com.kotori316.limiter.capability.Caps;
import com.kotori316.limiter.capability.LMSHandler;
import com.kotori316.limiter.capability.SpawnerControl;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BaseSpawner;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={BaseSpawner.class})
public abstract class SpawnerMixin {
    private int lmsDefaultSpawnCount;
    private int lmsDefaultMaxNearbyEntities;
    private int lmsCacheSpawnCount;
    private int lmsCacheMaxNearbyEntities;
    @Shadow
    private int f_45449_;
    @Shadow
    private int f_45451_;

    @Inject(method={"serverTick"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/BaseSpawner;spawnCount:I")}, allow=1, locals=LocalCapture.CAPTURE_FAILHARD)
    public void spawnCountHead(ServerLevel serverLevel, BlockPos pos, CallbackInfo ci) {
        if (!serverLevel.m_5776_() && this.f_45449_ == 4) {
            this.lmsDefaultSpawnCount = this.f_45449_;
            if (this.lmsCacheSpawnCount == 0) {
                serverLevel.getCapability(Caps.getLmsCapability()).resolve().map(LMSHandler::getSpawnerControl).flatMap(SpawnerControl::getSpawnCount).ifPresent(newCount -> {
                    this.f_45449_ = newCount;
                });
                this.lmsCacheSpawnCount = this.f_45449_;
            } else {
                this.f_45449_ = this.lmsCacheSpawnCount;
            }
        }
    }

    @Inject(method={"serverTick"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/BaseSpawner;spawnCount:I", shift=At.Shift.AFTER)})
    public void spawnCountTail(CallbackInfo ci) {
        if (this.lmsDefaultSpawnCount == 4) {
            this.f_45449_ = this.lmsDefaultSpawnCount;
            this.lmsDefaultSpawnCount = 0;
        }
    }

    @Inject(method={"serverTick"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/BaseSpawner;maxNearbyEntities:I")}, allow=1, locals=LocalCapture.CAPTURE_FAILHARD)
    public void maxNearbyEntitiesHead(ServerLevel serverLevel, BlockPos pos, CallbackInfo ci) {
        if (!serverLevel.m_5776_() && this.f_45451_ == 6) {
            this.lmsDefaultMaxNearbyEntities = this.f_45451_;
            if (this.lmsCacheMaxNearbyEntities == 0) {
                serverLevel.getCapability(Caps.getLmsCapability()).resolve().map(LMSHandler::getSpawnerControl).flatMap(SpawnerControl::getSpawnCount).ifPresent(newCount -> {
                    this.f_45451_ = Math.max(newCount, this.lmsDefaultMaxNearbyEntities);
                });
                this.lmsCacheMaxNearbyEntities = this.f_45451_;
            } else {
                this.f_45451_ = this.lmsCacheMaxNearbyEntities;
            }
        }
    }

    @Inject(method={"serverTick"}, at={@At(value="FIELD", target="Lnet/minecraft/world/level/BaseSpawner;maxNearbyEntities:I", shift=At.Shift.AFTER)})
    public void maxNearbyEntitiesTail(CallbackInfo ci) {
        if (this.lmsDefaultMaxNearbyEntities == 6) {
            this.f_45451_ = this.lmsDefaultMaxNearbyEntities;
            this.lmsDefaultMaxNearbyEntities = 0;
        }
    }

    @Inject(method={"serverTick"}, at={@At(value="RETURN")}, slice={@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/level/BaseSpawner;spawnCount:I"))})
    public void tickTail(CallbackInfo ci) {
        this.lmsCacheSpawnCount = 0;
        this.lmsCacheMaxNearbyEntities = 0;
    }
}

