/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import mekanism.client.render.MekanismRenderType;
import mekanism.common.entity.EntityFlame;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class RenderFlame
extends EntityRenderer<EntityFlame> {
    public RenderFlame(EntityRendererProvider.Context context) {
        super(context);
    }

    public boolean shouldRender(EntityFlame flame, @NotNull Frustum camera, double camX, double camY, double camZ) {
        return flame.f_19797_ > 0 && super.m_5523_((Entity)flame, camera, camX, camY, camZ);
    }

    public void render(@NotNull EntityFlame flame, float entityYaw, float partialTick, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light) {
        float alpha = ((float)flame.f_19797_ + partialTick) / 80.0f;
        float actualAlpha = 1.0f - alpha;
        if (actualAlpha <= 0.0f) {
            return;
        }
        float size = (float)Math.pow(2.0f * alpha, 2.0);
        float f5 = 0.15625f;
        float scale = 0.05625f * (0.8f + size);
        int alphaColor = (int)(actualAlpha * 255.0f);
        matrix.m_85836_();
        matrix.m_85845_(Vector3f.f_122225_.m_122240_(flame.f_19859_ + (flame.m_146908_() - flame.f_19859_) * partialTick - 90.0f));
        matrix.m_85845_(Vector3f.f_122227_.m_122240_(flame.f_19860_ + (flame.m_146909_() - flame.f_19860_) * partialTick));
        matrix.m_85845_(Vector3f.f_122223_.m_122240_(45.0f));
        matrix.m_85841_(scale, scale, scale);
        matrix.m_85837_(-4.0, 0.0, 0.0);
        VertexConsumer builder = renderer.m_6299_(MekanismRenderType.FLAME.apply(this.getTextureLocation(flame)));
        for (int j = 0; j < 4; ++j) {
            matrix.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
            builder.m_85977_(matrix.m_85850_().m_85864_(), 0.0f, 0.0f, scale);
            Matrix4f matrix4f = matrix.m_85850_().m_85861_();
            builder.m_85982_(matrix4f, -8.0f, -2.0f, 0.0f).m_6122_(255, 255, 255, alphaColor).m_7421_(0.0f, 0.0f).m_5752_();
            builder.m_85982_(matrix4f, 8.0f, -2.0f, 0.0f).m_6122_(255, 255, 255, alphaColor).m_7421_(0.5f, 0.0f).m_5752_();
            builder.m_85982_(matrix4f, 8.0f, 2.0f, 0.0f).m_6122_(255, 255, 255, alphaColor).m_7421_(0.5f, f5).m_5752_();
            builder.m_85982_(matrix4f, -8.0f, 2.0f, 0.0f).m_6122_(255, 255, 255, alphaColor).m_7421_(0.0f, f5).m_5752_();
        }
        matrix.m_85849_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull EntityFlame entity) {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "flame.png");
    }
}

