/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.basic;

import mekanism.api.MekanismAPI;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.registries.MekanismBlockTypes;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogisticalSorter
extends BlockTile.BlockTileModel<TileEntityLogisticalSorter, Machine<TileEntityLogisticalSorter>> {
    public BlockLogisticalSorter() {
        super(MekanismBlockTypes.LOGISTICAL_SORTER);
    }

    @Override
    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        BlockPos pos;
        BlockState state = super.m_5573_(context);
        Direction facing = Attribute.getFacing(state);
        if (facing == null) {
            return state;
        }
        Direction oppositeDirection = facing.m_122424_();
        Level level = context.m_43725_();
        BlockEntity back = WorldUtils.getTileEntity((BlockGetter)level, (pos = context.m_8083_()).m_121945_(oppositeDirection));
        if (!InventoryUtils.isItemHandler(back, oppositeDirection)) {
            for (Direction dir : EnumUtils.DIRECTIONS) {
                BlockEntity neighbor;
                if (dir == oppositeDirection || !InventoryUtils.isItemHandler(neighbor = WorldUtils.getTileEntity((BlockGetter)level, pos.m_121945_(dir)), dir)) continue;
                state = Attribute.setFacing(state, dir.m_122424_());
                break;
            }
        }
        return state;
    }

    @Override
    @Deprecated
    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        TileEntityLogisticalSorter tile = WorldUtils.getTileEntity(TileEntityLogisticalSorter.class, (BlockGetter)world, pos);
        if (tile == null) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return this.genericClientActivated(player, hand);
        }
        ItemStack stack = player.m_21120_(hand);
        if (MekanismUtils.canUseAsWrench(stack)) {
            if (!MekanismAPI.getSecurityUtils().canAccessOrDisplayError(player, (ICapabilityProvider)tile)) {
                return InteractionResult.FAIL;
            }
            if (player.m_6144_()) {
                WorldUtils.dismantleBlock(state, world, pos);
                return InteractionResult.SUCCESS;
            }
            Direction change = tile.getDirection().m_122427_();
            if (!tile.hasConnectedInventory()) {
                for (Direction dir : EnumUtils.DIRECTIONS) {
                    BlockEntity tileEntity = WorldUtils.getTileEntity((BlockGetter)world, pos.m_121945_(dir));
                    if (!InventoryUtils.isItemHandler(tileEntity, dir)) continue;
                    change = dir.m_122424_();
                    break;
                }
            }
            tile.setFacing(change);
            world.m_46672_(pos, (Block)this);
            return InteractionResult.SUCCESS;
        }
        return tile.openGui(player);
    }

    @Override
    @Deprecated
    @NotNull
    public BlockState m_7417_(BlockState state, @NotNull Direction dir, @NotNull BlockState facingState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockEntity tileEntity;
        TileEntityLogisticalSorter sorter;
        if (!world.m_5776_() && (sorter = WorldUtils.getTileEntity(TileEntityLogisticalSorter.class, (BlockGetter)world, pos)) != null && !sorter.hasConnectedInventory() && InventoryUtils.isItemHandler(tileEntity = WorldUtils.getTileEntity((BlockGetter)world, neighborPos), dir)) {
            sorter.setFacing(dir.m_122424_());
            state = sorter.m_58900_();
        }
        return super.m_7417_(state, dir, facingState, world, pos, neighborPos);
    }
}

