/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import java.util.List;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.DynamicBufferedNetwork;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import org.jetbrains.annotations.NotNull;

public abstract class BufferedTransmitter<ACCEPTOR, NETWORK extends DynamicBufferedNetwork<ACCEPTOR, NETWORK, BUFFER, TRANSMITTER>, BUFFER, TRANSMITTER extends BufferedTransmitter<ACCEPTOR, NETWORK, BUFFER, TRANSMITTER>>
extends Transmitter<ACCEPTOR, NETWORK, TRANSMITTER> {
    public BufferedTransmitter(TileEntityTransmitter tile, TransmissionType ... transmissionTypes) {
        super(tile, transmissionTypes);
    }

    protected abstract void pullFromAcceptors();

    public abstract long getCapacity();

    @NotNull
    public abstract BUFFER getBufferWithFallback();

    public abstract boolean noBufferOrFallback();

    protected boolean canHaveIncompatibleNetworks() {
        return false;
    }

    @Override
    public boolean isValidTransmitter(TileEntityTransmitter transmitter, Direction side) {
        BufferedTransmitter other;
        Transmitter<?, ?, ?> transmitter2;
        if (this.canHaveIncompatibleNetworks() && (transmitter2 = transmitter.getTransmitter()) instanceof BufferedTransmitter && (other = (BufferedTransmitter)transmitter2).canHaveIncompatibleNetworks() && (this.hasTransmitterNetwork() && other.isOrphan() || other.hasTransmitterNetwork() && this.isOrphan())) {
            return false;
        }
        return super.isValidTransmitter(transmitter, side);
    }

    @Override
    public void requestsUpdate() {
        if (this.canHaveIncompatibleNetworks()) {
            byte possibleTransmitters = this.getPossibleTransmitterConnections();
            byte possibleAcceptors = this.getPossibleAcceptorConnections();
            byte allPossibleConnections = (byte)(possibleTransmitters | possibleAcceptors);
            byte allCurrentConnections = this.getAllCurrentConnections();
            this.currentTransmitterConnections = possibleTransmitters;
            this.getAcceptorCache().currentAcceptorConnections = possibleAcceptors;
            if (allPossibleConnections != allCurrentConnections) {
                byte changedTransmitters = (byte)(allPossibleConnections ^ allCurrentConnections);
                for (Direction side : EnumUtils.DIRECTIONS) {
                    TileEntityTransmitter tile;
                    if (!BufferedTransmitter.connectionMapContainsSide(changedTransmitters, side) || (tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (BlockGetter)this.getTileWorld(), this.getTilePos().m_121945_(side))) == null) continue;
                    tile.getTransmitter().refreshConnections(side.m_122424_());
                }
            }
        }
        super.requestsUpdate();
    }

    @Override
    protected void recheckConnections(byte newlyEnabledTransmitters) {
        if (this.hasTransmitterNetwork()) {
            if (this.canHaveIncompatibleNetworks()) {
                for (Direction side : EnumUtils.DIRECTIONS) {
                    if (!BufferedTransmitter.connectionMapContainsSide(newlyEnabledTransmitters, side)) continue;
                    this.recheckConnectionPrechecked(side);
                }
            }
        } else {
            super.recheckConnections(newlyEnabledTransmitters);
        }
    }

    @Override
    protected void recheckConnection(Direction side) {
        if (this.canHaveIncompatibleNetworks() && this.hasTransmitterNetwork()) {
            this.recheckConnectionPrechecked(side);
        }
    }

    private void recheckConnectionPrechecked(Direction side) {
        TileEntityTransmitter otherTile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (BlockGetter)this.getTileWorld(), this.getTilePos().m_121945_(side));
        if (otherTile != null) {
            DynamicBufferedNetwork otherNetwork;
            DynamicBufferedNetwork network = (DynamicBufferedNetwork)this.getTransmitterNetwork();
            Transmitter<?, ?, ?> other = otherTile.getTransmitter();
            if (other instanceof BufferedTransmitter && ((BufferedTransmitter)other).canHaveIncompatibleNetworks() && other.hasTransmitterNetwork() && network != (otherNetwork = (DynamicBufferedNetwork)other.getTransmitterNetwork()) && network.isCompatibleWith(otherNetwork)) {
                if (this.noBufferOrFallback()) {
                    DynamicBufferedNetwork tempNetwork = network;
                    network = otherNetwork;
                    otherNetwork = tempNetwork;
                }
                List otherTransmitters = network.adoptTransmittersAndAcceptorsFrom(otherNetwork);
                otherNetwork.deregister();
                network.commit();
                network.clampBuffer();
                other.refreshConnections(side.m_122424_());
                for (BufferedTransmitter otherTransmitter : otherTransmitters) {
                    otherTransmitter.requestsUpdate();
                }
            }
        }
    }

    @Override
    protected void handleContentsUpdateTag(@NotNull NETWORK network, @NotNull CompoundTag tag) {
        ((DynamicBufferedNetwork)network).updateCapacity();
    }

    @Override
    protected void updateClientNetwork(@NotNull NETWORK network) {
        super.updateClientNetwork(network);
        ((DynamicBufferedNetwork)network).updateCapacity();
    }

    public abstract BUFFER releaseShare();

    @NotNull
    public abstract BUFFER getShare();
}

