/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.rune;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.register.ModBlocks;
import mythicbotany.register.ModItems;
import mythicbotany.register.ModRecipes;
import mythicbotany.rune.RuneRitualRecipe;
import mythicbotany.rune.TileRuneHolder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.base.tile.TickingBlock;
import org.moddingx.libx.util.data.NbtX;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.item.BotaniaItems;

public class TileCentralRuneHolder
extends TileRuneHolder
implements TickingBlock {
    private static final ResourceLocation MISSIGNO = new ResourceLocation("minecraft", "missingno");
    private static final Map<Item, Integer> RUNE_COLORS = ImmutableMap.builder().put((Object)BotaniaItems.runeAir, (Object)6861034).put((Object)BotaniaItems.runeSpring, (Object)0xFF919F).put((Object)BotaniaItems.runeSummer, (Object)56813).put((Object)BotaniaItems.runeAutumn, (Object)15057408).put((Object)BotaniaItems.runeWinter, (Object)14736341).put((Object)BotaniaItems.runeLust, (Object)15943377).put((Object)BotaniaItems.runeGluttony, (Object)0x6E6E6E).put((Object)BotaniaItems.runeGreed, (Object)37937).put((Object)BotaniaItems.runeSloth, (Object)12293729).put((Object)BotaniaItems.runeWrath, (Object)0xFF2424).put((Object)BotaniaItems.runeEnvy, (Object)13129958).put((Object)BotaniaItems.runePride, (Object)2896439).put((Object)ModItems.asgardRune, (Object)14796032).put((Object)ModItems.vanaheimRune, (Object)6276936).put((Object)ModItems.alfheimRune, (Object)0xFF76F7).put((Object)ModItems.midgardRune, (Object)1683771).put((Object)ModItems.joetunheimRune, (Object)11626265).put((Object)ModItems.muspelheimRune, (Object)0xBF0000).put((Object)ModItems.niflheimRune, (Object)45503).put((Object)ModItems.nidavellirRune, (Object)0x6F6F6F).put((Object)ModItems.helheimRune, (Object)0x780000).build();
    @Nullable
    private RuneRitualRecipe recipe;
    @Nullable
    private ResourceLocation recipeId;
    private int progress;
    private int transformId;
    private List<ItemStack> consumedStacks = new ArrayList<ItemStack>();
    private CompoundTag specialNbt = new CompoundTag();

    public TileCentralRuneHolder(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!(this.recipeId == null || this.recipe != null && this.recipeId.equals((Object)this.recipe.m_6423_()))) {
            Recipe foundRecipe = this.f_58857_.m_7465_().m_44043_(this.recipeId).orElse(null);
            if (foundRecipe instanceof RuneRitualRecipe) {
                this.recipe = (RuneRitualRecipe)foundRecipe;
                this.recipeId = this.recipe.m_6423_();
                this.m_6596_();
                this.setDispatchable();
            } else {
                this.recipeId = null;
            }
        }
        if (!this.f_58857_.f_46443_) {
            if (this.recipe != null) {
                if (!this.recipeValid(this.recipe, this.transformId)) {
                    this.cancelRecipe();
                } else {
                    if (this.progress == 0) {
                        this.setDispatchable();
                    }
                    ++this.progress;
                    if (this.progress >= this.recipe.getTicks()) {
                        this.getInventory().setStackInSlot(0, ItemStack.f_41583_);
                        for (ItemStack result : this.recipe.getOutputs()) {
                            ItemEntity ie = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, result.m_41777_());
                            ie.m_32010_(40);
                            ie.m_146915_(true);
                            this.f_58857_.m_7967_((Entity)ie);
                        }
                        for (RuneRitualRecipe.RunePosition rune : this.recipe.getRunes()) {
                            BlockPos runePos = this.f_58858_.m_7918_(rune.getX(this.transformId), 0, rune.getZ(this.transformId));
                            BlockState state = Objects.requireNonNull(this.f_58857_).m_8055_(runePos);
                            if (state.m_60734_() != ModBlocks.runeHolder) continue;
                            TileRuneHolder tile = (TileRuneHolder)ModBlocks.runeHolder.getBlockEntity(this.f_58857_, runePos);
                            tile.setTarget(null, 0.0, true);
                            ItemStack runeStack = tile.getInventory().getStackInSlot(0);
                            tile.getInventory().setStackInSlot(0, ItemStack.f_41583_);
                            if (rune.isConsumed() || runeStack.m_41619_()) continue;
                            ItemEntity ie = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, runeStack);
                            this.f_58857_.m_7967_((Entity)ie);
                        }
                        RuneRitualRecipe recipeCopy = this.recipe;
                        this.recipe = null;
                        this.recipeId = null;
                        this.progress = 0;
                        this.transformId = 0;
                        List<ItemStack> consumedStacksCops = this.consumedStacks;
                        this.consumedStacks = new ArrayList<ItemStack>();
                        this.specialNbt = new CompoundTag();
                        if (recipeCopy.getSpecialOutput() != null) {
                            recipeCopy.getSpecialOutput().apply(this.f_58857_, this.f_58858_, consumedStacksCops);
                        }
                        this.setDispatchable();
                    } else {
                        this.updabePatterns(this.recipe, this.transformId, (double)this.progress / (double)this.recipe.getTicks(), false);
                    }
                }
                this.m_6596_();
            } else {
                this.recipeId = null;
                this.progress = 0;
                this.transformId = 0;
                if (!this.consumedStacks.isEmpty()) {
                    this.consumedStacks = new ArrayList<ItemStack>();
                }
                this.specialNbt = new CompoundTag();
                this.m_6596_();
                this.setDispatchable();
            }
        } else if (this.recipe != null && this.progress < this.recipe.getTicks() && this.progress > 0) {
            ++this.progress;
            double progressScaled = (double)this.progress / (double)this.recipe.getTicks();
            this.updabePatterns(this.recipe, this.transformId, progressScaled, false);
            if (this.progress == this.recipe.getTicks() - 1) {
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123747_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.45, (double)this.f_58858_.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            } else if (this.progress < this.recipe.getTicks() - 2) {
                progressScaled = Math.max(0.0, (double)(this.progress - 2) / (double)this.recipe.getTicks());
                for (RuneRitualRecipe.RunePosition rune : this.recipe.getRunes()) {
                    ItemStack stack;
                    BlockEntity runeHolderBE = this.f_58857_.m_7702_(this.f_58858_.m_7918_(rune.getX(this.transformId), 0, rune.getZ(this.transformId)));
                    if (!(runeHolderBE instanceof TileRuneHolder) || (stack = ((TileRuneHolder)runeHolderBE).getInventory().getStackInSlot(0)).m_41619_()) continue;
                    double x = (double)rune.getX(this.transformId) * (1.0 - progressScaled);
                    double y = Math.sin(progressScaled * Math.PI);
                    double z = (double)rune.getZ(this.transformId) * (1.0 - progressScaled);
                    double xr = this.f_58857_.f_46441_.m_188500_() * 0.6 - 0.3;
                    double yr = this.f_58857_.f_46441_.m_188500_() * 0.6 - 0.3;
                    double zr = this.f_58857_.f_46441_.m_188500_() * 0.6 - 0.3;
                    this.f_58857_.m_7106_(this.getParticle(stack.m_41720_()), (double)this.f_58858_.m_123341_() + 0.5 + x + xr, (double)this.f_58858_.m_123342_() + 0.25 + y + yr, (double)this.f_58858_.m_123343_() + 0.5 + z + zr, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void tryStartRitual(Player player) {
        this.tryStartRitual(arg_0 -> ((Player)player).m_213846_(arg_0), mana -> ManaItemHandler.instance().requestManaExact(new ItemStack((ItemLike)Items.f_42594_), player, mana.intValue(), false), mana -> ManaItemHandler.instance().requestManaExact(new ItemStack((ItemLike)Items.f_42594_), player, mana.intValue(), true));
    }

    public void tryStartRitual(Consumer<Component> messages, Function<Integer, Boolean> manaBest, Consumer<Integer> manaRequest) {
        if (this.recipe != null) {
            messages.accept((Component)Component.m_237115_((String)"message.mythicbotany.ritual_running").m_130940_(ChatFormatting.GRAY));
        } else {
            Pair<RuneRitualRecipe, Integer> recipe = this.findRecipe();
            if (recipe == null) {
                messages.accept((Component)Component.m_237115_((String)"message.mythicbotany.ritual_wrong_shape").m_130940_(ChatFormatting.GRAY));
            } else {
                this.tryStart((RuneRitualRecipe)recipe.getLeft(), (Integer)recipe.getRight(), messages, manaBest, manaRequest);
            }
        }
    }

    @Nullable
    private Pair<RuneRitualRecipe, Integer> findRecipe() {
        if (this.f_58857_ == null) {
            return null;
        }
        return this.f_58857_.m_7465_().m_44013_(ModRecipes.runeRitual).stream().flatMap(this::recipeMatches).findFirst().orElse(null);
    }

    private Stream<Pair<RuneRitualRecipe, Integer>> recipeMatches(RuneRitualRecipe recipe) {
        if (!recipe.getCenterRune().test(this.getInventory().getStackInSlot(0))) {
            return Stream.empty();
        }
        int transformId = -1;
        for (int i = 0; i < 8; ++i) {
            if (!this.runePatternMatches(recipe, i)) continue;
            transformId = i;
            break;
        }
        if (transformId < 0) {
            return Stream.empty();
        }
        return Stream.of(Pair.of((Object)recipe, (Object)transformId));
    }

    private void tryStart(RuneRitualRecipe recipe, int transform, Consumer<Component> messages, Function<Integer, Boolean> manaBest, Consumer<Integer> manaRequest) {
        if (recipe.getMana() > 0 && !manaBest.apply(recipe.getMana()).booleanValue()) {
            messages.accept((Component)Component.m_237115_((String)"message.mythicbotany.ritual_less_mana").m_130940_(ChatFormatting.GRAY));
            return;
        }
        Vec3 center = new Vec3((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() + 0.5);
        AABB aabb = new AABB(center, center).m_82400_(2.0);
        List inputs = Objects.requireNonNull(this.f_58857_).m_142425_((EntityTypeTest)EntityType.f_20461_, aabb, e -> true);
        List<MutableTriple> stacks = inputs.stream().map(e -> MutableTriple.of((Object)e, (Object)e.m_32055_(), (Object)e.m_32055_().m_41613_())).filter(t -> !((ItemStack)t.getMiddle()).m_41619_()).toList();
        ArrayList<ItemStack> consumedStacks = new ArrayList<ItemStack>();
        block0: for (Ingredient ingr : recipe.getInputs()) {
            for (MutableTriple triple : stacks) {
                if ((Integer)triple.getRight() <= 0 || !ingr.test((ItemStack)triple.getMiddle())) continue;
                ItemStack copy = ((ItemStack)triple.getMiddle()).m_41777_();
                copy.m_41764_(1);
                consumedStacks.add(copy);
                triple.setRight((Object)((Integer)triple.getRight() - 1));
                continue block0;
            }
            messages.accept((Component)Component.m_237115_((String)"message.mythicbotany.ritual_wrong_items").m_130940_(ChatFormatting.GRAY));
            return;
        }
        if (recipe.getSpecialInput() != null) {
            Either<MutableComponent, CompoundTag> result = recipe.getSpecialInput().apply(this.f_58857_, this.f_58858_, recipe);
            Optional tc = result.left();
            if (tc.isPresent()) {
                messages.accept((Component)((MutableComponent)tc.get()).m_130940_(ChatFormatting.GRAY));
                return;
            }
            result.ifRight(nbt -> {
                this.specialNbt = nbt;
            });
        }
        manaRequest.accept(recipe.getMana());
        for (MutableTriple triple : stacks) {
            ItemStack stack = (ItemStack)triple.getMiddle();
            stack.m_41764_(((Integer)triple.getRight()).intValue());
            ((ItemEntity)triple.getLeft()).m_32045_(stack);
        }
        this.recipe = recipe;
        this.progress = 0;
        this.transformId = transform;
        this.consumedStacks = consumedStacks;
        this.m_6596_();
        this.setDispatchable();
    }

    private boolean runePatternMatches(RuneRitualRecipe recipe, int idx) {
        for (RuneRitualRecipe.RunePosition rune : recipe.getRunes()) {
            BlockPos runePos = this.f_58858_.m_7918_(rune.getX(idx), 0, rune.getZ(idx));
            BlockState state = Objects.requireNonNull(this.f_58857_).m_8055_(runePos);
            if (state.m_60734_() != ModBlocks.runeHolder) {
                return false;
            }
            TileRuneHolder tile = (TileRuneHolder)ModBlocks.runeHolder.getBlockEntity(this.f_58857_, runePos);
            if (rune.getRune().test(tile.getInventory().getStackInSlot(0))) continue;
            return false;
        }
        return true;
    }

    private void updabePatterns(RuneRitualRecipe recipe, int transformId, double progress, boolean sync) {
        if (transformId < 0 || transformId >= 8) {
            transformId = 0;
        }
        this.setTarget(this.f_58858_, 0.0, sync);
        for (RuneRitualRecipe.RunePosition rune : recipe.getRunes()) {
            BlockPos runePos = this.f_58858_.m_7918_(rune.getX(transformId), 0, rune.getZ(transformId));
            BlockState state = Objects.requireNonNull(this.f_58857_).m_8055_(runePos);
            if (state.m_60734_() != ModBlocks.runeHolder) continue;
            TileRuneHolder tile = (TileRuneHolder)ModBlocks.runeHolder.getBlockEntity(this.f_58857_, runePos);
            tile.setTarget(progress == 0.0 ? null : this.f_58858_, progress, sync);
        }
    }

    public void cancelRecipe() {
        if (this.f_58857_ != null && this.recipe != null) {
            this.updabePatterns(this.recipe, this.transformId, 0.0, true);
            for (ItemStack stack : this.consumedStacks) {
                ItemEntity ie = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, stack);
                this.f_58857_.m_7967_((Entity)ie);
            }
            if (this.recipe.getSpecialInput() != null) {
                this.recipe.getSpecialInput().cancel(this.f_58857_, this.f_58858_, this.recipe, this.specialNbt);
            }
            this.recipe = null;
            this.recipeId = null;
            this.progress = 0;
            this.transformId = 0;
            this.consumedStacks = new ArrayList<ItemStack>();
            this.specialNbt = new CompoundTag();
            this.m_6596_();
            this.setDispatchable();
        }
    }

    private boolean recipeValid(RuneRitualRecipe recipe, int transformId) {
        if (!recipe.getCenterRune().test(this.getInventory().getStackInSlot(0))) {
            return false;
        }
        if (transformId < 0 || transformId >= 8) {
            transformId = 0;
        }
        for (RuneRitualRecipe.RunePosition rune : recipe.getRunes()) {
            BlockPos runePos = this.f_58858_.m_7918_(rune.getX(transformId), 0, rune.getZ(transformId));
            BlockState state = Objects.requireNonNull(this.f_58857_).m_8055_(runePos);
            if (state.m_60734_() != ModBlocks.runeHolder) {
                return false;
            }
            TileRuneHolder tile = (TileRuneHolder)ModBlocks.runeHolder.getBlockEntity(this.f_58857_, runePos);
            if (rune.getRune().test(tile.getInventory().getStackInSlot(0))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        ResourceLocation id = NbtX.getResource((CompoundTag)nbt, (String)"recipe", (ResourceLocation)MISSIGNO);
        this.recipeId = id == MISSIGNO ? null : id;
        this.progress = nbt.m_128451_("progress");
        this.transformId = nbt.m_128451_("transform");
        if (nbt.m_128425_("Consumed", 9)) {
            ListTag consumed = nbt.m_128437_("Consumed", 10);
            this.consumedStacks = new ArrayList<ItemStack>();
            for (int i = 0; i < consumed.size(); ++i) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)consumed.m_128728_(i));
                if (stack.m_41619_()) continue;
                this.consumedStacks.add(stack);
            }
        } else {
            this.consumedStacks = new ArrayList<ItemStack>();
        }
        this.specialNbt = nbt.m_128469_("SpecialInputData").m_6426_();
    }

    @Override
    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        NbtX.putRL((CompoundTag)nbt, (String)"recipe", (ResourceLocation)(this.recipe == null ? MISSIGNO : this.recipe.m_6423_()));
        nbt.m_128405_("progress", this.progress);
        nbt.m_128405_("transform", this.transformId);
        ListTag consumed = new ListTag();
        for (ItemStack stack : this.consumedStacks) {
            consumed.add((Object)stack.serializeNBT());
        }
        nbt.m_128365_("Consumed", (Tag)consumed);
        nbt.m_128365_("SpecialInputData", (Tag)this.specialNbt.m_6426_());
    }

    @Override
    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        if (!this.f_58857_.f_46443_) {
            NbtX.putRL((CompoundTag)nbt, (String)"recipe", (ResourceLocation)(this.recipe == null ? MISSIGNO : this.recipe.m_6423_()));
            nbt.m_128405_("progress", this.progress);
            nbt.m_128405_("transform", this.transformId);
        }
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        if (this.f_58857_.f_46443_) {
            ResourceLocation id = NbtX.getResource((CompoundTag)nbt, (String)"recipe", (ResourceLocation)MISSIGNO);
            this.recipeId = id == MISSIGNO ? null : id;
            this.progress = nbt.m_128451_("progress");
            this.transformId = nbt.m_128451_("transform");
        }
    }

    private ParticleOptions getParticle(Item rune) {
        if (rune == ModItems.fimbultyrTablet) {
            return new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_41912_));
        }
        if (rune == BotaniaItems.runeMana) {
            return WispParticleData.wisp((float)0.2f, (float)0.0f, (float)0.0f, (float)1.0f, (float)0.3f);
        }
        if (rune == BotaniaItems.runeFire) {
            return ParticleTypes.f_123744_;
        }
        if (rune == BotaniaItems.runeAir) {
            return ParticleTypes.f_123796_;
        }
        if (rune == BotaniaItems.runeEarth) {
            return new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42329_));
        }
        if (rune == BotaniaItems.runeWater) {
            return ParticleTypes.f_123776_;
        }
        int color = RUNE_COLORS.getOrDefault(rune, 0xFFFFFF);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return SparkleParticleData.sparkle((float)2.0f, (float)r, (float)g, (float)b, (int)6);
    }
}

