/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.block;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MaterialColor;
import org.jetbrains.annotations.Nullable;
import potionstudios.byg.BYG;
import potionstudios.byg.common.block.BYGBlockProperties;
import potionstudios.byg.common.block.BYGBlockTags;
import potionstudios.byg.common.block.BYGBlocks;
import potionstudios.byg.common.block.BaobabFruitBlock;
import potionstudios.byg.common.entity.boat.BYGBoat;
import potionstudios.byg.common.item.BYGBoatItem;
import potionstudios.byg.common.item.BYGCreativeTab;
import potionstudios.byg.common.item.BYGItems;
import potionstudios.byg.mixin.access.WoodTypeAccess;
import potionstudios.byg.reg.BlockRegistryObject;
import potionstudios.byg.reg.RegistryObject;
import potionstudios.byg.util.MultiTag;

public enum BYGWoodTypes {
    ASPEN("aspen", new Builder().boatType(BYGBoat.BYGType.ASPEN).materialColor(MaterialColor.f_76376_).growerItemGroundTag(BYGBlockTags.GROUND_ASPEN_SAPLING)),
    BAOBAB("baobab", new Builder().boatType(BYGBoat.BYGType.BAOBAB).growerItemGroundTag(BYGBlockTags.GROUND_BAOBAB_SAPLING).materialColor(MaterialColor.f_76385_).leavesFactory(id -> BYGBlocks.createFruitLeaves(MaterialColor.f_76363_, () -> (BlockState)BYGBlocks.BAOBAB_FRUIT_BLOCK.defaultBlockState().m_61124_((Property)BaobabFruitBlock.AGE, (Comparable)Integer.valueOf(0)), id, 0.01f))),
    BLUE_ENCHANTED("blue_enchanted", new Builder().boatType(BYGBoat.BYGType.BLUE_ENCHANTED).growerItemGroundTag(BYGBlockTags.GROUND_BLUE_ENCHANTED_SAPLING).materialColor(MaterialColor.f_76361_).leavesFactory(id -> BYGBlocks.createGlowingLeaves(MaterialColor.f_76363_, 15, id))),
    BULBIS("bulbis", new Builder().materialColor(MaterialColor.f_76361_).growerItemGroundTag(BYGBlockTags.GROUND_BULBIS_ODDITY).growerItem(GrowerItemType.ODDITY).exclude(BlockType.LEAVES).registryName(BlockType.WOOD, "%s_wood").registryName(BlockType.STRIPPED_WOOD, "stripped_%s_wood").nether()),
    CHERRY("cherry", new Builder().exclude(BlockType.SAPLING, BlockType.LEAVES).boatType(BYGBoat.BYGType.CHERRY)),
    CIKA("cika", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_CIKA_SAPLING).boatType(BYGBoat.BYGType.CIKA).materialColor(MaterialColor.f_76373_)),
    CYPRESS("cypress", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_CYPRESS_SAPLING).boatType(BYGBoat.BYGType.CYPRESS).materialColor(MaterialColor.f_76377_)),
    EBONY("ebony", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_EBONY_SAPLING).boatType(BYGBoat.BYGType.EBONY).materialColor(MaterialColor.f_76363_)),
    ETHER("ether", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_ETHER_SAPLING).materialColor(MaterialColor.f_76421_)),
    FIR("fir", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_FIR_SAPLING).materialColor(MaterialColor.f_76363_).boatType(BYGBoat.BYGType.FIR)),
    GREEN_ENCHANTED("green_enchanted", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_GREEN_ENCHANTED_SAPLING).boatType(BYGBoat.BYGType.GREEN_ENCHANTED).materialColor(MaterialColor.f_76363_).leavesFactory(id -> BYGBlocks.createGlowingLeaves(MaterialColor.f_76363_, 15, id))),
    HOLLY("holly", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_HOLLY_SAPLING).materialColor(MaterialColor.f_76385_).boatType(BYGBoat.BYGType.HOLLY)),
    IMPARIUS("imparius", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_IMPARIUS_MUSHROOM).exclude(BlockType.LEAVES, BlockType.STRIPPED_LOG, BlockType.STRIPPED_WOOD).growerItem(GrowerItemType.MUSHROOM).nether()),
    MAHOGANY("mahogany", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_WHITE_MANGROVE_SAPLING).boatType(BYGBoat.BYGType.MAHOGANY).materialColor(MaterialColor.f_76363_).leavesHaveOverlay()),
    WHITE_MANGROVE("white_mangrove", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_WHITE_MANGROVE_SAPLING).boatType(BYGBoat.BYGType.MANGROVE).materialColor(MaterialColor.f_76363_)),
    PALM("palm", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_PALM_SAPLING).boatType(BYGBoat.BYGType.PALM).materialColor(MaterialColor.f_76363_)),
    PINE("pine", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_PINE_SAPLING).boatType(BYGBoat.BYGType.PINE).materialColor(MaterialColor.f_76385_)),
    RAINBOW_EUCALYPTUS("rainbow_eucalyptus", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_RAINBOW_EUCALYPTUS_SAPLING).boatType(BYGBoat.BYGType.RAINBOW_EUCALYPTUS).materialColor(MaterialColor.f_76363_)),
    REDWOOD("redwood", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_REDWOOD_SAPLING).boatType(BYGBoat.BYGType.REDWOOD).materialColor(MaterialColor.f_76363_)),
    WILLOW("willow", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_WILLOW_SAPLING).boatType(BYGBoat.BYGType.WILLOW).materialColor(MaterialColor.f_76385_).leavesHaveOverlay()),
    WITCH_HAZEL("witch_hazel", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_WITCH_HAZEL_SAPLING).boatType(BYGBoat.BYGType.WITCH_HAZEL).materialColor(MaterialColor.f_76413_)),
    ZELKOVA("zelkova", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_ZELKOVA_SAPLING).boatType(BYGBoat.BYGType.ZELKOVA).materialColor(MaterialColor.f_76386_)),
    SYTHIAN("sythian", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_SYTHIAN_FUNGUS).growerItem(GrowerItemType.FUNGUS).nether()),
    EMBUR("embur", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_EMBUR_WART).growerItem(GrowerItemType.WART).exclude(BlockType.LEAVES).registryName(BlockType.LOG, "%s_pedu").registryName(BlockType.STRIPPED_LOG, "stripped_%s_pedu").nether()),
    NIGHTSHADE("nightshade", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_NIGHTSHADE_SAPLING).materialColor(MaterialColor.f_76413_)),
    SKYRIS("skyris", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_SKYRIS_SAPLING).materialColor(MaterialColor.f_76418_).boatType(BYGBoat.BYGType.SKYRIS)),
    LAMENT("lament", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_LAMENT_SAPLING).materialColor(MaterialColor.f_76414_).notFlammable()),
    MAPLE("maple", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_MAPLE_SAPLING).materialColor(MaterialColor.f_76363_).boatType(BYGBoat.BYGType.MAPLE)),
    JACARANDA("jacaranda", new Builder().growerItemGroundTag(BYGBlockTags.GROUND_JACARANDA_SAPLING).boatType(BYGBoat.BYGType.JACARANDA).materialColor(MaterialColor.f_76382_));

    public static final Map<String, BYGWoodTypes> LOOKUP;
    private final String name;
    private final WoodType woodType;
    private final Builder builder;
    private boolean initialized;
    private final MultiTag logTag;
    private BlockRegistryObject<Block> growerItem;
    @Nullable
    private BlockRegistryObject<Block> leaves;
    private BlockRegistryObject<Block> log;
    private BlockRegistryObject<Block> wood;
    private BlockRegistryObject<Block> strippedLog;
    private BlockRegistryObject<Block> strippedWood;
    private BlockRegistryObject<Block> planks;
    private BlockRegistryObject<Block> bookshelf;
    private BlockRegistryObject<Block> craftingTable;
    private BlockRegistryObject<Block> stairs;
    private BlockRegistryObject<Block> slab;
    private BlockRegistryObject<Block> fence;
    private BlockRegistryObject<Block> fenceGate;
    private BlockRegistryObject<Block> door;
    private BlockRegistryObject<Block> trapdoor;
    private BlockRegistryObject<Block> pressurePlate;
    private BlockRegistryObject<Block> button;
    private BlockRegistryObject<Block> sign;
    private BlockRegistryObject<Block> wallSign;
    private RegistryObject<SignItem> signItem;
    private RegistryObject<BYGBoatItem> boat;
    private RegistryObject<BYGBoatItem> chestBoat;

    private BYGWoodTypes(String name, Builder builder) {
        this.name = name;
        this.builder = builder;
        this.woodType = WoodTypeAccess.byg_invokeRegister(WoodTypeAccess.byg_create(BYG.createLocation(name).toString().replace(':', '/')));
        this.logTag = MultiTag.create(BYG.createLocation(name + "_logs"));
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        if (!this.builder.excludes.contains((Object)BlockType.SAPLING)) {
            this.growerItem = switch (this.builder.growerItemType) {
                default -> throw new IncompatibleClassChangeError();
                case GrowerItemType.SAPLING -> BYGBlocks.createSapling(this.builder.growerItemGroundTag, this.name + "_sapling");
                case GrowerItemType.ODDITY -> BYGBlocks.createMushroom(this.builder.growerItemGroundTag, this.name + "_oddity");
                case GrowerItemType.FUNGUS -> BYGBlocks.createFungus(this.builder.growerItemGroundTag, this.name + "_fungus");
                case GrowerItemType.MUSHROOM -> BYGBlocks.createMushroom(this.builder.growerItemGroundTag, this.name + "_mushroom");
                case GrowerItemType.WART -> BYGBlocks.createFungus(this.builder.growerItemGroundTag, this.name + "_wart");
            };
            BYGItems.createGrowerItem(this.growerItem, this.builder.growerItemType == GrowerItemType.SAPLING);
        }
        if (!this.builder.excludes.contains((Object)BlockType.LEAVES)) {
            this.leaves = this.builder.isNether ? BYGBlocks.createBlock(BYGBlockProperties.BYGWartBlock::new, this.nameOr("%s_wart_block", BlockType.LEAVES)) : this.builder.leavesFactory.apply(this.name + "_leaves");
            BYGItems.createItem(this.leaves);
        }
        this.log = this.ifAllowed(BlockType.LOG, () -> this.builder.isNether ? BYGBlocks.createBlock(BYGBlockProperties.BYGNetherLog::new, this.nameOr("%s_stem", BlockType.LOG)) : BYGBlocks.createLog(this.nameOr("%s_log", BlockType.LOG)));
        BYGItems.createItem(this.log);
        this.wood = this.ifAllowed(BlockType.WOOD, () -> this.builder.isNether ? BYGBlocks.createBlock(BYGBlockProperties.BYGNetherLog::new, this.nameOr("%s_hyphae", BlockType.WOOD)) : BYGBlocks.createWood(this.nameOr("%s_wood", BlockType.WOOD)));
        BYGItems.createItem(this.wood);
        this.strippedLog = this.ifAllowed(BlockType.STRIPPED_LOG, () -> this.builder.isNether ? BYGBlocks.createBlock(BYGBlockProperties.BYGNetherLog::new, this.nameOr("stripped_%s_stem", BlockType.STRIPPED_LOG)) : BYGBlocks.createStrippedLog(this.nameOr("stripped_%s_log", BlockType.STRIPPED_LOG)));
        BYGItems.createItem(this.strippedLog);
        this.strippedWood = this.ifAllowed(BlockType.STRIPPED_WOOD, () -> this.builder.isNether ? BYGBlocks.createBlock(BYGBlockProperties.BYGNetherLog::new, this.nameOr("stripped_%s_hyphae", BlockType.STRIPPED_WOOD)) : BYGBlocks.createWood(this.nameOr("stripped_%s_wood", BlockType.STRIPPED_WOOD)));
        BYGItems.createItem(this.strippedWood);
        this.planks = BYGBlocks.createPlanks(this.name + "_planks");
        BYGItems.createItem(this.planks);
        this.bookshelf = BYGBlocks.createBookshelf(this.name + "_bookshelf");
        BYGItems.createItem(this.bookshelf);
        this.craftingTable = BYGBlocks.createCraftingTable(this.name + "_crafting_table");
        BYGItems.createItem(this.craftingTable);
        this.stairs = BYGBlocks.createWoodStairs(this.name + "_stairs");
        BYGItems.createItem(this.stairs);
        this.slab = BYGBlocks.createWoodSlab(this.name + "_slab");
        BYGItems.createItem(this.slab);
        this.fence = BYGBlocks.createFence(this.name + "_fence");
        BYGItems.createItem(this.fence);
        this.fenceGate = BYGBlocks.createFenceGate(this.name + "_fence_gate");
        BYGItems.createItem(this.fenceGate);
        this.door = BYGBlocks.createDoor(this.name + "_door");
        BYGItems.createItem(this.door);
        this.trapdoor = BYGBlocks.createTrapDoor(this.name + "_trapdoor");
        BYGItems.createItem(this.trapdoor);
        this.pressurePlate = BYGBlocks.createWoodPressurePlate(this.name + "_pressure_plate");
        BYGItems.createItem(this.pressurePlate);
        this.button = BYGBlocks.createWoodButton(this.name + "_button");
        BYGItems.createItem(this.button);
        this.sign = BYGBlocks.createSign(this.name + "_sign", this.woodType, this.planks);
        this.wallSign = BYGBlocks.createWallSign(this.name + "_wall_sign", this.woodType, this.planks, this.sign);
        this.signItem = BYGItems.createSign(this.name + "_sign", this.sign, this.wallSign);
        if (this.builder.boatType != null) {
            this.boat = BYGItems.createItem(() -> new BYGBoatItem(false, this.builder.boatType, new Item.Properties().m_41491_(BYGCreativeTab.CREATIVE_TAB).m_41487_(1)), this.name + "_boat");
            this.chestBoat = BYGItems.createItem(() -> new BYGBoatItem(true, this.builder.boatType, new Item.Properties().m_41491_(BYGCreativeTab.CREATIVE_TAB).m_41487_(1)), this.name + "_chest_boat");
        }
        this.initialized = true;
    }

    private String nameOr(String defaultName, BlockType blockType) {
        return this.builder.registryName.computeIfAbsent(blockType, k -> defaultName).formatted(this.name);
    }

    private <T> T ifAllowed(BlockType type, Supplier<? extends T> sup) {
        return this.builder.excludes.contains((Object)type) ? null : (T)sup.get();
    }

    public String toString() {
        return this.name;
    }

    public BlockRegistryObject<Block> planks() {
        return this.planks;
    }

    public BlockRegistryObject<Block> growerItem() {
        return this.growerItem;
    }

    public WoodType woodType() {
        return this.woodType;
    }

    @Nullable
    public BlockRegistryObject<Block> leaves() {
        return this.leaves;
    }

    public BlockRegistryObject<Block> log() {
        return this.log;
    }

    public BlockRegistryObject<Block> wood() {
        return this.wood;
    }

    public BlockRegistryObject<Block> strippedLog() {
        return this.strippedLog;
    }

    public BlockRegistryObject<Block> strippedWood() {
        return this.strippedWood;
    }

    public BlockRegistryObject<Block> bookshelf() {
        return this.bookshelf;
    }

    public BlockRegistryObject<Block> craftingTable() {
        return this.craftingTable;
    }

    public BlockRegistryObject<Block> stairs() {
        return this.stairs;
    }

    public BlockRegistryObject<Block> slab() {
        return this.slab;
    }

    public BlockRegistryObject<Block> fence() {
        return this.fence;
    }

    public BlockRegistryObject<Block> fenceGate() {
        return this.fenceGate;
    }

    public BlockRegistryObject<Block> door() {
        return this.door;
    }

    public BlockRegistryObject<Block> trapdoor() {
        return this.trapdoor;
    }

    public BlockRegistryObject<Block> pressurePlate() {
        return this.pressurePlate;
    }

    public BlockRegistryObject<Block> button() {
        return this.button;
    }

    public BlockRegistryObject<Block> sign() {
        return this.sign;
    }

    public BlockRegistryObject<Block> wallSign() {
        return this.wallSign;
    }

    public RegistryObject<SignItem> signItem() {
        return this.signItem;
    }

    public RegistryObject<BYGBoatItem> boat() {
        return this.boat;
    }

    public MultiTag logTag() {
        return this.logTag;
    }

    public BYGBoat.BYGType boatType() {
        return this.builder.boatType;
    }

    public boolean isNether() {
        return this.builder.isNether;
    }

    public boolean isFlammable() {
        return this.builder.flammable;
    }

    public boolean leavesHaveOverlay() {
        return this.builder.leavesHaveOverlay;
    }

    public RegistryObject<BYGBoatItem> chestBoat() {
        return this.chestBoat;
    }

    static {
        LOOKUP = Arrays.stream(BYGWoodTypes.values()).collect(Collectors.toUnmodifiableMap(BYGWoodTypes::toString, Function.identity()));
    }

    public static final class Builder {
        private final Map<BlockType, String> registryName = new HashMap<BlockType, String>();
        private GrowerItemType growerItemType = GrowerItemType.SAPLING;
        private final EnumSet<BlockType> excludes = EnumSet.noneOf(BlockType.class);
        private TagKey<Block> growerItemGroundTag = BlockTags.f_144274_;
        private BYGBoat.BYGType boatType;
        private MaterialColor materialColor;
        private Function<String, BlockRegistryObject<Block>> leavesFactory = id -> BYGBlocks.createLeaves(this.materialColor, id);
        private boolean isNether;
        private boolean flammable = true;
        private boolean leavesHaveOverlay;

        public Builder growerItem(GrowerItemType type) {
            this.growerItemType = type;
            return this;
        }

        public Builder exclude(BlockType ... types) {
            this.excludes.addAll(List.of(types));
            return this;
        }

        public Builder growerItemGroundTag(TagKey<Block> tag) {
            this.growerItemGroundTag = tag;
            return this;
        }

        public Builder boatType(BYGBoat.BYGType type) {
            this.boatType = type;
            return this;
        }

        public Builder materialColor(MaterialColor colour) {
            this.materialColor = colour;
            return this;
        }

        public Builder nether() {
            this.isNether = true;
            this.notFlammable();
            return this;
        }

        public Builder notFlammable() {
            this.flammable = false;
            return this;
        }

        public Builder registryName(BlockType blockType, String name) {
            this.registryName.put(blockType, name);
            return this;
        }

        public Builder leavesHaveOverlay() {
            this.leavesHaveOverlay = true;
            return this;
        }

        public Builder leavesFactory(Function<String, BlockRegistryObject<Block>> leavesFactory) {
            this.leavesFactory = leavesFactory;
            return this;
        }
    }

    public static enum BlockType {
        LEAVES,
        SAPLING,
        WOOD,
        LOG,
        STRIPPED_WOOD,
        STRIPPED_LOG;

    }

    public static enum GrowerItemType {
        SAPLING,
        ODDITY,
        FUNGUS,
        MUSHROOM,
        WART;

    }
}

