/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.serialization.codec.CollectionCodec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import potionstudios.byg.mixin.access.WeightedListAccess;

public final class LevelBiomeTracker {
    private final Map<ResourceKey<Biome>, Collection<ResourceKey<Level>>> biomeDimensions = new Object2ObjectOpenHashMap();
    private final Map<ResourceKey<Biome>, ObjectOpenHashSet<ResourceKey<EntityType<?>>>> biomeMobs;
    public static LevelBiomeTracker client_instance = null;
    public static final Codec<LevelBiomeTracker> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap((Codec)ResourceKey.m_195966_((ResourceKey)Registry.f_122819_), (Codec)new CollectionCodec(ResourceKey.m_195966_((ResourceKey)Registry.f_122885_), ObjectOpenHashSet::new)).fieldOf("biomes_for_level").forGetter(levelBiomeTracker -> levelBiomeTracker.biomesForLevel), (App)Codec.unboundedMap((Codec)ResourceKey.m_195966_((ResourceKey)Registry.f_122885_), (Codec)new CollectionCodec(ResourceKey.m_195966_((ResourceKey)Registry.f_122903_), ObjectOpenHashSet::new)).fieldOf("biome_mobs").forGetter(levelBiomeTracker -> levelBiomeTracker.biomeMobs)).apply((Applicative)builder, LevelBiomeTracker::new));
    private final Map<ResourceKey<Level>, ObjectOpenHashSet<ResourceKey<Biome>>> biomesForLevel;

    public LevelBiomeTracker(Map<ResourceKey<Level>, ObjectOpenHashSet<ResourceKey<Biome>>> biomesForLevel, Map<ResourceKey<Biome>, ObjectOpenHashSet<ResourceKey<EntityType<?>>>> biomeMobs) {
        this.biomesForLevel = biomesForLevel;
        biomesForLevel.forEach((level, biomes) -> {
            for (ResourceKey biome : biomes) {
                this.biomeDimensions.computeIfAbsent((ResourceKey<Biome>)biome, key -> new ObjectOpenHashSet()).add(level);
            }
        });
        this.biomeMobs = biomeMobs;
    }

    public static LevelBiomeTracker fromServer(MinecraftServer server) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap entitySpawns = new Object2ObjectOpenHashMap();
        for (ServerLevel level : server.m_129785_()) {
            ObjectOpenHashSet biomes = (ObjectOpenHashSet)map.computeIfAbsent((Object)level.m_46472_(), key -> new ObjectOpenHashSet());
            level.m_7726_().m_8481_().m_62218_().m_207840_().stream().filter(biomeHolder -> ((ResourceKey)biomeHolder.m_203543_().orElseThrow()).m_135782_().m_135827_().equals("byg")).forEach(possibleBiome -> {
                ResourceKey biomeResourceKey = (ResourceKey)possibleBiome.m_203543_().orElseThrow();
                biomes.add((Object)biomeResourceKey);
                for (MobCategory category : MobCategory.values()) {
                    WeightedRandomList mobs = ((Biome)possibleBiome.m_203334_()).m_47518_().m_151798_(category);
                    ((WeightedListAccess)mobs).byg_getItems().stream().map(spawnerData -> spawnerData.f_48404_).map(entityType -> (ResourceKey)Registry.f_122826_.m_7854_(entityType).orElseThrow()).forEach(entityTypeResourceKey -> ((ObjectOpenHashSet)entitySpawns.computeIfAbsent((Object)biomeResourceKey, key -> new ObjectOpenHashSet())).add(entityTypeResourceKey));
                }
            });
        }
        return new LevelBiomeTracker((Map<ResourceKey<Level>, ObjectOpenHashSet<ResourceKey<Biome>>>)map, (Map<ResourceKey<Biome>, ObjectOpenHashSet<ResourceKey<EntityType<?>>>>)entitySpawns);
    }

    public Map<ResourceKey<Level>, ObjectOpenHashSet<ResourceKey<Biome>>> biomesForLevel() {
        return this.biomesForLevel;
    }

    public Map<ResourceKey<Biome>, Collection<ResourceKey<Level>>> biomeDimensions() {
        return this.biomeDimensions;
    }

    public Map<ResourceKey<Biome>, ObjectOpenHashSet<ResourceKey<EntityType<?>>>> getBiomeMobs() {
        return this.biomeMobs;
    }

    public static interface Access {
        public LevelBiomeTracker levelBiomeTracker();
    }
}

