/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.structure.volcano;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import potionstudios.byg.common.world.structure.BYGStructureTypes;
import potionstudios.byg.common.world.structure.volcano.VolcanoPiece;

public class VolcanoStructure
extends Structure {
    public static final Codec<VolcanoStructure> CODEC = RecordCodecBuilder.mapCodec(archStructureInstance -> archStructureInstance.group((App)VolcanoStructure.m_226567_((RecordCodecBuilder.Instance)archStructureInstance)).apply((Applicative)archStructureInstance, VolcanoStructure::new)).codec();

    public VolcanoStructure(Structure.StructureSettings structureSettings) {
        super(structureSettings);
    }

    private static void generatePieces(StructurePiecesBuilder piecesBuilder, Structure.GenerationContext context) {
        WorldgenRandom random = context.f_226626_();
        int seed = random.m_188502_();
        ChunkPos chunkPos = context.f_226628_();
        int blockX = chunkPos.m_151382_(random.m_188503_(16));
        int blockZ = chunkPos.m_151391_(random.m_188503_(16));
        int baseHeight = context.f_226622_().m_214096_(blockX, blockZ, Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_());
        BlockPos origin = new BlockPos(blockX, baseHeight, blockZ);
        double baseRadius = random.m_216339_(75, 120);
        double leakage = 2.0 - random.m_188500_() * 2.0;
        int volcanoConeSize = random.m_216339_(75, 120) + 50;
        int volcanoStartHeight = volcanoConeSize - 10;
        double threshold = 1.0;
        int maxY = -random.m_216339_(5, 35);
        int fluidYOffset = random.m_216339_(2, 5);
        int coneSizePacked = SectionPos.m_123171_((int)volcanoConeSize);
        for (int x = -coneSizePacked; x <= coneSizePacked; ++x) {
            for (int z = -coneSizePacked; z <= coneSizePacked; ++z) {
                long chunk = ChunkPos.m_45589_((int)(SectionPos.m_123171_((int)blockX) + x), (int)(SectionPos.m_123171_((int)blockZ) + z));
                piecesBuilder.m_142679_((StructurePiece)new VolcanoPiece(new PieceStructureInfo(origin, seed, baseRadius, leakage, volcanoConeSize, volcanoStartHeight, threshold, maxY, fluidYOffset), 0, VolcanoStructure.getWritableArea(new ChunkPos(chunk), context.f_226629_())));
            }
        }
    }

    public static BoundingBox getWritableArea(ChunkPos chunkPos, LevelHeightAccessor accessor) {
        int i = chunkPos.m_45604_();
        int j = chunkPos.m_45605_();
        int k = accessor.m_141937_() + 1;
        int l = accessor.m_151558_() - 1;
        return new BoundingBox(i, k, j, i + 15, l, j + 15);
    }

    private static boolean matchesBiome(BlockPos pos, ChunkGenerator generator, TagKey<Biome> biomeTagKey, RandomState randomState) {
        return generator.m_62218_().m_203407_(QuartPos.m_175400_((int)pos.m_123341_()), QuartPos.m_175400_((int)pos.m_123342_()), QuartPos.m_175400_((int)pos.m_123343_()), randomState.m_224579_()).m_203656_(biomeTagKey);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext generationContext) {
        return VolcanoStructure.m_226585_((Structure.GenerationContext)generationContext, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, piecesBuilder -> VolcanoStructure.generatePieces(piecesBuilder, generationContext));
    }

    public StructureType<?> m_213658_() {
        return BYGStructureTypes.VOLCANO.get();
    }

    public record PieceStructureInfo(BlockPos origin, int noiseSeed, double baseRadius, double leakage, int volcanoConeSize, int volcanoStartHeight, double threshold, int maxY, int fluidY) {
        public static final Codec<PieceStructureInfo> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockPos.f_121852_.fieldOf("origin").forGetter(PieceStructureInfo::origin), (App)Codec.INT.fieldOf("noiseSeed").forGetter(PieceStructureInfo::noiseSeed), (App)Codec.DOUBLE.fieldOf("baseRadius").forGetter(PieceStructureInfo::baseRadius), (App)Codec.DOUBLE.fieldOf("leakage").forGetter(PieceStructureInfo::leakage), (App)Codec.INT.fieldOf("volcanoConeSize").forGetter(PieceStructureInfo::volcanoConeSize), (App)Codec.INT.fieldOf("volcanoStartHeight").forGetter(PieceStructureInfo::volcanoStartHeight), (App)Codec.DOUBLE.fieldOf("threshold").forGetter(PieceStructureInfo::threshold), (App)Codec.INT.fieldOf("maxY").forGetter(PieceStructureInfo::maxY), (App)Codec.INT.fieldOf("fluidY").forGetter(PieceStructureInfo::fluidY)).apply((Applicative)builder, PieceStructureInfo::new));
    }
}

