/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.integration.lootr;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import noobanidus.mods.lootr.init.ModBlocks;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.content.building.module.VariantChestsModule;
import vazkii.quark.integration.lootr.ILootrIntegration;
import vazkii.quark.integration.lootr.LootrVariantChestBlock;
import vazkii.quark.integration.lootr.LootrVariantChestBlockEntity;
import vazkii.quark.integration.lootr.LootrVariantTrappedChestBlock;
import vazkii.quark.integration.lootr.LootrVariantTrappedChestBlockEntity;
import vazkii.quark.integration.lootr.client.LootrVariantChestRenderer;

public class LootrIntegration
implements ILootrIntegration {
    private BlockEntityType<LootrVariantChestBlockEntity> chestTEType;
    private BlockEntityType<LootrVariantTrappedChestBlockEntity> trappedChestTEType;
    private final Map<Block, Block> lootrChests = new HashMap<Block, Block>();
    private final List<Block> chests = new LinkedList<Block>();
    private final List<Block> trappedChests = new LinkedList<Block>();
    private final List<Block> allChests = new LinkedList<Block>();

    @Override
    public BlockEntityType<? extends ChestBlockEntity> chestTE() {
        return this.chestTEType;
    }

    @Override
    public BlockEntityType<? extends ChestBlockEntity> trappedChestTE() {
        return this.trappedChestTEType;
    }

    @Override
    @Nullable
    public Block lootrVariant(Block base) {
        return this.lootrChests.get(base);
    }

    @Override
    public void postRegister() {
        Consumer[] consumerArray = new Consumer[2];
        consumerArray[0] = this.allChests::addAll;
        consumerArray[1] = this.chests::addAll;
        this.chestTEType = VariantChestsModule.registerChests(LootrVariantChestBlockEntity::new, () -> this.chestTEType, LootrVariantChestBlock::new, LootrVariantChestBlock.Compat::new, consumerArray);
        Consumer[] consumerArray2 = new Consumer[2];
        consumerArray2[0] = this.allChests::addAll;
        consumerArray2[1] = this.trappedChests::addAll;
        this.trappedChestTEType = VariantChestsModule.registerChests(LootrVariantTrappedChestBlockEntity::new, () -> this.trappedChestTEType, LootrVariantTrappedChestBlock::new, LootrVariantTrappedChestBlock.Compat::new, consumerArray2);
        for (int i = 0; i < this.chests.size(); ++i) {
            this.lootrChests.put(VariantChestsModule.chests.get(i), this.chests.get(i));
            this.lootrChests.put(VariantChestsModule.trappedChests.get(i), this.trappedChests.get(i));
        }
        RegistryHelper.register(this.chestTEType, (String)"lootr_variant_chest", (ResourceKey)Registry.f_122907_);
        RegistryHelper.register(this.trappedChestTEType, (String)"lootr_variant_trapped_chest", (ResourceKey)Registry.f_122907_);
    }

    @Override
    public void loadComplete() {
        ModBlocks.getSpecialLootChests().addAll(this.allChests);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        BlockEntityRenderers.m_173590_(this.chestTEType, LootrVariantChestRenderer::new);
        BlockEntityRenderers.m_173590_(this.trappedChestTEType, LootrVariantChestRenderer::new);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void stitch(TextureStitchEvent.Pre event) {
        for (Block b : this.allChests) {
            LootrVariantChestRenderer.accept(event, b);
        }
    }
}

