/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import vazkii.quark.api.event.ModuleLoadedEvent;
import vazkii.quark.api.event.ModuleStateChangedEvent;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.module.hint.HintObject;

public class QuarkModule {
    public ModuleCategory category = null;
    public String displayName = "";
    public String lowercaseName = "";
    public String description = "";
    public List<String> antiOverlap = null;
    public boolean hasSubscriptions = false;
    public List<Dist> subscriptionTarget = Lists.newArrayList((Object[])new Dist[]{Dist.CLIENT, Dist.DEDICATED_SERVER});
    public boolean enabledByDefault = true;
    public boolean missingDep = false;
    public List<HintObject> hints = Lists.newArrayList();
    private boolean firstLoad = true;
    public boolean enabled = false;
    public boolean disabledByOverlap = false;
    public boolean configEnabled = false;
    public boolean ignoreAntiOverlap = false;

    public void construct() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void constructClient() {
    }

    public void register() {
    }

    public void postRegister() {
    }

    public void configChanged() {
    }

    public void enabledStatusChanged(boolean firstLoad, boolean oldStatus, boolean newStatus) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void configChangedClient() {
    }

    public void setup() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerReloadListeners(Consumer<PreparableReloadListener> manager) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void modelBake(ModelEvent.BakingCompleted event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void modelLayers(EntityRenderersEvent.AddLayers event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void textureStitch(TextureStitchEvent.Pre event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void postTextureStitch(TextureStitchEvent.Post event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerKeybinds(RegisterKeyMappingsEvent event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerItemColors(RegisterColorHandlersEvent.Item event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerBlockColors(RegisterColorHandlersEvent.Block event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClientTooltipComponentFactories(RegisterClientTooltipComponentFactoriesEvent event) {
    }

    public void loadComplete() {
    }

    public final void addStackInfo(BiConsumer<Item, Component> consumer) {
        if (!this.enabled) {
            return;
        }
        for (HintObject hint : this.hints) {
            hint.apply(consumer);
        }
        this.addAdditionalHints(consumer);
    }

    public void addAdditionalHints(BiConsumer<Item, Component> consumer) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void firstClientTick() {
    }

    public void pushFlags(ConfigFlagManager manager) {
    }

    protected void enqueue(Runnable r) {
        ModuleLoader.INSTANCE.enqueue(r);
    }

    public final void setEnabled(boolean enabled) {
        this.configEnabled = enabled;
        if (this.firstLoad) {
            Quark.LOG.info("Loading Module " + this.displayName);
            MinecraftForge.EVENT_BUS.post((Event)new ModuleLoadedEvent(this.lowercaseName));
        }
        this.disabledByOverlap = false;
        if (this.missingDep) {
            enabled = false;
        } else if (!this.ignoreAntiOverlap && this.antiOverlap != null) {
            ModList list = ModList.get();
            for (String s : this.antiOverlap) {
                if (!list.isLoaded(s)) continue;
                this.disabledByOverlap = true;
                enabled = false;
                break;
            }
        }
        this.setEnabledAndManageSubscriptions(this.firstLoad, enabled);
        this.firstLoad = false;
    }

    private void setEnabledAndManageSubscriptions(boolean firstLoad, boolean enabled) {
        boolean changed;
        if (MinecraftForge.EVENT_BUS.post((Event)new ModuleStateChangedEvent(this.lowercaseName, enabled))) {
            enabled = false;
        }
        boolean wasEnabled = this.enabled;
        this.enabled = enabled;
        boolean bl = changed = wasEnabled != enabled;
        if (changed) {
            if (this.hasSubscriptions && this.subscriptionTarget.contains(FMLEnvironment.dist)) {
                if (enabled) {
                    MinecraftForge.EVENT_BUS.register((Object)this);
                } else if (!firstLoad) {
                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                }
            }
            this.enabledStatusChanged(firstLoad, wasEnabled, enabled);
        }
    }
}

