/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.util;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WeightedSelector<U> {
    private final List<Entry<? extends U>> entries = Lists.newArrayList();
    private final Random random;

    public WeightedSelector() {
        this(new Random());
    }

    public WeightedSelector(Random rand) {
        this.random = rand;
    }

    public void add(@Nonnull U value, int weight) {
        this.entries.add(new Entry<U>(value, weight));
    }

    public void shuffle() {
        this.entries.forEach(entry -> entry.randomizeWithValue(this.random.nextFloat()));
        this.entries.sort(Comparator.comparingDouble(Entry::getWeightedPower));
    }

    @Nonnull
    public U select(U defaultValue) {
        this.shuffle();
        if (this.entries.isEmpty()) {
            return defaultValue;
        }
        return this.entries.get(0).getValue();
    }

    @Nullable
    public U select() {
        return this.select(null);
    }

    @Nonnull
    public Stream<? extends U> stream() {
        return this.entries.stream().map(Entry::getValue);
    }

    public String toString() {
        return "WeightedList[" + this.entries + "]";
    }

    @Nonnull
    public WeightedSelector<U> copy() {
        WeightedSelector copied = new WeightedSelector();
        for (Entry<? extends U> entry : this.entries) {
            copied.add(entry.value, entry.weight);
        }
        return copied;
    }

    private static class Entry<T> {
        private final T value;
        private final int weight;
        private double weightedPower;

        private Entry(T value, int weight) {
            this.weight = weight;
            this.value = value;
        }

        public double getWeightedPower() {
            return this.weightedPower;
        }

        public void randomizeWithValue(float randValue) {
            this.weightedPower = -Math.pow(randValue, 1.0f / (float)this.weight);
        }

        @Nonnull
        public T getValue() {
            return this.value;
        }

        public String toString() {
            return this.weight + ":" + this.value;
        }
    }
}

