/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.module;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.handler.EntityAttributeHandler;
import vazkii.quark.base.handler.advancement.QuarkAdvancementHandler;
import vazkii.quark.base.handler.advancement.QuarkGenericTrigger;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.CompoundBiomeConfig;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.module.config.type.EntitySpawnConfig;
import vazkii.quark.base.world.EntitySpawnHandler;
import vazkii.quark.content.mobs.client.render.entity.ToretoiseRenderer;
import vazkii.quark.content.mobs.entity.Toretoise;

@LoadModule(category=ModuleCategory.MOBS, hasSubscriptions=true)
public class ToretoiseModule
extends QuarkModule {
    public static EntityType<Toretoise> toretoiseType;
    @Config
    public static int maxYLevel;
    @Config(description="The number of ticks from mining a tortoise until feeding it could cause it to regrow.")
    public static int cooldownTicks;
    @Config(description="The items that can be fed to toretoises to make them regrow ores.")
    public static List<String> foods;
    @Config(flag="toretoise_regrow")
    public static boolean allowToretoiseToRegrow;
    @Config(description="Feeding a toretoise after cooldown will regrow them with a one-in-this-number chance. Set to 1 to always regrow, higher = lower chance.")
    public static int regrowChance;
    @Config
    public static DimensionConfig dimensions;
    @Config
    public static EntitySpawnConfig spawnConfig;
    public static QuarkGenericTrigger mineToretoiseTrigger;
    public static QuarkGenericTrigger mineFedToretoiseTrigger;

    @Override
    public void register() {
        toretoiseType = EntityType.Builder.m_20704_(Toretoise::new, (MobCategory)MobCategory.CREATURE).m_20699_(2.0f, 1.0f).m_20702_(8).m_20719_().setCustomClientFactory((spawnEntity, world) -> new Toretoise((EntityType<? extends Toretoise>)toretoiseType, (Level)world)).m_20712_("toretoise");
        RegistryHelper.register(toretoiseType, (String)"toretoise", (ResourceKey)Registry.f_122903_);
        EntitySpawnHandler.registerSpawn(toretoiseType, MobCategory.MONSTER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Toretoise::spawnPredicate, spawnConfig);
        EntitySpawnHandler.addEgg(this, toretoiseType, 5587259, 3682871, spawnConfig);
        EntityAttributeHandler.put(toretoiseType, Toretoise::prepareAttributes);
        mineToretoiseTrigger = QuarkAdvancementHandler.registerGenericTrigger("mine_toretoise");
        mineFedToretoiseTrigger = QuarkAdvancementHandler.registerGenericTrigger("mine_fed_toretoise");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        EntityRenderers.m_174036_(toretoiseType, ToretoiseRenderer::new);
    }

    static {
        maxYLevel = 0;
        cooldownTicks = 1200;
        foods = Lists.newArrayList((Object[])new String[]{"minecraft:glow_berries"});
        allowToretoiseToRegrow = true;
        regrowChance = 3;
        dimensions = DimensionConfig.overworld(false);
        spawnConfig = new EntitySpawnConfig(120, 2, 4, CompoundBiomeConfig.fromBiomeTags(true, Tags.Biomes.IS_VOID, BiomeTags.f_207612_, BiomeTags.f_215818_));
    }
}

