/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.compat.jei;

import elucent.rootsclassic.compat.jei.category.MortarCategory;
import elucent.rootsclassic.compat.jei.category.RitualCategory;
import elucent.rootsclassic.compat.jei.wrapper.RitualWrapper;
import elucent.rootsclassic.recipe.ComponentRecipe;
import elucent.rootsclassic.registry.RootsRecipes;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.ritual.RitualBase;
import elucent.rootsclassic.ritual.RitualRegistry;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.RegistryObject;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation PLUGIN_UID = new ResourceLocation("rootsclassic", "main");
    public static final ResourceLocation MORTAR = new ResourceLocation("rootsclassic", "mortar");
    public static final RecipeType<ComponentRecipe> MORTAR_TYPE = RecipeType.create((String)"rootsclassic", (String)"mortar", ComponentRecipe.class);
    public static final ResourceLocation RITUAL = new ResourceLocation("rootsclassic", "ritual");
    public static final RecipeType<RitualWrapper> RITUAL_TYPE = RecipeType.create((String)"rootsclassic", (String)"ritual", RitualWrapper.class);
    @Nullable
    private IRecipeCategory<ComponentRecipe> mortarCategory;
    @Nullable
    private IRecipeCategory<RitualWrapper> ritualCategory;

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RootsRegistry.MORTAR.get()), new RecipeType[]{MORTAR_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RootsRegistry.ALTAR.get()), new RecipeType[]{RITUAL_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[2];
        this.mortarCategory = new MortarCategory(guiHelper);
        iRecipeCategoryArray[0] = this.mortarCategory;
        this.ritualCategory = new RitualCategory(guiHelper);
        iRecipeCategoryArray[1] = this.ritualCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        for (RegistryObject registryObject : RootsRegistry.ITEMS.getEntries()) {
            Item item = (Item)registryObject.get();
            if (item == null) continue;
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)(item.m_5524_() + ".guide"))});
        }
        assert (MORTAR_TYPE != null);
        assert (RITUAL_TYPE != null);
        ClientLevel world = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        registration.addRecipes(MORTAR_TYPE, world.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)RootsRecipes.COMPONENT_RECIPE_TYPE.get()));
        registration.addRecipes(RITUAL_TYPE, this.getRituals());
    }

    public List<RitualWrapper> getRituals() {
        LinkedList<RitualWrapper> entries = new LinkedList<RitualWrapper>();
        RitualRegistry.RITUALS.getEntries().forEach(ritual -> entries.add(new RitualWrapper((RitualBase)ritual.get())));
        return entries;
    }
}

