/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.item;

import elucent.rootsclassic.capability.IManaCapability;
import elucent.rootsclassic.capability.RootsCapabilityManager;
import elucent.rootsclassic.client.particles.MagicLineParticleData;
import elucent.rootsclassic.client.particles.MagicParticleData;
import elucent.rootsclassic.component.ComponentBase;
import elucent.rootsclassic.component.ComponentBaseRegistry;
import elucent.rootsclassic.component.EnumCastType;
import elucent.rootsclassic.config.RootsConfig;
import elucent.rootsclassic.item.IManaRelatedItem;
import elucent.rootsclassic.item.SylvanArmorItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class StaffItem
extends Item
implements IManaRelatedItem {
    private static final String NBT_USES = "uses";
    private static final String NBT_MAX = "maxUses";
    private static final double RANGE = 3.0;
    private static final double SIZE_PER_LEVEL = 2.0;
    private static final double SIZE_BASE = 3.0;

    public StaffItem(Item.Properties properties) {
        super(properties);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public int m_142158_(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            return Math.round((float)tag.m_128451_(NBT_USES) * 13.0f / (float)tag.m_128451_(NBT_MAX));
        }
        return 1;
    }

    public boolean m_142522_(ItemStack stack) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            return tag.m_128451_(NBT_USES) < tag.m_128451_(NBT_MAX);
        }
        return false;
    }

    public void m_5551_(ItemStack stack, Level levelAccessor, LivingEntity caster, int timeLeft) {
        CompoundTag tag;
        if (timeLeft < 71988 && stack.m_41782_() && caster.getCapability(RootsCapabilityManager.MANA_CAPABILITY).isPresent() && (tag = stack.m_41783_()).m_128451_(NBT_USES) >= 0) {
            ComponentBase comp;
            tag.m_128405_(NBT_USES, tag.m_128451_(NBT_USES) - 1);
            ResourceLocation compName = ResourceLocation.m_135820_((String)tag.m_128461_("rootsclassic:effect"));
            if (compName != null && (comp = (ComponentBase)ComponentBaseRegistry.COMPONENTS.get().getValue(compName)) != null) {
                IManaCapability manaCap;
                int potency = tag.m_128451_("rootsclassic:potency");
                int efficiency = tag.m_128451_("rootsclassic:efficiency");
                int size = tag.m_128451_("rootsclassic:size");
                Player player = (Player)caster;
                if (player.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof SylvanArmorItem && player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof SylvanArmorItem && player.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof SylvanArmorItem && player.m_6844_(EquipmentSlot.FEET).m_41720_() instanceof SylvanArmorItem) {
                    ++potency;
                }
                if ((manaCap = (IManaCapability)player.getCapability(RootsCapabilityManager.MANA_CAPABILITY).orElse(null)).getMana() >= comp.getManaCost() / (float)(efficiency + 1)) {
                    manaCap.setMana(manaCap.getMana() - comp.getManaCost() / (float)(efficiency + 1));
                    Vec3 lookVec = caster.m_20154_();
                    comp.doEffect(levelAccessor, (Entity)caster, EnumCastType.SPELL, caster.m_20185_() + 3.0 * lookVec.f_82479_, caster.m_20186_() + 3.0 * lookVec.f_82480_, caster.m_20189_() + 3.0 * lookVec.f_82481_, potency, efficiency, 3.0 + 2.0 * (double)size);
                    if (levelAccessor.f_46443_) {
                        for (int i = 0; i < 90; ++i) {
                            double offX = (double)levelAccessor.f_46441_.m_188501_() * 0.5 - 0.25;
                            double offY = (double)levelAccessor.f_46441_.m_188501_() * 0.5 - 0.25;
                            double offZ = (double)levelAccessor.f_46441_.m_188501_() * 0.5 - 0.25;
                            double coeff = (offX + offY + offZ) / 1.5 + 0.5;
                            double dx = (lookVec.f_82479_ + offX) * coeff;
                            double dy = (lookVec.f_82480_ + offY) * coeff;
                            double dz = (lookVec.f_82481_ + offZ) * coeff;
                            if (levelAccessor.f_46441_.m_188499_()) {
                                levelAccessor.m_7106_(MagicParticleData.createData(comp.primaryColor.f_82479_, comp.primaryColor.f_82480_, comp.primaryColor.f_82481_), caster.m_20185_() + dx, caster.m_20186_() + 1.5 + dy, caster.m_20189_() + dz, dx, dy, dz);
                                continue;
                            }
                            levelAccessor.m_7106_(MagicParticleData.createData(comp.secondaryColor.f_82479_, comp.secondaryColor.f_82480_, comp.secondaryColor.f_82481_), caster.m_20185_() + dx, caster.m_20186_() + 1.5 + dy, caster.m_20189_() + dz, dx, dy, dz);
                        }
                    }
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level levelAccessor, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (levelAccessor.f_46443_ && Minecraft.m_91087_().f_91080_ != null) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        player.m_6672_(hand);
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public void m_6883_(ItemStack stack, Level levelAccessor, Entity entityIn, int itemSlot, boolean isSelected) {
        CompoundTag tag;
        if (stack.m_41782_() && stack.m_150930_((Item)this) && (tag = stack.m_41783_()).m_128441_(NBT_USES) && tag.m_128451_(NBT_USES) <= 0 && entityIn instanceof Player) {
            stack.m_41774_(1);
            if (entityIn instanceof Player) {
                ((Player)entityIn).m_36246_(Stats.f_12983_.m_12902_((Object)stack.m_41720_()));
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldS, ItemStack newS, boolean slotChanged) {
        if (oldS.m_41782_() && newS.m_41782_() && !oldS.m_41783_().m_128461_("rootsclassic:effect").equals(newS.m_41783_().m_128461_("rootsclassic:effect"))) {
            return true;
        }
        return slotChanged;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        ComponentBase comp;
        CompoundTag tag;
        ResourceLocation componentName;
        if (stack.m_41782_() && (componentName = ResourceLocation.m_135820_((String)(tag = stack.m_41783_()).m_128461_("rootsclassic:effect"))) != null && (comp = (ComponentBase)ComponentBaseRegistry.COMPONENTS.get().getValue(componentName)) != null) {
            int potency = tag.m_128451_("rootsclassic:potency");
            int efficiency = tag.m_128451_("rootsclassic:efficiency");
            int size = tag.m_128451_("rootsclassic:size");
            comp.castingAction((Player)player, count, potency, efficiency, size);
            if (player.m_20193_().f_46443_) {
                if (player.m_217043_().m_188499_()) {
                    player.m_20193_().m_7106_(MagicLineParticleData.createData(comp.primaryColor.f_82479_, comp.primaryColor.f_82480_, comp.primaryColor.f_82481_), player.m_20185_() + 2.0 * ((double)player.m_217043_().m_188501_() - 0.5), player.m_20186_() + 2.0 * ((double)player.m_217043_().m_188501_() - 0.5) + 1.0, player.m_20189_() + 2.0 * ((double)player.m_217043_().m_188501_() - 0.5), player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
                } else {
                    player.m_20193_().m_7106_(MagicLineParticleData.createData(comp.secondaryColor.f_82479_, comp.secondaryColor.f_82480_, comp.secondaryColor.f_82481_), player.m_20185_() + 2.0 * ((double)player.m_217043_().m_188501_() - 0.5), player.m_20186_() + 2.0 * ((double)player.m_217043_().m_188501_() - 0.5) + 1.0, player.m_20189_() + 2.0 * ((double)player.m_217043_().m_188501_() - 0.5), player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_());
                }
            }
        }
    }

    public static void createData(ItemStack stack, String effect, int potency, int efficiency, int size) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("rootsclassic:effect", effect);
        tag.m_128405_("rootsclassic:potency", potency);
        tag.m_128405_("rootsclassic:efficiency", efficiency);
        tag.m_128405_("rootsclassic:size", size);
        int uses = StaffItem.getMaxUsesBase() + StaffItem.getMaxUsesPerEfficiency() * efficiency;
        tag.m_128405_(NBT_MAX, uses);
        tag.m_128405_(NBT_USES, uses);
        stack.m_41751_(tag);
    }

    public static int getMaxUsesBase() {
        return (Integer)RootsConfig.COMMON.staffUsesBasic.get();
    }

    public static int getMaxUsesPerEfficiency() {
        return (Integer)RootsConfig.COMMON.staffUsesEfficiency.get();
    }

    public void m_7373_(ItemStack stack, @Nullable Level levelAccessor, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, levelAccessor, tooltip, flagIn);
        if (stack.m_41782_()) {
            ComponentBase comp;
            CompoundTag tag = stack.m_41783_();
            ResourceLocation compName = ResourceLocation.m_135820_((String)tag.m_128461_("rootsclassic:effect"));
            if (compName != null && (comp = (ComponentBase)ComponentBaseRegistry.COMPONENTS.get().getValue(compName)) != null) {
                tooltip.add((Component)Component.m_237115_((String)"rootsclassic.tooltip.spelltypeheading").m_130946_(": ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)comp.getEffectName().m_130940_(comp.getTextColor())));
            }
            tooltip.add((Component)Component.m_237115_((String)("  +" + tag.m_128451_("rootsclassic:potency") + " ")).m_7220_((Component)Component.m_237115_((String)"rootsclassic.tooltip.spellpotency")).m_130946_(".").m_130940_(ChatFormatting.RED));
            tooltip.add((Component)Component.m_237115_((String)("  +" + tag.m_128451_("rootsclassic:efficiency") + " ")).m_7220_((Component)Component.m_237115_((String)"rootsclassic.tooltip.spellefficiency")).m_130946_(".").m_130940_(ChatFormatting.RED));
            tooltip.add((Component)Component.m_237115_((String)("  +" + tag.m_128451_("rootsclassic:size") + " ")).m_7220_((Component)Component.m_237115_((String)"rootsclassic.tooltip.spellsize")).m_130946_(".").m_130940_(ChatFormatting.RED));
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)(tag.m_128451_(NBT_USES) + " ")).m_7220_((Component)Component.m_237115_((String)"rootsclassic.tooltip.usesremaining")).m_130946_(".").m_130940_(ChatFormatting.GOLD));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"rootsclassic.error.unset").m_130940_(ChatFormatting.GRAY));
        }
    }
}

