/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.sandbox.datagen.ext;

import com.mojang.datafixers.util.Pair;
import io.github.noeppi_noeppi.mods.sandbox.SandBox;
import io.github.noeppi_noeppi.mods.sandbox.biome.BiomeLayer;
import io.github.noeppi_noeppi.mods.sandbox.datagen.ext.base.SingleWorldGenData;
import io.github.noeppi_noeppi.mods.sandbox.datagen.ext.base.WorldGenData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;

public class BiomeLayerData
extends SingleWorldGenData<BiomeLayer> {
    public BiomeLayerData(WorldGenData.Properties properties) {
        super(properties, SandBox.BIOME_LAYER_REGISTRY, BiomeLayer.DIRECT_CODEC);
    }

    public BiomeLayerBuilder layer() {
        return this.layer(null);
    }

    public BiomeLayerBuilder layer(int weight) {
        return new BiomeLayerBuilder(null, weight);
    }

    public BiomeLayerBuilder layer(ResourceKey<BiomeLayer> key) {
        return this.layer(key, 1);
    }

    public BiomeLayerBuilder layer(ResourceKey<BiomeLayer> key, int weight) {
        return new BiomeLayerBuilder(key, weight);
    }

    public class BiomeLayerBuilder {
        @Nullable
        private final ResourceKey<BiomeLayer> key;
        private final int weight;
        private ClimateRangeTarget range;
        private final List<Pair<Climate.ParameterPoint, Holder<Biome>>> biomes;

        private BiomeLayerBuilder(ResourceKey<BiomeLayer> key, int weight) {
            this.key = key;
            this.weight = weight;
            this.range = ClimateRangeTarget.Special.FULL_RANGE;
            this.biomes = new ArrayList<Pair<Climate.ParameterPoint, Holder<Biome>>>();
        }

        public BiomeLayerBuilder fullRange() {
            this.range = ClimateRangeTarget.Special.FULL_RANGE;
            return this;
        }

        public BiomeLayerBuilder dynamicRange() {
            this.range = ClimateRangeTarget.Special.DYNAMIC;
            return this;
        }

        public BiomeLayerBuilder range(Climate.ParameterPoint range) {
            this.range = new ClimateRangeTarget.Value(range);
            return this;
        }

        public ClimateBuilder biome(ResourceKey<Biome> biome) {
            return this.biome((Holder<Biome>)BiomeLayerData.this.holder(biome));
        }

        public ClimateBuilder biome(Holder<Biome> biome) {
            return new ClimateBuilder(this, BiomeLayerData.this.registries.holder(Registry.f_122885_, biome));
        }

        public Holder<BiomeLayer> build() {
            if (this.biomes.isEmpty()) {
                throw new IllegalStateException("Empty biome layer");
            }
            Climate.ParameterList climateData = new Climate.ParameterList(List.copyOf(this.biomes));
            BiomeLayer layer = new BiomeLayer(this.weight, this.range.build((Climate.ParameterList<Holder<Biome>>)climateData), (Climate.ParameterList<Holder<Biome>>)climateData);
            if (this.key != null) {
                BiomeLayerData.this.registries.register(SandBox.BIOME_LAYER_REGISTRY, this.key.m_135782_(), layer);
            }
            return BiomeLayerData.this.addToList(BiomeLayerData.this.registries.holder(SandBox.BIOME_LAYER_REGISTRY, layer));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface ClimateRangeTarget {
        public Climate.ParameterPoint build(Climate.ParameterList<Holder<Biome>> var1);

        public record Value(Climate.ParameterPoint value) implements ClimateRangeTarget
        {
            @Override
            public Climate.ParameterPoint build(Climate.ParameterList<Holder<Biome>> climateData) {
                return this.value();
            }
        }

        public static enum Special implements ClimateRangeTarget
        {
            FULL_RANGE,
            DYNAMIC;


            @Override
            public Climate.ParameterPoint build(Climate.ParameterList<Holder<Biome>> climateData) {
                return switch (this) {
                    default -> throw new IncompatibleClassChangeError();
                    case FULL_RANGE -> BiomeLayer.FULL_RANGE;
                    case DYNAMIC -> new Climate.ParameterPoint(Special.ofAll(climateData, Climate.ParameterPoint::f_186863_), Special.ofAll(climateData, Climate.ParameterPoint::f_186864_), Special.ofAll(climateData, Climate.ParameterPoint::f_186865_), Special.ofAll(climateData, Climate.ParameterPoint::f_186866_), Special.ofAll(climateData, Climate.ParameterPoint::f_186867_), Special.ofAll(climateData, Climate.ParameterPoint::f_186868_), 0L);
                };
            }

            private static Climate.Parameter ofAll(Climate.ParameterList<Holder<Biome>> climateData, Function<Climate.ParameterPoint, Climate.Parameter> extractor) {
                List<Climate.Parameter> params = climateData.m_186850_().stream().map(Pair::getFirst).map(extractor).toList();
                long min = params.stream().mapToLong(Climate.Parameter::f_186813_).min().orElse(0L);
                long max = params.stream().mapToLong(Climate.Parameter::f_186814_).max().orElse(0L);
                return new Climate.Parameter(Math.min(min, max), Math.max(min, max));
            }
        }
    }

    public class ClimateBuilder {
        private final BiomeLayerBuilder target;
        private final Holder<Biome> biome;
        @Nullable
        private Climate.Parameter temperature;
        @Nullable
        private Climate.Parameter humidity;
        @Nullable
        private Climate.Parameter continentalness;
        @Nullable
        private Climate.Parameter erosion;
        @Nullable
        private Climate.Parameter depth;
        @Nullable
        private Climate.Parameter weirdness;
        private long offset;

        private ClimateBuilder(BiomeLayerBuilder target, Holder<Biome> biome) {
            this.target = target;
            this.biome = biome;
            this.temperature = null;
            this.humidity = null;
            this.continentalness = null;
            this.erosion = null;
            this.depth = null;
            this.weirdness = null;
            this.offset = 0L;
        }

        public ClimateBuilder temperature(float temperature) {
            return this.temperature(temperature, temperature);
        }

        public ClimateBuilder temperature(float min, float max) {
            return this.temperature(new Climate.Parameter(Climate.m_186779_((float)min), Climate.m_186779_((float)max)));
        }

        public ClimateBuilder temperature(Climate.Parameter temperature) {
            this.temperature = temperature;
            return this;
        }

        public ClimateBuilder humidity(float humidity) {
            return this.humidity(humidity, humidity);
        }

        public ClimateBuilder humidity(float min, float max) {
            return this.humidity(new Climate.Parameter(Climate.m_186779_((float)min), Climate.m_186779_((float)max)));
        }

        public ClimateBuilder humidity(Climate.Parameter humidity) {
            this.humidity = humidity;
            return this;
        }

        public ClimateBuilder continentalness(float continentalness) {
            return this.continentalness(continentalness, continentalness);
        }

        public ClimateBuilder continentalness(float min, float max) {
            return this.continentalness(new Climate.Parameter(Climate.m_186779_((float)min), Climate.m_186779_((float)max)));
        }

        public ClimateBuilder continentalness(Climate.Parameter continentalness) {
            this.continentalness = continentalness;
            return this;
        }

        public ClimateBuilder erosion(float erosion) {
            return this.erosion(erosion, erosion);
        }

        public ClimateBuilder erosion(float min, float max) {
            return this.erosion(new Climate.Parameter(Climate.m_186779_((float)min), Climate.m_186779_((float)max)));
        }

        public ClimateBuilder erosion(Climate.Parameter erosion) {
            this.erosion = erosion;
            return this;
        }

        public ClimateBuilder depth(float depth) {
            return this.depth(depth, depth);
        }

        public ClimateBuilder depth(float min, float max) {
            return this.depth(new Climate.Parameter(Climate.m_186779_((float)min), Climate.m_186779_((float)max)));
        }

        public ClimateBuilder depth(Climate.Parameter depth) {
            this.depth = depth;
            return this;
        }

        public ClimateBuilder weirdness(float weirdness) {
            return this.weirdness(weirdness, weirdness);
        }

        public ClimateBuilder weirdness(float min, float max) {
            return this.weirdness(new Climate.Parameter(Climate.m_186779_((float)min), Climate.m_186779_((float)max)));
        }

        public ClimateBuilder weirdness(Climate.Parameter weirdness) {
            this.weirdness = weirdness;
            return this;
        }

        public ClimateBuilder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public BiomeLayerBuilder from(Climate.ParameterPoint climate) {
            this.target.biomes.add((Pair<Climate.ParameterPoint, Holder<Biome>>)Pair.of((Object)climate, this.biome));
            return this.target;
        }

        public BiomeLayerBuilder add() {
            Objects.requireNonNull(this.temperature, "Climate parameter unset: temperature");
            Objects.requireNonNull(this.humidity, "Climate parameter unset: humidity");
            Objects.requireNonNull(this.continentalness, "Climate parameter unset: continentalness");
            Objects.requireNonNull(this.erosion, "Climate parameter unset: erosion");
            Objects.requireNonNull(this.depth, "Climate parameter unset: depth");
            Objects.requireNonNull(this.weirdness, "Climate parameter unset: weirdness");
            this.target.biomes.add((Pair<Climate.ParameterPoint, Holder<Biome>>)Pair.of((Object)new Climate.ParameterPoint(this.temperature, this.humidity, this.continentalness, this.erosion, this.depth, this.weirdness, this.offset), this.biome));
            return this.target;
        }
    }
}

