/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.sandbox.datagen.ext.base;

import com.mojang.serialization.Codec;
import io.github.noeppi_noeppi.mods.sandbox.datagen.WorldGenProviderBase;
import io.github.noeppi_noeppi.mods.sandbox.datagen.ext.base.WorldGenData;
import io.github.noeppi_noeppi.mods.sandbox.datagen.registry.WorldGenRegistries;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.moddingx.libx.mod.ModX;

public abstract class BaseWorldGenData
implements WorldGenData {
    protected final ModX mod;
    private final WorldGenProviderBase provider;
    protected final WorldGenRegistries registries;
    protected final ExistingFileHelper fileHelper;

    public BaseWorldGenData(WorldGenData.Properties properties) {
        this.mod = properties.mod();
        this.provider = properties.provider();
        this.registries = properties.registries();
        this.fileHelper = properties.fileHelper();
    }

    protected final <A> Holder<A> holder(ResourceKey<? extends Registry<A>> key, String path) {
        return this.holder(key, this.mod.resource(path));
    }

    protected final <A> Holder<A> holder(ResourceKey<? extends Registry<A>> key, String namespace, String path) {
        return this.holder(key, new ResourceLocation(namespace, path));
    }

    protected final <A> Holder<A> holder(ResourceKey<? extends Registry<A>> key, ResourceLocation id) {
        return this.registries.holder(key, id);
    }

    protected final <A> HolderSet<A> tag(TagKey<A> key) {
        return this.registries.tag(key);
    }

    protected final <A extends WorldGenData> A resolve(Class<A> cls) {
        return this.provider.getData(cls);
    }

    protected final <A> Holder<A> holder(ResourceKey<A> key) {
        return this.registries.holder(ResourceKey.m_135788_((ResourceLocation)key.m_211136_()), key.m_135782_());
    }

    protected final <T> Holder<T> addToList(List<Holder<T>> list, Holder<T> elem) {
        if (elem.m_203376_() == Holder.Kind.DIRECT) {
            throw new IllegalArgumentException("Can't add direct holder to world gen data");
        }
        list.add(elem);
        return elem;
    }

    protected final <T> WorldGenData.Result<T> createResult(ResourceKey<? extends Registry<T>> key, Codec<T> codec, List<Holder<T>> elements) {
        return this.createResult(key, codec, elements, null);
    }

    protected final <T> WorldGenData.Result<T> createResult(ResourceKey<? extends Registry<T>> key, final Codec<T> codec, List<Holder<T>> elements, final @Nullable BiFunction<ResourceLocation, T, T> modify) {
        final String dataPackPath = BaseWorldGenData.defaultDataPackPath(key);
        final List<Holder<T>> theElements = List.copyOf(elements);
        return new WorldGenData.Result<T>(){

            @Override
            public Codec<T> codec() {
                return codec;
            }

            @Override
            public List<Holder<T>> elements() {
                return theElements;
            }

            @Override
            public T modify(ResourceLocation id, T value) {
                return modify == null ? value : modify.apply(id, value);
            }

            @Override
            public Path getPath(Path base, ResourceLocation id) {
                return base.resolve(PackType.SERVER_DATA.m_10305_()).resolve(id.m_135827_()).resolve(dataPackPath).resolve(id.m_135815_() + ".json");
            }
        };
    }

    private static String defaultDataPackPath(ResourceKey<? extends Registry<?>> key) {
        if (key.m_135782_().m_135827_().equals("minecraft")) {
            return key.m_135782_().m_135815_();
        }
        return key.m_135782_().m_135827_() + "/" + key.m_135782_().m_135815_();
    }
}

