/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.conductor;

import com.mojang.authlib.GameProfile;
import com.railwayteam.railways.content.conductor.ConductorCapItem;
import com.railwayteam.railways.content.conductor.toolbox.MountedToolbox;
import com.railwayteam.railways.registry.CREntities;
import com.railwayteam.railways.util.EntityUtils;
import com.railwayteam.railways.util.ItemUtils;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlock;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ConductorEntity
extends AbstractGolem {
    public static final GameProfile FAKE_PLAYER_PROFILE = new GameProfile(UUID.fromString("B0FADEE5-4411-3475-ADD0-C4EA7E30D050"), "[Conductor]");
    public static final WorldAttached<Set<ConductorEntity>> WITH_TOOLBOXES = new WorldAttached(w -> new HashSet());
    private static final EntityDataSerializer<Job> JOB_SERIALIZER = new EntityDataSerializer<Job>(){

        public void write(FriendlyByteBuf buf, @NotNull Job job) {
            buf.m_130068_((Enum)job);
        }

        @NotNull
        public Job read(FriendlyByteBuf buf) {
            return (Job)buf.m_130066_(Job.class);
        }

        @NotNull
        public Job copy(@NotNull Job job) {
            return job;
        }
    };
    public static final EntityDataAccessor<Byte> COLOR;
    public static final EntityDataAccessor<BlockPos> BLOCK;
    public static final EntityDataAccessor<Job> JOB;
    public static final EntityDataAccessor<Boolean> HOLDING_SCHEDULES;
    private static final Vec3i REACH;
    private ServerPlayer fakePlayer = null;
    MountedToolbox toolbox = null;
    private List<ItemStack> heldSchedules;

    private List<ItemStack> getHeldSchedules() {
        if (this.heldSchedules == null) {
            this.heldSchedules = new ArrayList<ItemStack>();
        }
        return this.heldSchedules;
    }

    public ConductorEntity(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.f_19793_ = 0.5f;
    }

    public boolean isHoldingSchedules() {
        return !this.getHeldSchedules().isEmpty();
    }

    public boolean isHoldingSchedulesClient() {
        return (Boolean)this.f_19804_.m_135370_(HOLDING_SCHEDULES);
    }

    public void addSchedule(ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        this.getHeldSchedules().add(stack.m_41777_());
        this.f_19804_.m_135381_(HOLDING_SCHEDULES, (Object)true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR, (Object)ConductorEntity.idFrom(ConductorEntity.defaultColor()));
        this.f_19804_.m_135372_(BLOCK, (Object)this.m_20183_());
        this.f_19804_.m_135372_(JOB, (Object)Job.DEFAULT);
        this.f_19804_.m_135372_(HOLDING_SCHEDULES, (Object)this.isHoldingSchedules());
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new ConductorLookedAtGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new ConductorPonderBlockGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new FollowToolboxPlayerGoal(this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22285_, 8.0);
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        super.m_142687_(reason);
        ((Set)WITH_TOOLBOXES.get((LevelAccessor)this.f_19853_)).remove((Object)this);
    }

    public void m_142036_() {
        ((Set)WITH_TOOLBOXES.get((LevelAccessor)this.f_19853_)).remove((Object)this);
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        LivingEntity living;
        Entity entity = pSource.m_7639_();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21205_().m_150930_((Item)AllItems.WRENCH.get())) {
            pAmount = 10.0f;
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected int m_7302_(int pAir) {
        return pAir;
    }

    protected float m_6431_(@NotNull Pose pPose, @NotNull EntityDimensions pDimensions) {
        return pDimensions.f_20378_ * 0.76f;
    }

    public boolean canReach(Vec3i pos) {
        return pos.m_203193_((Position)this.m_20182_()) <= REACH.m_123331_(Vec3i.f_123288_);
    }

    protected boolean isToolbox(ItemStack stack) {
        BlockItem blockItem;
        Item item = stack.m_41720_();
        return item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof ToolboxBlock;
    }

    public boolean isCarryingToolbox() {
        return this.toolbox != null;
    }

    public ItemStack getToolboxDisplayStack() {
        if (this.isCarryingToolbox()) {
            return this.toolbox.getDisplayStack();
        }
        return ItemStack.f_41583_;
    }

    protected void setToolbox(@Nullable MountedToolbox toolbox) {
        this.toolbox = toolbox;
        if (toolbox != null) {
            ((Set)WITH_TOOLBOXES.get((LevelAccessor)this.f_19853_)).add(this);
        } else {
            ((Set)WITH_TOOLBOXES.get((LevelAccessor)this.f_19853_)).remove((Object)this);
        }
    }

    @Nullable
    public MountedToolbox getToolbox() {
        return this.toolbox;
    }

    @NotNull
    public MountedToolbox getOrCreateToolboxHolder() {
        if (!this.isCarryingToolbox()) {
            this.setToolbox(new MountedToolbox(this, DyeColor.BROWN));
        }
        return this.toolbox;
    }

    public void equipToolbox(ItemStack stack) {
        BlockItem blockItem;
        Item item = stack.m_41720_();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof ToolboxBlock) {
            ToolboxBlock toolbox = (ToolboxBlock)item;
            this.setToolbox(new MountedToolbox(this, toolbox.getColor()));
            this.toolbox.readFromItem(stack);
            this.toolbox.sendData();
            this.m_20088_().m_135381_(JOB, (Object)Job.TOOLBOX_CARRIER);
        }
    }

    public void m_6457_(@NotNull ServerPlayer pServerPlayer) {
        super.m_6457_(pServerPlayer);
        if (this.toolbox != null) {
            this.toolbox.sendData();
        }
    }

    public ItemStack unequipToolbox() {
        this.m_20088_().m_135381_(JOB, (Object)Job.DEFAULT);
        if (this.f_19853_.f_46443_ || this.toolbox == null) {
            if (this.toolbox != null) {
                this.toolbox.m_7651_();
            }
            this.setToolbox(null);
            return ItemStack.f_41583_;
        }
        this.toolbox.unequipTracked();
        ItemStack itemStack = this.toolbox.getCloneItemStack();
        this.toolbox.m_7651_();
        this.setToolbox(null);
        return itemStack;
    }

    protected void openToolbox(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MountedToolbox.openMenu(serverPlayer, this.toolbox);
        }
    }

    @NotNull
    protected InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        Item item = player.m_21120_(hand).m_41720_();
        if (item instanceof DyeItem) {
            DyeItem di = (DyeItem)item;
            this.setColor(di.m_41089_());
            if (!player.m_7500_()) {
                player.m_21120_(hand).m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_21120_(hand).m_41720_().equals(AllBlocks.ANDESITE_CASING.asStack().m_41720_())) {
            if (this.m_21223_() != this.m_21233_()) {
                this.m_21153_(this.m_21223_() + 1.0f);
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        } else {
            if (!this.isCarryingToolbox() && this.isToolbox(player.m_21120_(hand))) {
                this.equipToolbox(player.m_21120_(hand));
                player.m_21120_(hand).m_41774_(1);
                return InteractionResult.SUCCESS;
            }
            if (this.isCarryingToolbox()) {
                if (player.m_6144_() && player.m_21120_(hand).m_41619_()) {
                    player.m_21008_(hand, this.unequipToolbox());
                } else if (!this.f_19853_.f_46443_) {
                    this.openToolbox(player);
                }
                return InteractionResult.SUCCESS;
            }
            if (player.m_21120_(hand).m_41619_() && !this.getHeldSchedules().isEmpty()) {
                for (ItemStack item2 : this.heldSchedules) {
                    if (player.m_36356_(item2)) continue;
                    player.m_36176_(item2, false);
                }
                this.f_19804_.m_135381_(HOLDING_SCHEDULES, (Object)false);
            }
        }
        return super.m_6071_(player, hand);
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (this.fakePlayer == null && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.fakePlayer = EntityUtils.createConductorFakePlayer(serverLevel);
        }
        if (this.toolbox != null) {
            this.toolbox.tick();
        }
    }

    public static ConductorEntity spawn(Level level, BlockPos pos, ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof ConductorCapItem)) {
            return null;
        }
        ConductorCapItem cap = (ConductorCapItem)item;
        ConductorEntity result = new ConductorEntity((EntityType<? extends AbstractGolem>)((EntityType)CREntities.CONDUCTOR.get()), level);
        result.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        result.setColor(cap.color);
        result.m_21540_(stack);
        level.m_7967_((Entity)result);
        return result;
    }

    public boolean isInMinecart() {
        return this.m_20202_() instanceof AbstractMinecart;
    }

    public static DyeColor defaultColor() {
        return DyeColor.BLUE;
    }

    public void setColor(DyeColor color) {
        this.m_20088_().m_135381_(COLOR, (Object)ConductorEntity.idFrom(color));
    }

    public DyeColor getColor() {
        return ConductorEntity.colorFrom((Byte)this.f_19804_.m_135370_(COLOR));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCorrectEngineerCap(ItemStack hat) {
        if (hat.m_41619_()) {
            return true;
        }
        Item item = hat.m_41720_();
        if (!(item instanceof ConductorCapItem)) return false;
        ConductorCapItem cap = (ConductorCapItem)item;
        if (cap.color != this.getColor()) return false;
        return true;
    }

    boolean isLookingAtMe(Player player) {
        if (player.m_5833_()) {
            return false;
        }
        boolean looking = false;
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        if (this.isCorrectEngineerCap(helmet) || !ItemUtils.blocksEndermanView(helmet, player, null)) {
            Vec3 headLine;
            Vec3 playerView = player.m_20252_(1.0f).m_82541_();
            double angle = playerView.m_82526_(headLine = this.m_146892_().m_82546_(player.m_146892_()).m_82541_());
            looking = angle > 0.983 && player.m_142582_((Entity)this);
        }
        return looking;
    }

    public static DyeColor colorFrom(byte b) {
        if (b >= 16) {
            return null;
        }
        return DyeColor.m_41053_((int)b);
    }

    public static byte idFrom(DyeColor color) {
        int c = color.m_41060_();
        if (c >= 16) {
            return 16;
        }
        return (byte)c;
    }

    public boolean canUseBlock(BlockState state) {
        return state.m_204336_(BlockTags.f_13093_) || state.m_60713_(Blocks.f_50164_);
    }

    protected void m_7472_(@NotNull DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        ItemStack holdingStack = this.unequipToolbox();
        if (!holdingStack.m_41619_()) {
            this.m_19983_(holdingStack);
        }
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("target", (Tag)NbtUtils.m_129224_((BlockPos)((BlockPos)this.m_20088_().m_135370_(BLOCK))));
        nbt.m_128344_("color", ((Byte)this.m_20088_().m_135370_(COLOR)).byteValue());
        if (this.toolbox != null) {
            CompoundTag toolboxTag = new CompoundTag();
            this.toolbox.write(toolboxTag, false);
            nbt.m_128365_("toolboxHolder", (Tag)toolboxTag);
        }
        if (this.getHeldSchedules().size() != 0) {
            ListTag schedulesTag = new ListTag();
            boolean hasItem = false;
            for (ItemStack heldSchedule : this.heldSchedules) {
                if (heldSchedule.m_41619_()) continue;
                schedulesTag.add((Object)heldSchedule.m_41739_(new CompoundTag()));
                hasItem = true;
            }
            if (hasItem) {
                nbt.m_128365_("heldSchedules", (Tag)schedulesTag);
            }
        }
        nbt.m_128359_("job", ((Job)((Object)this.m_20088_().m_135370_(JOB))).name());
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("color", 1)) {
            this.m_20088_().m_135381_(COLOR, (Object)nbt.m_128445_("color"));
        }
        if (nbt.m_128425_("target", 10)) {
            this.m_20088_().m_135381_(BLOCK, (Object)NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("target")));
        }
        if (nbt.m_128425_("toolboxHolder", 10)) {
            this.setToolbox(MountedToolbox.read(this, nbt.m_128469_("toolboxHolder")));
        } else {
            this.setToolbox(null);
        }
        if (nbt.m_128425_("job", 8)) {
            this.m_20088_().m_135381_(JOB, (Object)Job.valueOf(nbt.m_128461_("job")));
        } else {
            this.m_20088_().m_135381_(JOB, (Object)Job.DEFAULT);
        }
        this.getHeldSchedules().clear();
        if (nbt.m_128425_("heldSchedules", 9)) {
            ListTag schedulesTag = nbt.m_128437_("heldSchedules", 10);
            for (int i = 0; i < schedulesTag.size(); ++i) {
                ItemStack stack = ItemStack.m_41712_((CompoundTag)schedulesTag.m_128728_(i));
                if (stack.m_41619_()) continue;
                this.getHeldSchedules().add(stack);
            }
        }
        if (!this.f_19853_.f_46443_) {
            this.m_20088_().m_135381_(HOLDING_SCHEDULES, (Object)this.isHoldingSchedules());
        }
    }

    static {
        EntityDataSerializers.m_135050_(JOB_SERIALIZER);
        COLOR = SynchedEntityData.m_135353_(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        BLOCK = SynchedEntityData.m_135353_(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
        JOB = SynchedEntityData.m_135353_(ConductorEntity.class, JOB_SERIALIZER);
        HOLDING_SCHEDULES = SynchedEntityData.m_135353_(ConductorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        REACH = new Vec3i(3, 2, 3);
    }

    public static enum Job {
        REDSTONE_OPERATOR,
        TOOLBOX_CARRIER;

        public static final Job DEFAULT;

        static {
            DEFAULT = REDSTONE_OPERATOR;
        }
    }

    static class ConductorLookedAtGoal
    extends JobBasedGoal {
        @Nullable
        private LivingEntity target;

        public ConductorLookedAtGoal(ConductorEntity conductor) {
            super(conductor, Job.REDSTONE_OPERATOR);
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            for (Player player : this.conductor.f_19853_.m_6907_()) {
                if (!player.m_142582_((Entity)this.conductor)) continue;
                return this.conductor.m_20280_((Entity)player) < 256.0 && this.conductor.isLookingAtMe(player);
            }
            return false;
        }

        public void m_8056_() {
            Level level = this.conductor.f_19853_;
            BlockPos pos = (BlockPos)this.conductor.m_20088_().m_135370_(BLOCK);
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            ServerPlayer fake = this.conductor.fakePlayer;
            if (this.conductor.canReach((Vec3i)pos) && this.conductor.canUseBlock(state) && fake != null) {
                boolean canUse;
                ClipContext context = new ClipContext(this.conductor.m_146892_(), new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)fake);
                BlockHitResult hitResult = level.m_45547_(context);
                if (!pos.equals((Object)hitResult.m_82425_())) {
                    return;
                }
                boolean bl = canUse = state.m_60808_((BlockGetter)level, pos).m_83281_() || EntityUtils.handleUseEvent((Player)fake, InteractionHand.MAIN_HAND, hitResult);
                if (canUse) {
                    state.m_60664_(level, (Player)fake, InteractionHand.MAIN_HAND, hitResult);
                }
            }
        }

        public void m_8037_() {
            if (this.target != null) {
                this.conductor.f_21365_.m_148051_((Entity)this.target);
            }
        }
    }

    static class ConductorPonderBlockGoal
    extends JobBasedGoal {
        private BlockPos target;

        public ConductorPonderBlockGoal(ConductorEntity conductor) {
            super(conductor, Job.REDSTONE_OPERATOR);
            this.target = (BlockPos)conductor.f_19804_.m_135370_(BLOCK);
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            this.target = (BlockPos)this.conductor.f_19804_.m_135370_(BLOCK);
            if (this.conductor.canReach((Vec3i)this.target) && this.conductor.canUseBlock(this.conductor.f_19853_.m_8055_(this.target))) {
                return true;
            }
            for (int y = -REACH.m_123342_(); y < REACH.m_123342_(); ++y) {
                for (int x = -REACH.m_123341_(); x < REACH.m_123341_(); ++x) {
                    for (int z = -REACH.m_123343_(); z < REACH.m_123343_(); ++z) {
                        ClipContext context;
                        BlockHitResult hitResult;
                        BlockPos at = this.conductor.m_20183_().m_7918_(x, y, z);
                        BlockState state = this.conductor.f_19853_.m_8055_(at);
                        if (!this.conductor.canUseBlock(state) || !(hitResult = this.conductor.f_19853_.m_45547_(context = new ClipContext(this.conductor.m_146892_(), new Vec3((double)at.m_123341_(), (double)at.m_123342_(), (double)at.m_123343_()), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, null))).m_82425_().equals((Object)at)) continue;
                        this.target = at;
                        this.conductor.f_19804_.m_135381_(BLOCK, (Object)this.target);
                        return true;
                    }
                }
            }
            return false;
        }

        public void m_8056_() {
        }

        public void m_8037_() {
            this.conductor.f_21365_.m_24946_((double)this.target.m_123341_(), (double)this.target.m_123342_(), (double)this.target.m_123343_());
        }
    }

    static class FollowToolboxPlayerGoal
    extends JobBasedGoal {
        protected final double speedModifier;
        @Nullable
        protected Player target;
        protected int timeToRecalcPath;

        public FollowToolboxPlayerGoal(ConductorEntity conductor, double speedModifier) {
            super(conductor, Job.TOOLBOX_CARRIER);
            this.speedModifier = speedModifier;
        }

        public void m_8037_() {
            super.m_8037_();
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                if (this.conductor.m_20280_((Entity)this.target) > 16.0) {
                    this.conductor.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
                } else {
                    this.conductor.m_21573_().m_26573_();
                }
            }
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && this.conductor.isCarryingToolbox() && !this.conductor.getToolbox().getConnectedPlayers().isEmpty();
        }

        @Override
        public boolean m_8045_() {
            return super.m_8045_() && this.conductor.isCarryingToolbox() && this.conductor.getToolbox().getConnectedPlayers().contains(this.target) && this.target.m_6084_() && !this.target.m_5833_();
        }

        public void m_8056_() {
            super.m_8056_();
            List<Player> players = this.conductor.getToolbox().getConnectedPlayers();
            this.target = players.get(this.conductor.f_19796_.m_188503_(players.size()));
        }

        public void m_8041_() {
            super.m_8041_();
            this.target = null;
        }
    }

    static class JobBasedGoal
    extends Goal {
        private final Job job;
        protected final ConductorEntity conductor;

        public JobBasedGoal(ConductorEntity conductor, Job job) {
            this.conductor = conductor;
            this.job = job;
        }

        public boolean m_8036_() {
            return this.conductor.m_20088_().m_135370_(JOB) == this.job;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }
    }
}

