/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.switches;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.switches.TrackSwitch;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.content.switches.TrackSwitchTileEntity;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.util.CustomTrackOverlayRendering;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Color;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TrackSwitchRenderer
extends SmartBlockEntityRenderer<TrackSwitchTileEntity> {
    public TrackSwitchRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
    }

    protected void renderSafe(TrackSwitchTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        Level level;
        super.renderSafe((SmartBlockEntity)te, partialTicks, ms, buffer, light, overlay);
        this.renderFlagState(te, partialTicks, ms, buffer, light);
        this.renderTrackOverlay(te, ms, buffer, light, overlay, te.edgePoint);
        if (te.ponderData != null && (level = te.m_58904_()) instanceof PonderWorld) {
            PonderWorld ponderWorld = (PonderWorld)level;
            this.renderPonderData(ponderWorld, te.getState(), te.ponderData, partialTicks, ms, buffer, light, overlay);
        }
    }

    private void renderPonderData(PonderWorld ponderWorld, TrackSwitchBlock.SwitchState state, TrackSwitchTileEntity.PonderData ponderData, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        ms.m_85836_();
        Vec3 offset = new Vec3(0.0, 0.4, 0.0);
        float width = 0.0625f;
        Vec3 from = ponderData.basePos();
        for (Map.Entry<TrackSwitchBlock.SwitchState, Vec3> to : ponderData.getBranches().entrySet()) {
            boolean active = to.getKey() == state;
            ponderWorld.scene.getOutliner().showLine(to, from.m_82549_(offset), to.getValue().m_82549_(offset)).colored(active ? new Color(0, 203, 150) : new Color(255, 50, 150)).lineWidth(width);
        }
        ms.m_85849_();
    }

    private void renderFlagState(TrackSwitchTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
        BlockState state = te.m_58900_();
        ms.m_85836_();
        float yRot = AngleHelper.horizontalAngle((Direction)((Direction)state.m_61143_((Property)TrackSwitchBlock.f_54117_)));
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        ((TransformStack)((TransformStack)msr.centre()).rotateY((double)yRot)).unCentre();
        if (te.isAutomatic()) {
            ms.m_85836_();
            ms.m_85837_(0.0, -0.125, 0.0);
            SuperByteBuffer buf = CachedBufferer.partial((PartialModel)CRBlockPartials.BRASS_SWITCH_FLAG, (BlockState)state).light(light).rotateCentered(Direction.UP, 1.5708f).translate(0.5, 0.53125, 0.5);
            if (te.isReverseLeft() || te.isNormal() && te.exitCount == 2 && te.hasExit(TrackSwitchBlock.SwitchState.REVERSE_RIGHT)) {
                te.lerpedAngle.updateChaseTarget(-1.1f);
            } else if (te.isReverseRight() || te.isNormal() && te.exitCount == 2 && te.hasExit(TrackSwitchBlock.SwitchState.REVERSE_LEFT)) {
                te.lerpedAngle.updateChaseTarget(1.1f);
            } else {
                te.lerpedAngle.updateChaseTarget(0.0f);
            }
            buf = (SuperByteBuffer)buf.rotate(Direction.NORTH, te.lerpedAngle.getValue(partialTicks));
            buf.translate(-0.5, -0.46875, -0.5).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
            ms.m_85849_();
        } else {
            SuperByteBuffer buf = CachedBufferer.partial((PartialModel)CRBlockPartials.ANDESITE_SWITCH_FLAG, (BlockState)state).light(light);
            if (te.isReverseLeft()) {
                te.lerpedAngle.updateChaseTarget(1.5708f);
            } else if (te.isReverseRight()) {
                te.lerpedAngle.updateChaseTarget(-1.5708f);
            } else {
                te.lerpedAngle.updateChaseTarget(0.0f);
            }
            buf = buf.rotateCentered(Direction.UP, te.lerpedAngle.getValue(partialTicks));
            buf.renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
            CachedBufferer.partial((PartialModel)CRBlockPartials.ANDESITE_SWITCH_HANDLE, (BlockState)state).light(light).rotateCentered(Direction.UP, -1.5708f).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        }
        ms.m_85849_();
    }

    private void renderTrackOverlay(TrackSwitchTileEntity te, PoseStack ms, MultiBufferSource buffer, int light, int overlay, TrackTargetingBehaviour<TrackSwitch> target) {
        BlockPos pos = te.m_58899_();
        boolean offsetToSide = CustomTrackOverlayRendering.overlayWillOverlap(target);
        BlockPos targetPosition = target.getGlobalPosition();
        Level level = te.m_58904_();
        BlockState trackState = level.m_8055_(targetPosition);
        Block block = trackState.m_60734_();
        if (!(block instanceof ITrackBlock)) {
            return;
        }
        ms.m_85836_();
        TransformStack.cast((PoseStack)ms).translate((Vec3i)targetPosition.m_121996_((Vec3i)pos));
        CustomTrackOverlayRendering.renderOverlay((LevelAccessor)level, targetPosition, target.getTargetDirection(), target.getTargetBezier(), ms, buffer, light, overlay, te.getOverlayModel(), 1.0f, offsetToSide);
        ms.m_85849_();
    }
}

