/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class RegexCache {
    private static final Map<String, Predicate<String>> patternCache = new Object2ObjectOpenHashMap();

    public static Predicate<String> buildPredicate(String possiblePattern) {
        return RegexCache.isRegexPattern(possiblePattern) ? patternCache.computeIfAbsent(possiblePattern, x -> Pattern.compile(x).asMatchPredicate()) : possiblePattern::equals;
    }

    public static boolean isRegexPattern(String pattern) {
        String specialChars = ".?*+^$[](){}|\\";
        for (int i = 0; i < pattern.length(); ++i) {
            if (specialChars.indexOf(pattern.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    static {
        String[] matchAny = new String[]{".", "[a-z0-9/._-]"};
        String[] suffixes = new String[]{"+", "*"};
        for (String s : matchAny) {
            for (String suffix : suffixes) {
                patternCache.put(s + suffix, s1 -> true);
                patternCache.put("^" + s + suffix, s1 -> true);
                patternCache.put("^" + s + suffix + "$", s1 -> true);
                patternCache.put(s + suffix + "$", s1 -> true);
            }
        }
    }
}

