/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.registry;

import ca.teamdman.sfm.common.compat.SFMCompat;
import ca.teamdman.sfm.common.compat.SFMMekanismCompat;
import ca.teamdman.sfm.common.resourcetype.FluidResourceType;
import ca.teamdman.sfm.common.resourcetype.ForgeEnergyResourceType;
import ca.teamdman.sfm.common.resourcetype.ItemResourceType;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class SFMResourceTypes {
    public static final ResourceLocation REGISTRY_ID = new ResourceLocation("sfm", "resource_type");
    private static final DeferredRegister<ResourceType<?, ?, ?>> TYPES = DeferredRegister.create((ResourceLocation)REGISTRY_ID, (String)"sfm");
    public static final Supplier<IForgeRegistry<ResourceType<?, ?, ?>>> DEFERRED_TYPES = TYPES.makeRegistry(() -> new RegistryBuilder().setName(REGISTRY_ID));
    public static final RegistryObject<ResourceType<ItemStack, Item, IItemHandler>> ITEM = TYPES.register("item", ItemResourceType::new);
    public static final RegistryObject<ResourceType<FluidStack, Fluid, IFluidHandler>> FLUID = TYPES.register("fluid", FluidResourceType::new);
    public static final RegistryObject<ResourceType<Integer, Class<Integer>, IEnergyStorage>> FORGE_ENERGY = TYPES.register("forge_energy", ForgeEnergyResourceType::new);
    private static final Int2ObjectArrayMap<ResourceType<?, ?, ?>> DEFERRED_TYPES_BY_ID = new Int2ObjectArrayMap();

    public static ResourceType<?, ?, ?> fastLookup(String resourceTypeNamespace, String resourceTypeName) {
        return Objects.requireNonNull((ResourceType)DEFERRED_TYPES_BY_ID.computeIfAbsent(resourceTypeNamespace.hashCode() ^ resourceTypeName.hashCode(), i -> (ResourceType)DEFERRED_TYPES.get().getValue(new ResourceLocation(resourceTypeNamespace, resourceTypeName))));
    }

    public static void register(IEventBus bus) {
        TYPES.register(bus);
    }

    static {
        if (SFMCompat.isMekanismLoaded()) {
            SFMMekanismCompat.register(TYPES);
        }
    }
}

