/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.cablenetwork;

import ca.teamdman.sfm.common.cablenetwork.CapabilityProviderMapper;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CauldronCapabilityProviderMapper
implements CapabilityProviderMapper {
    @Override
    public Optional<ICapabilityProvider> getProviderFor(LevelAccessor level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() == Blocks.f_50256_ || state.m_60734_() == Blocks.f_152476_ || state.m_60734_() == Blocks.f_152477_) {
            return Optional.of(new CauldronCapabilityProvider(level, pos));
        }
        return Optional.empty();
    }

    private static class CauldronCapabilityProvider
    implements ICapabilityProvider {
        private final LazyOptional<IFluidHandler> fluidHandlerLazyOptional = LazyOptional.of(() -> new CauldronFluidHandler(level, pos));

        public CauldronCapabilityProvider(LevelAccessor level, BlockPos pos) {
        }

        @Nonnull
        @NotNull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == ForgeCapabilities.FLUID_HANDLER) {
                return this.fluidHandlerLazyOptional.cast();
            }
            return LazyOptional.empty();
        }
    }

    private record CauldronFluidHandler(LevelAccessor level, BlockPos pos) implements IFluidHandler
    {
        public int getTanks() {
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            BlockState state = this.level.m_8055_(this.pos);
            if (state.m_60734_() == Blocks.f_152476_) {
                int level = (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
                if (level == 0) {
                    return FluidStack.EMPTY;
                }
                return new FluidStack((Fluid)Fluids.f_76193_, level * 250);
            }
            if (state.m_60734_() == Blocks.f_152477_) {
                return new FluidStack((Fluid)Fluids.f_76195_, 1000);
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return stack.getFluid() == Fluids.f_76193_ || stack.getFluid() == Fluids.f_76195_;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            BlockState state = this.level.m_8055_(this.pos);
            if (state.m_60734_() == Blocks.f_50256_) {
                if (resource.getFluid() == Fluids.f_76193_) {
                    int layers = Math.min(3, resource.getAmount() / 250);
                    if (action.execute()) {
                        this.level.m_7731_(this.pos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(layers)), 3);
                    }
                    return layers * 250;
                }
                if (resource.getFluid() == Fluids.f_76195_ && resource.getAmount() >= 1000) {
                    if (action.execute()) {
                        this.level.m_7731_(this.pos, Blocks.f_152477_.m_49966_(), 3);
                    }
                    return 1000;
                }
            } else if (state.m_60734_() instanceof LayeredCauldronBlock) {
                int waterLevel = (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
                if (waterLevel >= 3) {
                    return 0;
                }
                int waterLevelIncrease = Math.min(3 - waterLevel, Math.min(3, resource.getAmount() / 250));
                if (action.execute()) {
                    this.level.m_7731_(this.pos, (BlockState)state.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(waterLevel + waterLevelIncrease)), 3);
                }
                return waterLevelIncrease * 250;
            }
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            BlockState state = this.level.m_8055_(this.pos);
            if (state.m_60734_() instanceof LayeredCauldronBlock) {
                int waterLevel = (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
                if (waterLevel == 0) {
                    return FluidStack.EMPTY;
                }
                int waterLevelDrain = Math.min(waterLevel, resource.getAmount() / 250);
                if (action.execute()) {
                    int resultLevel = waterLevel - waterLevelDrain;
                    if (resultLevel == 0) {
                        this.level.m_7731_(this.pos, Blocks.f_50256_.m_49966_(), 3);
                    } else {
                        this.level.m_7731_(this.pos, (BlockState)state.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(resultLevel)), 3);
                    }
                }
                return new FluidStack((Fluid)Fluids.f_76193_, waterLevelDrain * 250);
            }
            if (state.m_60734_() == Blocks.f_152477_ && resource.getAmount() >= 1000) {
                if (action.execute()) {
                    this.level.m_7731_(this.pos, Blocks.f_50256_.m_49966_(), 3);
                }
                return new FluidStack((Fluid)Fluids.f_76195_, 1000);
            }
            return FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            BlockState state = this.level.m_8055_(this.pos);
            if (state.m_60734_() instanceof LayeredCauldronBlock) {
                int waterLevel = (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_);
                if (waterLevel == 0) {
                    return FluidStack.EMPTY;
                }
                int waterLevelDrain = Math.min(waterLevel, maxDrain / 250);
                if (action.execute()) {
                    this.level.m_7731_(this.pos, (BlockState)state.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(waterLevel - waterLevelDrain)), 3);
                }
                return new FluidStack((Fluid)Fluids.f_76193_, waterLevelDrain * 250);
            }
            if (state.m_60734_() == Blocks.f_152477_ && maxDrain >= 1000) {
                if (action.execute()) {
                    this.level.m_7731_(this.pos, Blocks.f_50256_.m_49966_(), 3);
                }
                return new FluidStack((Fluid)Fluids.f_76195_, 1000);
            }
            return FluidStack.EMPTY;
        }
    }
}

