/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.program.InputResourceTracker;
import ca.teamdman.sfm.common.program.OutputResourceTracker;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceQuantity;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;

public record ResourceLimit<STACK, ITEM, CAP>(ResourceIdentifier<STACK, ITEM, CAP> resourceId, Limit limit) implements ASTNode,
Predicate<Object>
{
    public static final ResourceLimit<?, ?, ?> TAKE_ALL_LEAVE_NONE = new ResourceLimit(ResourceIdentifier.MATCH_ALL, Limit.MAX_QUANTITY_NO_RETENTION);
    public static final ResourceLimit<?, ?, ?> ACCEPT_ALL_WITHOUT_RESTRAINT = new ResourceLimit(ResourceIdentifier.MATCH_ALL, Limit.MAX_QUANTITY_MAX_RETENTION);

    public ResourceLimit<STACK, ITEM, CAP> withDefaults(Limit defaults) {
        return new ResourceLimit<STACK, ITEM, CAP>(this.resourceId, this.limit.withDefaults(defaults));
    }

    public ResourceLimit<STACK, ITEM, CAP> withLimit(Limit limit) {
        return new ResourceLimit<STACK, ITEM, CAP>(this.resourceId, limit);
    }

    public void gatherInputTrackers(Consumer<InputResourceTracker<?, ?, ?>> gatherer, ResourceIdSet exclusions) {
        if (this.limit.quantity().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.NO_EXPAND) {
            if (this.limit.retention().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.NO_EXPAND) {
                gatherer.accept(new InputResourceTracker(this, exclusions, new AtomicLong(0L), new AtomicLong(0L)));
            } else if (this.limit.retention().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.EXPAND) {
                AtomicLong quantity = new AtomicLong(0L);
                this.resourceId.expand().forEach(rid -> gatherer.accept(new InputResourceTracker<STACK, ITEM, CAP>(new ResourceLimit<STACK, ITEM, CAP>(rid, this.limit), exclusions, quantity, new AtomicLong(0L))));
            }
        } else if (this.limit.quantity().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.EXPAND) {
            if (this.limit.retention().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.NO_EXPAND) {
                AtomicLong retention = new AtomicLong(0L);
                this.resourceId.expand().forEach(rid -> gatherer.accept(new InputResourceTracker<STACK, ITEM, CAP>(new ResourceLimit<STACK, ITEM, CAP>(rid, this.limit), exclusions, new AtomicLong(0L), retention)));
            } else if (this.limit.retention().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.EXPAND) {
                this.resourceId.expand().forEach(rid -> gatherer.accept(new InputResourceTracker<STACK, ITEM, CAP>(new ResourceLimit<STACK, ITEM, CAP>(rid, this.limit), exclusions, new AtomicLong(0L), new AtomicLong(0L))));
            }
        }
    }

    public void gatherOutputTrackers(Consumer<OutputResourceTracker<?, ?, ?>> gatherer, ResourceIdSet exclusions) {
        if (this.limit.quantity().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.NO_EXPAND) {
            if (this.limit.retention().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.NO_EXPAND) {
                gatherer.accept(new OutputResourceTracker(this, exclusions, new AtomicLong(0L), new AtomicLong(0L)));
            } else if (this.limit.retention().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.EXPAND) {
                AtomicLong quantity = new AtomicLong(0L);
                this.resourceId.expand().forEach(rid -> gatherer.accept(new OutputResourceTracker<STACK, ITEM, CAP>(new ResourceLimit<STACK, ITEM, CAP>(rid, this.limit), exclusions, quantity, new AtomicLong(0L))));
            }
        } else if (this.limit.quantity().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.EXPAND) {
            if (this.limit.retention().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.NO_EXPAND) {
                AtomicLong retained = new AtomicLong(0L);
                this.resourceId.expand().forEach(rid -> gatherer.accept(new OutputResourceTracker<STACK, ITEM, CAP>(new ResourceLimit<STACK, ITEM, CAP>(rid, this.limit), exclusions, new AtomicLong(0L), retained)));
            } else if (this.limit.retention().idExpansionBehaviour() == ResourceQuantity.IdExpansionBehaviour.EXPAND) {
                this.resourceId.expand().forEach(rid -> gatherer.accept(new OutputResourceTracker<STACK, ITEM, CAP>(new ResourceLimit<STACK, ITEM, CAP>(rid, this.limit), exclusions, new AtomicLong(0L), new AtomicLong(0L))));
            }
        }
    }

    @Override
    public boolean test(Object stack) {
        return this.resourceId.test(stack);
    }

    @Override
    public String toString() {
        return this.limit + " " + this.resourceId;
    }

    public String toStringCondensed(Limit defaults) {
        return (this.limit.toStringCondensed(defaults) + " " + this.resourceId.toStringCondensed()).trim();
    }
}

