/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.brewery;

import de.melanx.utilitix.recipe.BreweryRecipe;
import de.melanx.utilitix.recipe.PotionOutput;
import de.melanx.utilitix.registration.ModItemTags;
import de.melanx.utilitix.registration.ModItems;
import de.melanx.utilitix.registration.ModRecipeTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.moddingx.libx.base.tile.BlockEntityBase;
import org.moddingx.libx.base.tile.TickingBlock;
import org.moddingx.libx.capability.ItemCapabilities;
import org.moddingx.libx.crafting.recipe.RecipeHelper;
import org.moddingx.libx.inventory.BaseItemStackHandler;
import org.moddingx.libx.inventory.VanillaWrapper;

public class TileAdvancedBrewery
extends BlockEntityBase
implements TickingBlock {
    public static final int MAX_BREW_TIME = 400;
    private int brewTime = 0;
    private int fuel = 0;
    private final BaseItemStackHandler inventory = BaseItemStackHandler.builder((int)5).contentsChanged(slot -> {
        this.m_6596_();
        this.setDispatchable();
    }).validator(stack -> this.f_58857_ != null && RecipeHelper.isItemValidInput((RecipeManager)this.f_58857_.m_7465_(), ModRecipeTypes.BREWERY, (ItemStack)stack), new int[]{0}).validator(stack -> stack.m_204117_(ModItemTags.BOTTLES), new int[]{1, 2, 3}).validator(stack -> stack.m_41720_() == Items.f_42593_, new int[]{4}).slotLimit(1, new int[]{1, 2, 3}).build();
    private final Container vanilla = new VanillaWrapper((IItemHandlerModifiable)this.inventory, () -> ((TileAdvancedBrewery)this).m_6596_());
    private final LazyOptional<IItemHandler> inventoryTop = ItemCapabilities.create(this::getInventory, slot -> false, (slot, stack) -> slot == 0 || slot == 3).cast();
    private final LazyOptional<IItemHandler> inventorySide = ItemCapabilities.create(this::getInventory, slot -> false, (slot, stack) -> slot == 1 || slot == 2 || slot == 4).cast();
    private final LazyOptional<IItemHandler> inventoryBottom = ItemCapabilities.create(this::getInventory, slot -> slot == 0 || slot == 1 || slot == 2, (slot, stack) -> false).cast();

    public TileAdvancedBrewery(BlockEntityType<?> blockEntityTypeIn, BlockPos pos, BlockState state) {
        super(blockEntityTypeIn, pos, state);
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ItemStack fuelStack;
            if (this.fuel <= 0 && (fuelStack = this.inventory.getStackInSlot(4)).m_41720_() == Items.f_42593_ && !fuelStack.m_41619_()) {
                this.fuel = 20;
                ItemStack fuelNew = fuelStack.m_41777_();
                fuelNew.m_41774_(1);
                this.inventory.setStackInSlot(4, fuelNew);
                this.m_6596_();
                this.setDispatchable();
            }
            BreweryRecipe recipe = this.f_58857_.m_7465_().m_44015_(ModRecipeTypes.BREWERY, this.vanilla, this.f_58857_).orElse(null);
            if ((this.fuel <= 0 || recipe == null) && this.brewTime > 0) {
                this.brewTime = 0;
                this.m_6596_();
                this.setDispatchable();
            } else if (recipe != null && this.fuel >= 0) {
                if (this.brewTime <= 0) {
                    this.setDispatchable();
                }
                this.brewTime = Mth.m_14045_((int)(this.brewTime + 1), (int)0, (int)400);
                if (this.brewTime >= 400) {
                    PotionOutput output = recipe.getPotionResult(this.vanilla);
                    if (output == null || output.getMain().m_41619_()) {
                        this.consumeItem(3);
                    } else {
                        this.inventory.setStackInSlot(3, output.getMain());
                    }
                    this.consumeItem(0);
                    if (output == null || output.getOut1().m_41619_()) {
                        this.consumeItem(1);
                    } else {
                        this.inventory.setStackInSlot(1, output.getOut1());
                    }
                    if (output == null || output.getOut2().m_41619_()) {
                        this.consumeItem(2);
                    } else {
                        this.inventory.setStackInSlot(2, output.getOut2());
                    }
                    this.brewTime = 0;
                    --this.fuel;
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.setDispatchable();
                }
                this.m_6596_();
            }
        } else if (this.brewTime > 0 && this.brewTime < 400) {
            ++this.brewTime;
            if (this.f_58857_ != null && this.f_58857_.m_46467_() % 4L == 0L && this.brewTime < 370) {
                double xf = 0.5;
                double zf = 0.15;
                Direction dir = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
                if (dir.m_122434_() == Direction.Axis.X) {
                    double tmp = xf;
                    xf = zf;
                    zf = tmp;
                }
                if (dir.m_122421_() == Direction.AxisDirection.POSITIVE) {
                    xf = 1.0 - xf;
                    zf = 1.0 - zf;
                }
                this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123803_, (double)this.f_58858_.m_123341_() + xf, (double)this.f_58858_.m_123342_() + 0.34, (double)this.f_58858_.m_123343_() + zf, 0.0, -0.6, 0.0);
            }
        }
    }

    private void consumeItem(int slot) {
        ItemStack stack = this.inventory.getStackInSlot(slot);
        if (!stack.m_41619_()) {
            if (stack.hasCraftingRemainingItem()) {
                this.inventory.setStackInSlot(slot, stack.getCraftingRemainingItem().m_41777_());
            } else if (stack.m_41720_() == Items.f_42589_ || stack.m_41720_() == ModItems.failedPotion) {
                this.inventory.setStackInSlot(slot, new ItemStack((ItemLike)Items.f_42590_, stack.m_41613_()));
            } else if (stack.m_41613_() <= 1) {
                this.inventory.setStackInSlot(slot, ItemStack.f_41583_);
            } else {
                ItemStack copy = stack.m_41777_();
                copy.m_41774_(1);
                this.inventory.setStackInSlot(slot, copy);
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return LazyOptional.of(this::getInventory).cast();
            }
            return switch (side) {
                case Direction.DOWN -> this.inventoryBottom.cast();
                case Direction.UP -> this.inventoryTop.cast();
                default -> this.inventorySide.cast();
            };
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    @Nonnull
    public IItemHandlerModifiable getUnrestricted() {
        return this.inventory.getUnrestricted();
    }

    public int getBrewTime() {
        return this.brewTime;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.deserializeNBT(nbt.m_128469_("Inventory"));
        this.brewTime = nbt.m_128451_("brewTime");
        this.fuel = nbt.m_128451_("fuel");
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("brewTime", this.brewTime);
        compound.m_128405_("fuel", this.fuel);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            nbt.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
            nbt.m_128405_("brewTime", this.brewTime);
            nbt.m_128405_("fuel", this.fuel);
        }
        return nbt;
    }

    public void handleUpdateTag(@Nonnull CompoundTag nbt) {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            super.handleUpdateTag(nbt);
            this.inventory.deserializeNBT(nbt.m_128469_("Inventory"));
            this.brewTime = nbt.m_128451_("brewTime");
            this.fuel = nbt.m_128451_("fuel");
        }
    }
}

