/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.network;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.content.slime.SlimyCapability;
import de.melanx.utilitix.content.slime.StickyChunk;
import de.melanx.utilitix.network.StickyChunkUpdate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record StickyChunkRequest(ChunkPos pos) {

    public static class Serializer
    implements PacketSerializer<StickyChunkRequest> {
        public Class<StickyChunkRequest> messageClass() {
            return StickyChunkRequest.class;
        }

        public void encode(StickyChunkRequest msg, FriendlyByteBuf buffer) {
            buffer.writeInt(msg.pos.f_45578_);
            buffer.writeInt(msg.pos.f_45579_);
        }

        public StickyChunkRequest decode(FriendlyByteBuf buffer) {
            return new StickyChunkRequest(new ChunkPos(buffer.readInt(), buffer.readInt()));
        }
    }

    public static class Handler
    implements PacketHandler<StickyChunkRequest> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(StickyChunkRequest msg, Supplier<NetworkEvent.Context> ctx) {
            LevelChunk chunk;
            ServerPlayer sender = ctx.get().getSender();
            if (sender != null && sender.m_9236_().m_46805_(new BlockPos(msg.pos().m_45604_(), 0, msg.pos().m_45605_())) && (chunk = sender.m_9236_().m_6325_(msg.pos().f_45578_, msg.pos().f_45579_)) != null && chunk.f_62775_) {
                LazyOptional cap = chunk.getCapability(SlimyCapability.STICKY_CHUNK);
                cap.ifPresent(value -> UtilitiX.getNetwork().channel.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new StickyChunkUpdate(msg.pos(), (StickyChunk)value)));
            }
            return true;
        }
    }
}

