/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.melanx.utilitix.recipe.EffectTransformer;
import de.melanx.utilitix.recipe.PotionInput;
import de.melanx.utilitix.recipe.PotionOutput;
import de.melanx.utilitix.registration.ModRecipeTypes;
import de.melanx.utilitix.registration.ModRecipes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class BreweryRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    @Nullable
    private final Ingredient input;
    private final EffectTransformer transformer;

    public BreweryRecipe(ResourceLocation id, @Nullable Ingredient input, EffectTransformer transformer) {
        this.id = id;
        this.input = input;
        this.transformer = transformer;
    }

    public boolean m_5818_(@Nonnull Container inv, @Nonnull Level level) {
        if (inv.m_6643_() == 5) {
            ItemStack mainInput = inv.m_8020_(0);
            if (this.input == null && !mainInput.m_41619_() || this.input != null && !this.input.test(mainInput)) {
                return false;
            }
            return this.transformer.canTransform(new PotionInput(inv.m_8020_(3), inv.m_8020_(1), inv.m_8020_(2)));
        }
        return false;
    }

    @Nullable
    public PotionOutput getPotionResult(@Nonnull Container inv) {
        if (inv.m_6643_() == 5) {
            return this.transformer.transform(new PotionInput(inv.m_8020_(3), inv.m_8020_(1), inv.m_8020_(2)));
        }
        return null;
    }

    @Nonnull
    public ItemStack m_5874_(@Nonnull Container inv) {
        PotionOutput output = this.getPotionResult(inv);
        return output == null ? inv.m_8020_(3).m_41777_() : output.getMain();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.transformer.output();
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList nnl = NonNullList.m_122779_();
        if (this.input != null) {
            nnl.add((Object)this.input);
        }
        return nnl;
    }

    public boolean m_5598_() {
        return true;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public EffectTransformer getAction() {
        return this.transformer;
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return ModRecipeTypes.BREWERY;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.BREWERY_SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<BreweryRecipe> {
        @Nonnull
        public BreweryRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            Ingredient input = null;
            if (json.has("input")) {
                input = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("input"));
            }
            EffectTransformer transformer = EffectTransformer.deserialize(json.getAsJsonObject("action"));
            return new BreweryRecipe(recipeId, input, transformer);
        }

        @Nullable
        public BreweryRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            Ingredient input = null;
            if (buffer.readBoolean()) {
                input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            }
            EffectTransformer transformer = EffectTransformer.read(buffer);
            return new BreweryRecipe(recipeId, input, transformer);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull BreweryRecipe recipe) {
            buffer.writeBoolean(recipe.input != null);
            if (recipe.input != null) {
                recipe.input.m_43923_(buffer);
            }
            recipe.transformer.write(buffer);
        }
    }
}

